/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.ide.IdeUtils;
import certa.vics.ide.MainFrame;
import certa.vics.ide.ui.LcdDisplayEditor;
import certa.vics.lcd.LcdDisplay;
import certa.vics.lcd.LcdFont;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class StringsEditor
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    public static final int MAX_STRINGS = 10;
    static final Map<LcdFont, StringsEditor> cache = new HashMap<LcdFont, StringsEditor>();
    final LcdFont font;
    final LcdDisplayEditor lcd;
    final JComboBox<String> cmbxLinesCount;
    final JLabel lblCount;
    boolean inUpdate;
    boolean okPressed;

    public static String editString(String src, int width, LcdFont font, String title, Component owner) {
        StringsEditor dlg = StringsEditor.createDialog(font);
        dlg.setTitle(title);
        dlg.setLocationRelativeTo(owner);
        dlg.lcd.setLcdSize(width, 1);
        dlg.lcd.setLcdText(0, src);
        dlg.cmbxLinesCount.setVisible(false);
        dlg.lblCount.setVisible(dlg.cmbxLinesCount.isVisible());
        dlg.pack();
        dlg.okPressed = false;
        dlg.lcd.initFocus();
        dlg.setVisible(true);
        if (dlg.okPressed) {
            return dlg.lcd.getLcdText(0);
        }
        return null;
    }

    public static boolean editStrings(ArrayList<String> strings, boolean changeCount, int width, LcdFont font, String title, Component owner) {
        int i;
        if (strings.size() == 0) {
            return false;
        }
        StringsEditor dlg = StringsEditor.createDialog(font);
        dlg.setTitle(title);
        dlg.setLocationRelativeTo(owner);
        dlg.lcd.setLcdSize(width, strings.size());
        dlg.inUpdate = true;
        dlg.cmbxLinesCount.setSelectedIndex(strings.size() - 1);
        dlg.inUpdate = false;
        dlg.cmbxLinesCount.setVisible(changeCount);
        dlg.lblCount.setVisible(dlg.cmbxLinesCount.isVisible());
        for (i = 0; i < strings.size(); ++i) {
            dlg.lcd.setLcdText(i, strings.get(i));
        }
        dlg.pack();
        dlg.okPressed = false;
        dlg.lcd.initFocus();
        dlg.setVisible(true);
        if (dlg.okPressed) {
            strings.clear();
            for (i = 0; i < dlg.lcd.display.getRowsCount(); ++i) {
                strings.add(dlg.lcd.getLcdText(i));
            }
            return true;
        }
        return false;
    }

    private static StringsEditor createDialog(LcdFont font) {
        StringsEditor dlg = cache.get(font);
        if (dlg == null) {
            dlg = new StringsEditor(font);
            cache.put(font, dlg);
        }
        return dlg;
    }

    private StringsEditor(LcdFont font) {
        super(MainFrame.instance, "");
        final StringsEditor dialog = this;
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.okPressed = true;
                dialog.setVisible(false);
            }
        };
        ActionListener changeSize = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!StringsEditor.this.inUpdate) {
                    dialog.lcd.setLcdRows(StringsEditor.this.cmbxLinesCount.getSelectedIndex() + 1);
                    dialog.lcd.initFocus();
                    dialog.pack();
                }
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0, nogrid", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.font = font;
        this.lcd = new LcdDisplayEditor(font, 1, 1);
        this.lblCount = new JLabel("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u0442\u0440\u043e\u043a:");
        this.cmbxLinesCount = new JComboBox();
        this.cmbxLinesCount.setMaximumRowCount(10);
        for (int i = 1; i <= 10; ++i) {
            this.cmbxLinesCount.addItem(Integer.toString(i));
        }
        this.cmbxLinesCount.setSelectedIndex(this.lcd.display.getRowsCount());
        this.cmbxLinesCount.addActionListener(changeSize);
        pnlContents.add((Component)this.lblCount, "hidemode 3");
        pnlContents.add(this.cmbxLinesCount, "wrap, hidemode 3");
        pnlContents.add((Component)this.lcd, "");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(btn);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                final JFrame frame = new JFrame("LCD display editor demo");
                final LcdDisplay lcd = new LcdDisplay(LcdFont.CYRILLIC_5x8, 8, 2);
                lcd.setText(0, "Hello! #fd");
                lcd.setText(1, "\u041f\u0440\u0438\u0432\u0435\u0442_#ED");
                frame.setDefaultCloseOperation(3);
                frame.add((Component)lcd, "North");
                JButton btn = new JButton("Edit");
                btn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ArrayList<String> s = new ArrayList<String>();
                        s.add(lcd.getText(0));
                        s.add(lcd.getText(1));
                        if (StringsEditor.editStrings(s, false, 8, lcd.getLcdFont(), "Strings Editor", frame)) {
                            for (int i = 0; i < s.size(); ++i) {
                                lcd.setText(i, s.get(i));
                            }
                        }
                    }
                });
                frame.add((Component)btn, "South");
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

