/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.ui;

import certa.vics.compiler.Program;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Window;
import certa.vics.compiler.WindowString;
import certa.vics.ide.ui.AView;
import certa.vics.ide.ui.UiEditor;
import certa.vics.ide.ui.WindowView;
import certa.vics.ide.variables.VariableDef;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class GroupView
extends AView {
    public static final int RESIZE_HANDLE_WIDTH = 8;
    protected ArrayList<WindowView> windows = new ArrayList();
    protected WindowView ownerWindow;
    protected int x;
    protected int y;
    protected int width;
    protected boolean looped;
    protected int pwdLevel = -1;
    protected String pwdTitle = "\u041f\u0430\u0440\u043e\u043b\u044c:";
    public static final Stroke LOOP_STROKE = new BasicStroke(1.0f);
    public static final Font PASSWORD_FONT = new Font("Sans", 0, 11);
    AlphaComposite RELOCATE_ALPHA = AlphaComposite.getInstance(3, 0.3f);
    Color FORBIDDEN_TARGET = new Color(255, 0, 0, 128);
    Color ALLOWED_TARGET = new Color(0, 255, 0, 64);
    Color SELECT_BORDER = new Color(0, 0, 255);
    Color HOVER_BORDER = new Color(0, 255, 255);
    Color MAINGROUP_FILL = new Color(210, 210, 250);
    Color NORMAL_FILL = new Color(220, 220, 220);
    Color FOCUS_FILL = new Color(0, 180, 220);
    int x0;
    int y0;
    int width0;
    static final String JSON_LOOPED = "looped";
    static final String JSON_PWDLEVEL = "pwdlevel";
    static final String JSON_PWDTITLE = "pwdtitle";
    static final String JSON_WINDOWS = "windows";

    public String getPwdWindowName() {
        return this.ownerWindow != null ? this.ownerWindow.getName() + "pwd" : "0pwd";
    }

    public GroupView(UiEditor editor, WindowView ownerWindow) {
        super(editor);
        if (ownerWindow != null) {
            ownerWindow.setNestedGroup(this);
        }
    }

    public WindowView getOwnerWnd() {
        return this.ownerWindow;
    }

    public void setLooped(boolean loop) {
        this.looped = loop;
    }

    public void setPwdLevel(int level) {
        this.pwdLevel = level;
    }

    public void setpwdTitle(String pt) {
        this.pwdTitle = pt;
    }

    public boolean isMain() {
        return this == this.editor.mainGroup;
    }

    public ArrayList<WindowView> getList() {
        return this.windows;
    }

    public GroupView groupAt(int x, int y) {
        if (this.bounds.contains(x, y)) {
            return this;
        }
        for (WindowView w : this.windows) {
            GroupView g = w.getNestedGroup();
            if (g == null || (g = g.groupAt(x, y)) == null) continue;
            return g;
        }
        return null;
    }

    public WindowView windowAt(int x, int y) {
        for (WindowView w : this.windows) {
            WindowView w1;
            if (w.isHovered(x, y)) {
                return w;
            }
            GroupView g = w.getNestedGroup();
            if (g == null || (w1 = g.windowAt(x, y)) == null) continue;
            return w1;
        }
        return null;
    }

    public WindowView windowAtPos(int pos) {
        if (pos < 0 || pos >= this.windows.size()) {
            return null;
        }
        return this.windows.get(pos);
    }

    public void updateWidth() {
        this.width = this.windows.size();
        if (this.width <= 0) {
            this.width = 1;
        }
    }

    void updateSelfBounds() {
        if (this.x < 0) {
            this.x = 0;
        }
        if (this.y < 0) {
            this.y = 0;
        }
        this.bounds.x = this.x * UiEditor.CELL_WIDTH + 0 + 30;
        this.bounds.y = this.y * UiEditor.CELL_HEIGHT + 20 + 10;
        this.bounds.width = this.width * UiEditor.CELL_WIDTH - 0;
        this.bounds.height = UiEditor.CELL_HEIGHT - 40;
    }

    @Override
    void updateBounds() {
        this.updateSelfBounds();
        for (WindowView w : this.windows) {
            w.updateBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void paintSelf(Graphics2D g2d) {
        Composite comp = g2d.getComposite();
        boolean reloc = this.isRelocating();
        if (reloc) {
            g2d.setComposite(this.RELOCATE_ALPHA);
        }
        try {
            g2d.setColor(this.focused ? this.FOCUS_FILL : (this.isMain() ? this.MAINGROUP_FILL : this.NORMAL_FILL));
            g2d.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            if (this.looped) {
                g2d.setColor(Color.BLACK);
                g2d.setStroke(LOOP_STROKE);
                g2d.drawRoundRect(this.bounds.x - 20, this.bounds.y - 10, this.bounds.width + 40, 10 + this.bounds.height / 2, 15, 15);
            }
            if (this.isSelected()) {
                g2d.setStroke(THICK_STROKE);
                g2d.setColor(this.SELECT_BORDER);
                g2d.draw(this.bounds);
            } else if (this.parentSelected) {
                g2d.setStroke(THIN_STROKE);
                g2d.setColor(this.SELECT_BORDER);
                g2d.draw(this.bounds);
            }
            if (this.hovered && !reloc && this.editor.isRelocating()) {
                if (this.canInsertWindow()) {
                    g2d.setColor(this.ALLOWED_TARGET);
                    g2d.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                } else {
                    g2d.setColor(this.FORBIDDEN_TARGET);
                    g2d.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                    g2d.setStroke(THICK_STROKE);
                    g2d.setColor(Color.WHITE);
                    g2d.drawLine(this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width - 1, this.bounds.y + this.bounds.height - 1);
                    g2d.drawLine(this.bounds.x, this.bounds.y + this.bounds.height - 1, this.bounds.x + this.bounds.width - 1, this.bounds.y);
                }
            }
            if (this.pwdLevel >= 0) {
                g2d.setColor(Color.BLACK);
                g2d.setFont(PASSWORD_FONT);
                g2d.drawString("****", this.bounds.x, this.bounds.y);
            }
        }
        finally {
            g2d.setComposite(comp);
        }
    }

    int getDragMode(int x, int y) {
        if (this.bounds.contains(x, y)) {
            if (x - this.bounds.x <= 8) {
                return 2;
            }
            if (this.bounds.x + this.bounds.width - x <= 8) {
                return 3;
            }
            return 1;
        }
        return 0;
    }

    public boolean leftHalf(int x) {
        return x < this.bounds.x + this.bounds.width / 2;
    }

    private int firstWindowPos() {
        if (this.windows.size() > 0) {
            return this.windows.get((int)0).position;
        }
        return 0;
    }

    private int lastWindowPos() {
        if (this.windows.size() > 0) {
            return this.windows.get((int)(this.windows.size() - 1)).position;
        }
        return 0;
    }

    public boolean growLeft(int delta) {
        delta = Math.max(delta, -this.firstWindowPos());
        if ((delta = Math.min(delta, this.x)) != 0) {
            this.x -= delta;
            this.width += delta;
            for (WindowView w : this.windows) {
                w.position += delta;
            }
            this.updateBounds();
            return true;
        }
        return false;
    }

    public boolean growRight(int delta) {
        if ((delta = Math.max(delta, -(this.width - this.lastWindowPos() - 1))) != 0) {
            this.width += delta;
            this.updateBounds();
            return true;
        }
        return false;
    }

    @Override
    void startDrag(int mode, int x, int y) {
        super.startDrag(mode, x, y);
        this.x0 = this.x;
        this.y0 = this.y;
        this.width0 = this.width;
    }

    public GroupView makeClone(WindowView owner) {
        GroupView g = new GroupView(this.editor, owner);
        g.x = this.x;
        g.y = this.y;
        g.width = this.width;
        g.focused = this.focused;
        g.setLooped(this.looped);
        g.setPwdLevel(this.pwdLevel);
        g.setpwdTitle(this.pwdTitle);
        g.updateSelfBounds();
        for (WindowView w : this.windows) {
            w.makeClone(g);
        }
        return g;
    }

    void saveToJSON(JSONObject jso, List<VariableDef> vars) {
        jso.put(JSON_LOOPED, this.looped);
        jso.put(JSON_PWDLEVEL, this.pwdLevel);
        jso.put(JSON_PWDTITLE, this.pwdTitle);
        JSONArray jsa = new JSONArray();
        for (WindowView w : this.windows) {
            JSONObject t = new JSONObject();
            w.saveToJSON(t, vars);
            jsa.put(t);
        }
        jso.put(JSON_WINDOWS, jsa);
    }

    void loadFromJSON(JSONObject src) {
        this.looped = src.optBoolean(JSON_LOOPED);
        this.pwdLevel = src.optInt(JSON_PWDLEVEL);
        this.pwdTitle = src.optString(JSON_PWDTITLE);
        JSONArray jsa = src.optJSONArray(JSON_WINDOWS);
        if (jsa != null) {
            for (int i = 0; i < jsa.length(); ++i) {
                WindowView w = new WindowView(this);
                w.loadFromJSON(jsa.getJSONObject(i));
            }
        }
        this.updatePreview();
    }

    public boolean sameAs(GroupView g) {
        if (g == null) {
            return false;
        }
        if (this.x != g.x || this.y != g.y || this.width != g.width || this.windows.size() != g.windows.size()) {
            return false;
        }
        if (this.looped != g.looped) {
            return false;
        }
        if (this.pwdLevel != g.pwdLevel) {
            return false;
        }
        if (this.pwdTitle != g.pwdTitle) {
            return false;
        }
        for (int i = 0; i < this.windows.size(); ++i) {
            if (this.windows.get(i).sameAs(g.windows.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsCell(int cellX, int cellY) {
        return this.y == cellY && cellX >= this.x && cellX < this.x + this.width;
    }

    public void updateNames(String root) {
        int i = 1;
        for (WindowView w : this.windows) {
            if (root != null) {
                w.setName(root + "." + i);
            } else {
                w.setName(Integer.toString(i));
            }
            ++i;
        }
    }

    public void compileWindows(Program prg) throws SyntaxError {
        if (this.pwdLevel >= 0) {
            Window wnd = new Window(Window.WindowType.PASSWORD, this.getPwdWindowName(), prg);
            wnd.title = new WindowString(this.pwdTitle != null ? this.pwdTitle.replace(' ', '_') : null, prg.device.FONT, prg.device.DISPLAY_COLS);
            wnd.leftStr = this.ownerWindow != null ? this.ownerWindow.getName() : null;
            WindowView entry = this.getLeftmostWindow();
            wnd.rightStr = entry != null ? entry.getName() : null;
            wnd.level = this.pwdLevel;
            prg.registerWindow(wnd);
        }
        for (WindowView w : this.windows) {
            w.compileWindow(prg);
        }
    }

    public WindowView getLeftmostWindow() {
        WindowView w1 = null;
        int p = Integer.MAX_VALUE;
        for (WindowView w : this.windows) {
            if (w.position > p) continue;
            p = w.position;
            w1 = w;
        }
        return w1;
    }

    public WindowView getRightmostWindow(WindowView exclude) {
        int i = this.windows.size();
        while (--i >= 0) {
            WindowView w = this.windows.get(i);
            if (w == exclude) continue;
            return w;
        }
        return null;
    }

    public void loadWindows(Program prg, Window start) {
        Window w = start;
        if (w != null && w.type == Window.WindowType.PASSWORD) {
            this.pwdLevel = w.level;
            this.pwdTitle = w.title != null ? w.title.Source : null;
            w = w.rightLink;
        }
        block0: while (w != null) {
            WindowView wv = new WindowView(this);
            wv.name = w.Name;
            wv.loadWindow(prg, w);
            if (w.rightLink != w) {
                w = w.rightLink;
                for (WindowView win : this.windows) {
                    if (!win.name.equalsIgnoreCase(w.Name)) continue;
                    this.looped = true;
                    w = null;
                    continue block0;
                }
                continue;
            }
            w = null;
        }
        this.updateWidth();
        this.updatePreview();
        this.updateBounds();
    }

    public int arrange(int x, int y) {
        int i;
        this.x = x;
        this.y = y;
        for (i = 0; i < this.windows.size(); ++i) {
            this.windows.get(i).setPosition(i);
        }
        this.updatePreview();
        this.updateWidth();
        this.updateBounds();
        for (i = this.windows.size() - 1; i >= 0; --i) {
            WindowView w = this.windows.get(i);
            GroupView g = w.getNestedGroup();
            if (g == null) continue;
            y = g.arrange(x + w.position, y + 1);
        }
        return y;
    }

    public void moveRight(int windowPos) {
        if (windowPos < this.windows.size() - 1) {
            WindowView w = this.windows.remove(windowPos);
            this.windows.add(windowPos + 1, w);
        }
    }

    public void moveLeft(int windowPos) {
        if (windowPos > 0) {
            WindowView w = this.windows.remove(windowPos);
            this.windows.add(windowPos - 1, w);
        }
    }

    public void removeWindow(WindowView w) {
        this.windows.remove(w);
    }

    public boolean canInsertWindow() {
        WindowView w = this.getLeftmostWindow();
        return w == null || w.canHaveSiblings();
    }

    boolean isSelectedAnyWay() {
        if (this.isSelected()) {
            return true;
        }
        if (this.ownerWindow != null) {
            return this.ownerWindow.isSelectedAnyWay();
        }
        return false;
    }

    boolean isRelocating() {
        if (this.editor.isRelocating()) {
            return this.isSelectedAnyWay();
        }
        return false;
    }

    @Override
    void updateSelection() {
        for (WindowView w : this.windows) {
            w.parentSelected = this.parentSelected || this.isSelected();
            w.updateSelection();
        }
    }

    public void relocateTo(WindowView target) {
        if (this.ownerWindow != null) {
            this.ownerWindow.setNestedGroup(null);
        }
        target.setNestedGroup(this);
    }

    protected void updatePreview() {
        for (int i = 0; i < this.windows.size(); ++i) {
            this.windows.get((int)i).position = i;
        }
        for (WindowView w : this.windows) {
            w.updatePreview();
        }
    }
}

