/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.ide.DialogErrorLabel;
import certa.vics.ide.IdeUtils;
import certa.vics.ide.Main;
import certa.vics.ide.MainFrame;
import certa.vics.ide.NumberTextField;
import certa.vics.ide.fbd.FbdNumber;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class NumberEditDialog
extends IdeUtils.IdeDialog {
    private static final long serialVersionUID = 1L;
    private static NumberEditDialog dialog;
    boolean okPressed;
    JButton btnOk;
    JLabel lblType;
    NumberTextField tfValue;
    JLabel lblValueError;

    public static boolean showDialog(FbdNumber block, Component owner, int screenX, int screenY) {
        if (dialog == null) {
            dialog = new NumberEditDialog(MainFrame.instance);
        }
        NumberEditDialog.dialog.tfValue.requestFocusInWindow();
        NumberEditDialog.dialog.okPressed = false;
        dialog.setControls(block);
        Main.setDlgLocation(dialog, owner, screenX, screenY);
        dialog.setVisible(true);
        if (NumberEditDialog.dialog.okPressed) {
            dialog.updateBlock(block);
            return true;
        }
        return false;
    }

    public NumberEditDialog(JFrame parent) {
        super(parent, "\u0427\u0438\u0441\u043b\u043e");
        ActionListener cancel = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        ActionListener ok = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.okPressed = true;
                dialog.setVisible(false);
            }
        };
        ActionListener update = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NumberEditDialog.this.validData();
            }
        };
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("", "[grow]", "[grow][nogrid]"));
        JPanel pnlContents = new JPanel();
        pnlContents.setLayout(new MigLayout("insets 0 0 n 0", "", ""));
        pane.add((Component)pnlContents, "alignx center,wrap");
        this.lblType = new JLabel("type");
        this.lblValueError = new DialogErrorLabel("Error");
        this.tfValue = new NumberTextField(8, 3, this.lblValueError, update);
        pnlContents.add((Component)this.lblType, "gaptop 4px, alignx center, wrap");
        pnlContents.add((Component)this.tfValue, "gaptop 4px, alignx center");
        pnlContents.add((Component)this.lblValueError, "newline, span, hidemode 3");
        JButton btn = new JButton("\u041e\u0442\u043c\u0435\u043d\u0430");
        btn.addActionListener(cancel);
        pane.add((Component)btn, "tag cancel");
        btn = this.btnOk = new JButton("\u041e\u041a");
        btn.addActionListener(ok);
        pane.add((Component)btn, "tag ok");
        this.getRootPane().setDefaultButton(this.btnOk);
        this.getRootPane().registerKeyboardAction(cancel, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        this.setResizable(false);
    }

    void setControls(FbdNumber block) {
        this.tfValue.valueType = block.outPin.type;
        if (this.tfValue.valueType == 1) {
            this.lblType.setText("\u041b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u043e\u0435 (B)");
        } else if (this.tfValue.valueType == 2) {
            this.lblType.setText("\u0426\u0435\u043b\u043e\u0435 (I)");
        } else {
            this.lblType.setText("\u0412\u0435\u0449\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (F)");
        }
        double v = block.value;
        this.tfValue.setValue(Double.isNaN(v) ? 0.0 : v);
        this.tfValue.selectAll();
    }

    void updateBlock(FbdNumber block) {
        block.setValue(this.tfValue.value);
    }

    boolean validData() {
        boolean ok = this.tfValue.validData();
        this.btnOk.setEnabled(ok);
        this.pack();
        return ok;
    }
}

