/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.FbdConstants;
import certa.vics.ide.fbd.FbdPage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AFbdView
implements FbdConstants {
    static final float[] dash1 = new float[]{4.0f, 2.0f};
    static final Stroke FOCUS_STROKE = new BasicStroke(3.0f, 0, 0, 10.0f, dash1, 0.0f);
    static final Color FOCUS_COLOR = new Color(0, 255, 0);
    static final Stroke SELECTED_STROKE = new BasicStroke(3.0f);
    static final Color SELECTED_COLOR = Color.BLUE;
    static final Stroke SHAPE_STROKE = new BasicStroke(1.0f);
    public final FbdPage page;
    protected Rectangle pxBounds = new Rectangle();
    protected boolean selected;

    public AFbdView(FbdPage page) throws JSONException, FbdLoadError {
        this.page = page;
    }

    public abstract void saveToJson(JSONObject var1) throws JSONException;

    public boolean containsPx(int x, int y) {
        return this.pxBounds.contains(x, y);
    }

    protected void setPxPosition(int x, int y) {
        if (this.pxBounds.x != x || this.pxBounds.y != y) {
            this.pxBounds.x = x;
            this.pxBounds.y = y;
            this.markModified();
        }
    }

    protected void setPxSize(int w, int h) {
        if (this.pxBounds.width != w || this.pxBounds.height != h) {
            this.pxBounds.width = w;
            this.pxBounds.height = h;
            if (this.pxBounds.width < 20) {
                this.pxBounds.width = 20;
            }
            if (this.pxBounds.height < 20) {
                this.pxBounds.height = 20;
            }
            this.markModified();
        }
    }

    public void markModified() {
        this.page.markModified();
    }

    protected void paintFocus(Graphics2D g2d) {
        if (this.selected) {
            g2d.setColor(SELECTED_COLOR);
            g2d.setStroke(SELECTED_STROKE);
            g2d.drawRect(this.pxBounds.x, this.pxBounds.y, this.pxBounds.width, this.pxBounds.height);
        }
        if (this.page != null && this.page.editor.focusedView == this) {
            g2d.setColor(FOCUS_COLOR);
            g2d.setStroke(FOCUS_STROKE);
            g2d.drawRect(this.pxBounds.x - 2, this.pxBounds.y - 2, this.pxBounds.width + 4, this.pxBounds.height + 4);
        }
    }

    public abstract void paintShape(Graphics2D var1);
}

