/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide.fbd;

import certa.vics.compiler.SyntaxError;
import certa.vics.ide.FbdLoadError;
import certa.vics.ide.fbd.AFbdPin;
import certa.vics.ide.fbd.AFbdView;
import certa.vics.ide.fbd.FbdPage;
import certa.vics.ide.fbd.OutputPin;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AFbdItem
extends AFbdView {
    static final String JSON_X = "x";
    static final String JSON_Y = "y";
    protected int padLeft = 0;
    protected int padTop = 0;
    protected Rectangle cellBounds = new Rectangle();

    public AFbdItem(FbdPage page, JSONObject src) throws JSONException, FbdLoadError {
        super(page);
        if (src != null) {
            this.cellBounds.x = src.getInt(JSON_X);
            this.cellBounds.y = src.getInt(JSON_Y);
        }
        this.init(src);
        this.updateBounds();
    }

    protected abstract void init(JSONObject var1) throws JSONException, FbdLoadError;

    @Override
    public void saveToJson(JSONObject jso) throws JSONException {
        jso.put(JSON_X, this.cellBounds.x);
        jso.put(JSON_Y, this.cellBounds.y);
    }

    public void setCellPosition(int cx, int cy) {
        if (this.cellBounds.x != cx || this.cellBounds.y != cy) {
            this.cellBounds.x = cx;
            this.cellBounds.y = cy;
            this.updateBounds();
            this.markModified();
        }
    }

    public abstract void updateBounds();

    protected abstract void resolveLinks(boolean var1) throws FbdLoadError;

    public OutputPin getOutput(int index) {
        return null;
    }

    public int getOutputIndex(OutputPin pin) {
        return -1;
    }

    public abstract void compileOutputVars() throws SyntaxError;

    public abstract void compileInputVars() throws SyntaxError;

    public boolean pushX(boolean right) {
        int cx;
        boolean res = true;
        int n = cx = right ? this.cellBounds.x + this.cellBounds.width : this.cellBounds.x - 1;
        if (cx < 0) {
            return false;
        }
        for (int cy = this.cellBounds.y; res && cy < this.cellBounds.y + this.cellBounds.height; ++cy) {
            AFbdItem t = this.page.getItemAtCell(cx, cy);
            if (t == null || t == this) continue;
            res = res && t.pushX(right);
        }
        if (res) {
            this.setCellPosition(this.cellBounds.x + (right ? 1 : -1), this.cellBounds.y);
        }
        return res;
    }

    public boolean pushY(boolean down) {
        int cy;
        boolean res = true;
        int n = cy = down ? this.cellBounds.y + this.cellBounds.height : this.cellBounds.y - 1;
        if (cy < 0) {
            return false;
        }
        for (int cx = this.cellBounds.x; res && cx < this.cellBounds.x + this.cellBounds.width; ++cx) {
            AFbdItem t = this.page.getItemAtCell(cx, cy);
            if (t == null || t == this) continue;
            res = res && t.pushY(down);
        }
        if (res) {
            this.setCellPosition(this.cellBounds.x, this.cellBounds.y + (down ? 1 : -1));
        }
        return res;
    }

    public abstract void paintLinks(Graphics2D var1);

    public AFbdPin getPinAt(int x, int y) {
        return null;
    }

    public AFbdPin getPinAt(Rectangle r) {
        return null;
    }

    public abstract void disconnectAll();
}

