/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.ide;

import certa.vics.Utils;
import certa.vics.ide.CommSettingsPanel;
import certa.vics.ide.FlashDialog;
import certa.vics.tools.Flash;
import java.util.List;
import javax.swing.SwingWorker;
import ua.com.certa.modbus.client.ModbusClientTransport;
import ua.com.certa.modbus.client.RtuOverTcpTransport;
import ua.com.certa.modbus.client.RtuTransportJssc;
import ua.com.certa.modbus.client.TcpTransport;

class FlashThread
extends SwingWorker<Void, Integer>
implements Flash.ProgressListener {
    private final FlashDialog dialog;
    private final Flash program;
    ModbusClientTransport transport;
    int id;
    private String result = null;

    public FlashThread(FlashDialog dialog, Flash program) throws Exception {
        this.dialog = dialog;
        this.program = program;
        dialog.progressBar.setMaximum(program.initWriteProgress());
        dialog.progressBar.setValue(0);
        CommSettingsPanel comm = dialog.pnlComm;
        if (comm.isRtu()) {
            this.transport = new RtuTransportJssc(comm.getPortName(), comm.getBaudRate(), 8, comm.getParity(), comm.getStopBits(), 1000, 10);
        } else if (comm.isTcp()) {
            this.transport = new TcpTransport(comm.getTcpHost(), comm.getTcpPort(), null, 0, 10000, 1000, 20, true);
        } else if (comm.isRtuOverTcp()) {
            this.transport = new RtuOverTcpTransport(comm.getTcpHost(), comm.getTcpPort(), null, 0, 10000, 1000, 20, true);
        } else {
            throw new Exception("Unknown transport");
        }
        this.id = comm.getDeviceId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        this.program.registerProgListener(this);
        try {
            try {
                this.program.flashBinaryData(this.transport, this.id, 2691);
            }
            catch (Throwable ex) {
                Utils.ProcessException(ex, false);
                this.result = FlashDialog.errorMessage(ex);
            }
        }
        finally {
            this.program.registerProgListener(null);
        }
        return null;
    }

    @Override
    public void done() {
        this.dialog.flashDone(this.result);
    }

    @Override
    protected void process(List<Integer> steps) {
        Integer step = steps.get(steps.size() - 1);
        this.dialog.progressBar.setValue(step);
    }

    @Override
    public void updateStep(int step) {
        this.publish(step);
    }
}

