/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.Program;
import certa.vics.compiler.StringList;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.WindowString;

public class Window {
    public int startAddress;
    private Program program;
    public final String Name;
    public WindowType type;
    public WindowString title = null;
    public WindowString text = null;
    public StringList strings = null;
    public int level = 0;
    public int titleDigits = 0;
    public int digits = 0;
    public int min = 0;
    public int max = 0;
    public Variable titleVar = null;
    public Variable var = null;
    public Variable visible = null;
    public Window upLink = null;
    public Window downLink = null;
    public Window leftLink = null;
    public Window rightLink = null;
    public String upStr = null;
    public String downStr = null;
    public String leftStr = null;
    public String rightStr = null;
    private String varStr = null;
    private String titleVarStr = null;
    private String visibleStr = null;
    public static String PAR_TITLE = "title";
    public static String PAR_TEXT = "text";
    public static String PAR_VAR = "var";
    public static String PAR_TITLE_VAR = "titlevar";
    public static String PAR_VISIBLE_VAR = "visible";
    public static String PAR_STRINGS = "strings";
    public static String PAR_PWD_LEVEL = "level";
    public static String PAR_DIGITS = "digits";
    public static String PAR_TITLE_DIGITS = "titledigits";
    public static String PAR_MIN = "min";
    public static String PAR_MAX = "max";
    public static String PAR_UP = "up";
    public static String PAR_DOWN = "down";
    public static String PAR_LEFT = "left";
    public static String PAR_RIGHT = "right";

    public Window(String fullName, Program program) throws SyntaxError {
        this.program = program;
        fullName = fullName.trim();
        int p = fullName.indexOf(46);
        if (p <= 0 || p >= fullName.length() - 1) {
            throw new SyntaxError("Invalid window name: \"" + fullName + "\". Must be <type>.<name>");
        }
        String typeName = fullName.substring(0, p);
        this.type = WindowType.fromString(typeName);
        if (this.type == null) {
            throw new SyntaxError("Invalid window type: " + typeName + ". Must be: " + WindowType.getList());
        }
        this.Name = fullName.substring(p + 1, fullName.length());
    }

    public Window(WindowType type, String name, Program program) {
        this.type = type;
        this.Name = name;
        this.program = program;
    }

    private Window locateWindow(String name) throws SyntaxError {
        if (name != null) {
            return this.program.locateWindow(name);
        }
        return this;
    }

    private Variable locateVar(String name, Variable def) throws SyntaxError {
        if (name != null) {
            return this.program.locateVar(name);
        }
        return def;
    }

    public void resolveLinks() throws SyntaxError {
        this.upLink = this.locateWindow(this.upStr);
        this.downLink = this.locateWindow(this.downStr);
        this.leftLink = this.locateWindow(this.leftStr);
        this.rightLink = this.locateWindow(this.rightStr);
        this.var = this.locateVar(this.varStr, this.var);
        this.titleVar = this.locateVar(this.titleVarStr, this.titleVar);
        this.visible = this.locateVar(this.visibleStr, this.visible);
        if (this.visible != null && this.visible.type != 1) {
            throw new SyntaxError("Variable must be boolean (" + this.visible.fullName() + ")");
        }
        this.upStr = null;
        this.downStr = null;
        this.leftStr = null;
        this.rightStr = null;
        this.varStr = null;
        this.titleVarStr = null;
        this.visibleStr = null;
        this.validate();
    }

    public String fullName() {
        return this.type.toString() + "." + this.Name;
    }

    public boolean canLinkDown() {
        return this.type == WindowType.DISP_NUM || this.type == WindowType.DISP_TEXT || this.type == WindowType.STATIC || this.type == WindowType.PASSWORD;
    }

    public boolean canLinkLeftRight() {
        return this.type != WindowType.PASSWORD && this.type != WindowType.TABLEEDIT;
    }

    private int decodeDigits(String s) throws SyntaxError {
        int d = Program.decodeInt(s, "Invalid number");
        if (d < 0 || d > 3) {
            throw new SyntaxError("Invalid digits count: " + d + ". Must be 0, 1, 2, 3");
        }
        return d;
    }

    private void validateLevel() throws SyntaxError {
        if (this.level < 0 || this.level > 2) {
            throw new SyntaxError("Invalid password level: " + this.level + ". Must be 0, 1, 2");
        }
    }

    public void setPwdLevel(int level) throws SyntaxError {
        this.level = level;
        this.validateLevel();
    }

    public void setParam(String paramName, String value) throws SyntaxError {
        if (paramName.equalsIgnoreCase(PAR_TITLE)) {
            this.title = new WindowString(value, this.program.device.FONT, this.program.device.DISPLAY_COLS);
        } else if (paramName.equalsIgnoreCase(PAR_TEXT)) {
            this.text = new WindowString(value, this.program.device.FONT, this.program.device.DISPLAY_COLS);
        } else if (paramName.equalsIgnoreCase(PAR_VAR)) {
            this.varStr = value.equals("0") ? null : value + (this.type == WindowType.TABLEEDIT ? "[0]" : "");
        } else if (paramName.equalsIgnoreCase(PAR_TITLE_VAR)) {
            this.titleVarStr = value.equals("0") ? null : value + "[0]";
        } else if (paramName.equalsIgnoreCase(PAR_VISIBLE_VAR)) {
            this.visibleStr = value.equals("0") ? null : value;
        } else if (paramName.equalsIgnoreCase(PAR_STRINGS)) {
            this.strings = value.equals("0") ? null : this.program.locateStrings(value);
        } else if (paramName.equalsIgnoreCase(PAR_PWD_LEVEL)) {
            this.setPwdLevel(Program.decodeInt(value, "Invalid number"));
        } else if (paramName.equalsIgnoreCase(PAR_DIGITS)) {
            this.digits = this.decodeDigits(value);
        } else if (paramName.equalsIgnoreCase(PAR_TITLE_DIGITS)) {
            this.titleDigits = this.decodeDigits(value);
        } else if (paramName.equalsIgnoreCase(PAR_MIN)) {
            this.min = Program.decodeInt(value, "Invalid number");
        } else if (paramName.equalsIgnoreCase(PAR_MAX)) {
            this.max = Program.decodeInt(value, "Invalid number");
        } else if (paramName.equalsIgnoreCase(PAR_UP)) {
            this.upStr = value.equals("0") ? null : value;
        } else if (paramName.equalsIgnoreCase(PAR_DOWN)) {
            this.downStr = value.equals("0") ? null : value;
        } else if (paramName.equalsIgnoreCase(PAR_LEFT)) {
            this.leftStr = value.equals("0") ? null : value;
        } else if (paramName.equalsIgnoreCase(PAR_RIGHT)) {
            this.rightStr = value.equals("0") ? null : value;
        }
    }

    public void validate() throws SyntaxError {
        if (this.type != WindowType.STATIC && this.type != WindowType.PASSWORD && this.var == null) {
            throw new SyntaxError(this.Name + ": Var is empty");
        }
        if (this.type == WindowType.TABLEEDIT) {
            if (this.titleVar == null) {
                throw new SyntaxError(this.Name + ": TitleVar is empty");
            }
            if (this.var.type != 3 || this.var.arrayItems == null) {
                throw new SyntaxError(this.Name + ": Var must be float array");
            }
            if (this.titleVar.type != 3 || this.titleVar.arrayItems == null) {
                throw new SyntaxError(this.Name + ": TitleVar must be float array");
            }
            if (this.titleVar.arrayItems.length != this.var.arrayItems.length) {
                throw new SyntaxError(this.Name + ": Sizes of Var and TitleVar must be equal");
            }
        } else if (this.title == null) {
            throw new SyntaxError(this.Name + ": Title is empty");
        }
    }

    public int getSize() {
        if (this.type == WindowType.STATIC) {
            return 27;
        }
        if (this.type == WindowType.DISP_NUM) {
            return 22;
        }
        if (this.type == WindowType.DISP_TEXT) {
            return 24;
        }
        if (this.type == WindowType.EDIT_NUM) {
            return this.var.type == 1 ? 20 : 24;
        }
        if (this.type == WindowType.EDIT_TEXT) {
            return this.var.type == 1 ? 22 : 23;
        }
        if (this.type == WindowType.INST_EDIT) {
            return this.var.type == 1 ? 20 : 24;
        }
        if (this.type == WindowType.PASSWORD) {
            return 16;
        }
        if (this.type == WindowType.TABLEEDIT) {
            return 17;
        }
        throw new IllegalStateException("Invalid window type: " + (Object)((Object)this.type));
    }

    public static enum WindowType {
        STATIC("static"),
        DISP_NUM("dispNum"),
        DISP_TEXT("dispText"),
        EDIT_NUM("editNum"),
        EDIT_TEXT("editText"),
        INST_EDIT("instEdit"),
        PASSWORD("password"),
        TABLEEDIT("tableEdit");

        private final String syntax;

        private WindowType(String name) {
            this.syntax = name;
        }

        public String toString() {
            return this.syntax;
        }

        public static WindowType fromString(String typeName) {
            for (WindowType t : WindowType.values()) {
                if (!typeName.equalsIgnoreCase(t.toString())) continue;
                return t;
            }
            return null;
        }

        public static String getList() {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            for (WindowType t : WindowType.values()) {
                if (count++ > 0) {
                    sb.append(", ");
                }
                sb.append(t.toString());
            }
            return sb.toString();
        }
    }
}

