/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import java.util.LinkedHashMap;
import java.util.Map;

public class VariablesBlock {
    public final String name;
    public final String memType;
    public final boolean readOnly;
    public int startAddress;
    public final Map<String, Variable> map = new LinkedHashMap<String, Variable>();
    private Variable lastVar;

    public VariablesBlock(String name, String memType, boolean readOnly) {
        this.name = name;
        this.memType = memType;
        this.readOnly = readOnly;
    }

    public void clear() {
        this.map.clear();
        this.lastVar = null;
    }

    protected void registerVariable(Variable var) throws SyntaxError {
        String key = var.name.toUpperCase();
        if (this.map.containsKey(key)) {
            throw new SyntaxError("Duplicate variable \"" + var.name + "\" in \"" + this.name + "\"");
        }
        this.map.put(key, var);
        this.lastVar = var;
    }

    public Variable createSimpleVar(String name, int type, boolean hidden, int offset) throws SyntaxError {
        return new Variable(hidden, name, type, offset >= 0 ? offset : this.getSize(), this, null, 0, 0, null);
    }

    public Variable createArrayVar(String name, int type, int arraySize, VariablesBlock constBlock) throws SyntaxError {
        return new Variable(false, name, type, this.getSize(), this, null, 0, arraySize, constBlock);
    }

    public Variable createArrayItemVar(Variable arrayStart, int index) throws SyntaxError {
        return new Variable(true, arrayStart.arrayName + "[" + index + "]", arrayStart.type, this.getSize(), this, arrayStart, index, 0, null);
    }

    public Variable locateVar(String name, int type) {
        Variable var;
        int p = name.indexOf(".size");
        if (p > 0) {
            name = name.substring(0, p) + "[0]";
        }
        if ((var = this.map.get(name.toUpperCase())) != null && var.type == type) {
            if (p > 0) {
                return var.arraySizeVar;
            }
            return var;
        }
        return null;
    }

    public int getSize() {
        if (this.lastVar != null) {
            return this.lastVar.offset + this.lastVar.getSize();
        }
        return 0;
    }

    public String toString() {
        return this.memType;
    }
}

