/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.compiler.Device;
import certa.vics.compiler.WindowString;
import java.util.ArrayList;
import org.json.JSONArray;

public class StringList {
    public final String Name;
    public final ArrayList<WindowString> Strings = new ArrayList();
    public int startAddress;
    private static int COUNTER = 1;

    public static boolean isEmpty(StringList sl) {
        if (sl == null) {
            return true;
        }
        return sl.Strings.size() == 0;
    }

    public StringList(String name) {
        this.Name = name;
    }

    public StringList(StringList src, Device dev) {
        this.Name = "LIST_" + COUNTER++;
        if (!StringList.isEmpty(src)) {
            for (WindowString s : src.Strings) {
                this.Strings.add(new WindowString(s.Source, dev.FONT, dev.STRING_SIZE));
            }
        } else {
            this.Strings.add(new WindowString(null, dev.FONT, dev.STRING_SIZE));
        }
    }

    public StringList(JSONArray src, Device dev) {
        this.Name = "LIST_" + COUNTER++;
        for (int i = 0; i < src.length(); ++i) {
            this.Strings.add(new WindowString(src.getString(i), dev.FONT, dev.STRING_SIZE));
        }
    }

    public void ensureSize(int size, Device dev) {
        while (this.Strings.size() > size) {
            this.Strings.remove(this.Strings.size() - 1);
        }
        while (this.Strings.size() < size) {
            this.Strings.add(new WindowString(null, dev.FONT, dev.STRING_SIZE));
        }
    }

    public int count() {
        return this.Strings.size();
    }

    public int getBytesCount() {
        int size = 0;
        for (WindowString ws : this.Strings) {
            size += ws.Bytes.length;
        }
        return size;
    }

    public void saveToJSON(JSONArray jsa) {
        for (WindowString s : this.Strings) {
            jsa.put(s.Source);
        }
    }
}

