/*
 * Decompiled with CFR 0.152.
 */
package certa.vics.compiler;

import certa.vics.Utils;
import certa.vics.compiler.Argument;
import certa.vics.compiler.ArgumentDef;
import certa.vics.compiler.CodeBlock;
import certa.vics.compiler.Command;
import certa.vics.compiler.CommandDef;
import certa.vics.compiler.Device;
import certa.vics.compiler.ErrorInFile;
import certa.vics.compiler.ModbusBlock;
import certa.vics.compiler.ModbusReg;
import certa.vics.compiler.StringList;
import certa.vics.compiler.SyntaxError;
import certa.vics.compiler.Variable;
import certa.vics.compiler.VariablesBlock;
import certa.vics.compiler.Window;
import certa.vics.compiler.WindowString;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.MalformedInputException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Program {
    public static final int CURRENT_FILE_VERSION = 1;
    public static final String ZIP_ENTRY_NAME = "program";
    public static final int CURRENT_COMPILER_VERSION = 1;
    public static final String[] KEYS = new String[]{"UPDOWN", "LEFTRIGHT", "DOWNLEFT", "UPRIGHT"};
    public final VariablesBlock Constants = new VariablesBlock("Const", "Flash", true);
    public final VariablesBlock RamVars = new VariablesBlock("Ram", "RAM", false);
    public final VariablesBlock ExtVars = new VariablesBlock("Ext", "NVRAM", false);
    public final VariablesBlock StoreVars = new VariablesBlock("Store", "EEPROM", false);
    VariablesBlock[] AllVars;
    VariablesBlock[] SysVars;
    VariablesBlock[] UserVars;
    public final CodeBlock MainCode = new CodeBlock("Main");
    public final LinkedHashMap<String, CodeBlock> Subs = new LinkedHashMap();
    public final LinkedHashMap<String, StringList> Strings = new LinkedHashMap();
    public final LinkedHashMap<String, Window> Windows = new LinkedHashMap();
    public Window firstWindow = null;
    public final Window[] keyWindows = new Window[4];
    public final ModbusBlock Modbus = new ModbusBlock();
    public final ArrayList<String> codeSource = new ArrayList();
    public final ArrayList<String> lastComments = new ArrayList();
    public String extraData;
    public String id = "";
    public int codeCrc = 0;
    public String comment = "";
    public int fileVersion;
    public Device device;
    protected String SourceFile;
    ParseState State;
    public int flashGapOffset;
    public int flashGapSize;
    public byte[] flash;
    public byte[] store;
    public byte[] ext;
    public static final String DUMB_VAR_NAME = "___DUMB";
    boolean saveRaw;
    int lineNum;
    public static final String UTF8_BOM = "\ufeff";
    private String[] tokens;
    private int tokenIndex;
    private StringBuilder sbExtraData = new StringBuilder();
    private VariablesBlock varBlock;
    private Variable varCurrent;
    private boolean varInitOnly;
    private int arrayValueIndex;
    private int mbRegType;
    private int mbRegAddr;
    private String mbVar;
    private CodeBlock codeBlock;
    private CommandDef retCommand;
    private Command codeItem;
    private int codeArgIndex;
    private int codeArrSize;
    private int codeArrIndex;
    private StringList stringList;
    private Window window;
    private String windowParam;
    private int keyWindowIndex;

    public Program() {
        this.clear(false);
    }

    public Program(Device dev) {
        this.clear(false);
        this.assignDevice(dev);
    }

    public void clear(boolean preserveDevice) {
        if (!preserveDevice) {
            this.device = null;
            this.AllVars = null;
            this.SysVars = null;
            this.UserVars = null;
        }
        this.clearVars();
        this.Strings.clear();
        this.Windows.clear();
        this.firstWindow = null;
        Arrays.fill(this.keyWindows, null);
        this.clearCode();
        this.extraData = "";
    }

    public void clearVars() {
        this.RamVars.clear();
        try {
            this.Modbus.clear(this.RamVars.createSimpleVar(DUMB_VAR_NAME, 2, true, -1));
        }
        catch (SyntaxError e) {
            throw new Error(e);
        }
        this.ExtVars.clear();
        this.Constants.clear();
        this.StoreVars.clear();
    }

    protected void clearCode() {
        this.codeSource.clear();
        this.lastComments.clear();
        this.saveRaw = false;
        this.MainCode.clear();
        this.Subs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(String fileName, boolean resolve) throws IOException, ErrorInFile {
        Path path = Paths.get(fileName, new String[0]).toRealPath(new LinkOption[0]);
        Charset charset = Charset.forName("UTF-8");
        BufferedReader reader = null;
        ZipFile zip = null;
        try {
            zip = new ZipFile(path.toFile());
        }
        catch (ZipException e) {
            reader = Files.newBufferedReader(path, charset);
        }
        if (zip != null) {
            ZipEntry ze = zip.getEntry(ZIP_ENTRY_NAME);
            reader = new BufferedReader(new InputStreamReader(zip.getInputStream(ze), charset));
        }
        try {
            this.load(reader, resolve, path.toString());
        }
        finally {
            reader.close();
            if (zip != null) {
                zip.close();
            }
        }
    }

    public void load(BufferedReader reader, boolean resolve, String file) throws IOException, ErrorInFile {
        this.SourceFile = file;
        this.lineNum = 1;
        this.State = ParseState.PARSE_START;
        this.fileVersion = 0;
        try {
            this.clear(false);
            this.sbExtraData.setLength(0);
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(UTF8_BOM)) {
                    line = line.substring(1);
                }
                this.parseLine(line, false);
                ++this.lineNum;
            }
            if (this.State != ParseState.PARSE_END) {
                throw new SyntaxError("Unexpected end of file (End is required)");
            }
            this.extraData = this.sbExtraData.toString().trim();
            this.lineNum = 0;
            if (resolve) {
                if (!Utils.strEmpty(this.extraData)) {
                    throw new SyntaxError("This is not ViCS file");
                }
                this.resolveLinks();
            }
        }
        catch (MalformedInputException e) {
            throw new ErrorInFile(this.SourceFile, this.lineNum, "Invalid file charset (must be UTF-8)");
        }
        catch (SyntaxError e) {
            throw new ErrorInFile(this.SourceFile, e.line > 0 ? e.line : this.lineNum, e);
        }
        catch (Exception e) {
            throw new ErrorInFile(this.SourceFile, this.lineNum, e, true);
        }
        this.checkAllCode();
        this.trimSource();
    }

    public void resolveLinks() throws SyntaxError {
        for (Window w : this.Windows.values()) {
            w.resolveLinks();
        }
        this.Modbus.resolveLinks(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCode(String[] lines) throws ErrorInFile {
        String t = this.SourceFile;
        this.SourceFile = "Code";
        try {
            this.lineNum = 1;
            this.State = ParseState.BLOCK_BEGIN;
            try {
                this.clearCode();
                for (String s : lines) {
                    this.parseLine(s, true);
                    ++this.lineNum;
                }
            }
            catch (SyntaxError e) {
                throw new ErrorInFile(this.SourceFile, this.lineNum, e);
            }
            catch (Exception e) {
                throw new ErrorInFile(this.SourceFile, this.lineNum, e, true);
            }
            this.checkAllCode();
            this.trimSource();
        }
        finally {
            this.SourceFile = t;
        }
    }

    protected void parseLine(String line, boolean onlyCode) throws FileNotFoundException, SyntaxError, IOException, ErrorInFile {
        if (this.State == ParseState.PARSE_END) {
            this.sbExtraData.append(line);
            this.sbExtraData.append('\n');
            return;
        }
        String rawLine = line;
        if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("//")) {
            this.lastComments.add(rawLine);
        } else {
            this.tokens = line.split("\\s+");
            this.tokenIndex = 0;
            while (this.tokenIndex < this.tokens.length && this.State != ParseState.PARSE_END) {
                this.State = this.parseToken(this.tokens[this.tokenIndex], onlyCode);
                ++this.tokenIndex;
            }
            if (this.saveRaw) {
                this.codeSource.addAll(this.lastComments);
                this.codeSource.add(rawLine);
            }
            this.lastComments.clear();
        }
    }

    private void checkAllCode() throws ErrorInFile {
        this.checkCode(this.MainCode);
        for (CodeBlock sub : this.Subs.values()) {
            this.checkCode(sub);
        }
    }

    private void checkCode(CodeBlock cb) throws ErrorInFile {
        int line = 0;
        try {
            for (Command ci : cb.Items) {
                line = ci.srcLine;
                for (Argument arg : ci.Args) {
                    if (arg.Type == 3) {
                        this.resolveLabel((String)arg.Value, cb);
                        continue;
                    }
                    if (arg.Type != 4) continue;
                    this.resolveSub((String)arg.Value);
                }
            }
        }
        catch (SyntaxError e) {
            throw new ErrorInFile(this.SourceFile, line, e);
        }
    }

    protected void trimSource() {
        while (this.codeSource.size() > 0 && this.codeSource.get(0).trim().length() == 0) {
            this.codeSource.remove(0);
        }
    }

    public String getSourceFile() {
        return this.SourceFile;
    }

    private void processVersion(String s) throws SyntaxError {
        try {
            this.fileVersion = Integer.decode(s);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError("Invalid file version: " + s);
        }
        if (this.fileVersion > 1) {
            throw new SyntaxError("File was made by newer version of editor");
        }
    }

    private void assignDevice(Device dev) {
        this.device = dev;
        this.AllVars = new VariablesBlock[]{this.device.SysInVars, this.device.SysOutVars, this.device.SysStoreVars, this.device.SysExtVars, this.Constants, this.RamVars, this.ExtVars, this.StoreVars};
        this.SysVars = new VariablesBlock[]{this.device.SysInVars, this.device.SysOutVars, this.device.SysStoreVars, this.device.SysExtVars};
        this.UserVars = new VariablesBlock[]{this.Constants, this.RamVars, this.ExtVars, this.StoreVars};
    }

    private VariablesBlock locateBlock(VariablesBlock[] blocks, String name) {
        if (blocks != null) {
            for (VariablesBlock b : blocks) {
                if (!b.name.equalsIgnoreCase(name)) continue;
                return b;
            }
        }
        return null;
    }

    public VariablesBlock locateSysBlock(String name) {
        return this.locateBlock(this.SysVars, name);
    }

    public VariablesBlock locateUserBlock(String name) {
        return this.locateBlock(this.UserVars, name);
    }

    private ParseState parseToken(String token, boolean onlyCode) throws SyntaxError, FileNotFoundException, IOException, ErrorInFile {
        if (this.State == ParseState.PARSE_START) {
            if (token.equalsIgnoreCase("FileVersion")) {
                return ParseState.FILE_VERSION;
            }
            if (token.equalsIgnoreCase("ID")) {
                return ParseState.PROG_ID;
            }
            if (token.equalsIgnoreCase("CodeCRC")) {
                return ParseState.CODE_CRC;
            }
            this.require(token, "Target");
            return ParseState.TARGET;
        }
        if (this.State == ParseState.FILE_VERSION) {
            this.processVersion(token);
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.PROG_ID) {
            this.id = token;
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.CODE_CRC) {
            this.codeCrc = Program.decodeInt(token, "Invalid number");
            return ParseState.PARSE_START;
        }
        if (this.State == ParseState.TARGET) {
            this.assignDevice(new Device(token));
            return ParseState.BLOCK_BEGIN;
        }
        if (this.State == ParseState.BLOCK_BEGIN) {
            this.saveRaw = false;
            if (token.equalsIgnoreCase(this.MainCode.Name)) {
                return this.openCodeBlock(this.MainCode, this.device.CommandMap.get("END"));
            }
            if (token.equalsIgnoreCase("Sub")) {
                this.saveRaw = true;
                return ParseState.SUB;
            }
            if (onlyCode) {
                throw new SyntaxError("Unknown block: \"" + token + "\" (expected Main, Sub)");
            }
            if (token.equalsIgnoreCase("Const")) {
                return this.openVarDomain(this.Constants, false);
            }
            if (token.equalsIgnoreCase("Ram")) {
                return this.openVarDomain(this.RamVars, false);
            }
            if (token.equalsIgnoreCase("Ext")) {
                return this.openVarDomain(this.ExtVars, false);
            }
            if (token.equalsIgnoreCase("Store")) {
                return this.openVarDomain(this.StoreVars, false);
            }
            if (token.equalsIgnoreCase("SysOut")) {
                return this.openVarDomain(this.device.SysOutVars, true);
            }
            if (token.equalsIgnoreCase("SysStore")) {
                return this.openVarDomain(this.device.SysStoreVars, true);
            }
            if (token.equalsIgnoreCase("SysExt")) {
                return this.openVarDomain(this.device.SysExtVars, true);
            }
            if (token.equalsIgnoreCase("Modbus")) {
                return ParseState.MODBUS_REG;
            }
            if (token.equalsIgnoreCase("Strings")) {
                return ParseState.STRINGS;
            }
            if (token.equalsIgnoreCase("Window")) {
                return ParseState.WINDOW;
            }
            if (token.equalsIgnoreCase("Keys")) {
                return ParseState.KEY;
            }
            if (token.equalsIgnoreCase("End")) {
                return ParseState.PARSE_END;
            }
            throw new SyntaxError("Unknown block: \"" + token + "\" (expected Const, Ram, Ext, Store, SysOut, SysStore, Modbus, Main, Sub, Strings, Window, Keys)");
        }
        if (this.State == ParseState.VAR_NAME) {
            return this.parseVarName(token);
        }
        if (this.State == ParseState.VAR_VALUE) {
            return this.parseVarValue(token);
        }
        if (this.State == ParseState.MODBUS_REG) {
            return this.parseModbusReg(token);
        }
        if (this.State == ParseState.MODBUS_VAR) {
            return this.parseModbusVar(token);
        }
        if (this.State == ParseState.MODBUS_K) {
            if (token.equals("$")) {
                return ParseState.MODBUS_K_VALUE;
            }
            this.Modbus.allocUnresolved(this.mbRegType, this.mbRegAddr, this.mbVar, 0);
            return this.parseModbusReg(token);
        }
        if (this.State == ParseState.MODBUS_K_VALUE) {
            return this.parseModbusKValue(token);
        }
        if (this.State == ParseState.CMD) {
            return this.parseCommand(token);
        }
        if (this.State == ParseState.CMD_ARG) {
            return this.parseCommandArg(token);
        }
        if (this.State == ParseState.SUB) {
            return this.parseSub(token);
        }
        if (this.State == ParseState.STRINGS) {
            return this.parseStrings(token);
        }
        if (this.State == ParseState.STRING_NUM) {
            return this.parseStringNum(token);
        }
        if (this.State == ParseState.STRING_TEXT) {
            return this.parseStringText(token);
        }
        if (this.State == ParseState.WINDOW) {
            return this.parseWindow(token);
        }
        if (this.State == ParseState.WND_PARAM_NAME) {
            return this.parseWindowParamName(token);
        }
        if (this.State == ParseState.WND_PARAM_VAL) {
            return this.parseWindowParamValue(token);
        }
        if (this.State == ParseState.KEY) {
            return this.parseKey(token);
        }
        if (this.State == ParseState.KEY_WINDOW) {
            return this.parseKeyWindow(token);
        }
        if (this.State == ParseState.PARSE_END) {
            throw new SyntaxError("Symbols after End not allowed: \"" + token + "\"");
        }
        throw new SyntaxError("Parser Error");
    }

    private ParseState openVarDomain(VariablesBlock d, boolean initOnly) {
        this.varBlock = d;
        this.varCurrent = null;
        this.varInitOnly = initOnly;
        return ParseState.VAR_NAME;
    }

    private ParseState openCodeBlock(CodeBlock b, CommandDef ret) throws SyntaxError {
        this.codeBlock = b;
        if (this.codeBlock.Items.size() > 0) {
            throw new SyntaxError("Duplicate code block: " + b.Name);
        }
        this.retCommand = ret;
        this.saveRaw = true;
        return ParseState.CMD;
    }

    private ParseState parseVarName(String token) throws SyntaxError {
        String varName;
        int varType;
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        if (token.equals("=")) {
            this.arrayValueIndex = 0;
            return ParseState.VAR_VALUE;
        }
        if (token.equals("#")) {
            return this.parseVarComment();
        }
        try {
            varType = Variable.stringToType(token.substring(0, 1));
            if (varType == 0) {
                throw new SyntaxError("Invalid variable type: \"" + token + "\" (expected b, i, f)");
            }
            varName = token.substring(2);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SyntaxError("Invalid variable name: \"" + token + "\"");
        }
        if (this.varInitOnly) {
            this.varCurrent = this.varBlock.locateVar(varName, varType);
        } else {
            int p0 = varName.indexOf(123);
            int p1 = varName.indexOf(125);
            if (p0 > 0 && p1 > p0 + 1) {
                String s = varName.substring(p0 + 1, p1);
                int size = Program.decodeInt(s, "Invalid array size");
                this.varCurrent = this.varBlock.createArrayVar(varName.substring(0, p0), varType, size, this.Constants);
            } else {
                this.varCurrent = this.varBlock.createSimpleVar(varName, varType, false, -1);
            }
        }
        if (this.varCurrent == null) {
            throw new SyntaxError("Unknown variable: \"" + token + "\"");
        }
        return ParseState.VAR_NAME;
    }

    private ParseState parseVarComment() throws SyntaxError {
        String c = "";
        if (++this.tokenIndex < this.tokens.length) {
            c = this.tokens[this.tokenIndex++];
        }
        while (this.tokenIndex < this.tokens.length) {
            c = c + " " + this.tokens[this.tokenIndex++];
        }
        if (Utils.strEmpty(this.varCurrent.comment)) {
            this.varCurrent.comment = c;
        }
        return ParseState.VAR_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParseState parseVarValue(String token) throws SyntaxError {
        double v;
        if (this.varCurrent.type == 1) {
            if (token.equals("1")) {
                v = 1.0;
            } else {
                if (!token.equals("0")) throw new SyntaxError("Invalid bool value: \"" + token + "\" (expected 0, 1)");
                v = 0.0;
            }
        } else if (this.varCurrent.type == 2) {
            v = Program.decodeInt(token, "Invalid int value");
        } else {
            if (this.varCurrent.type != 3) throw new SyntaxError("Internal error");
            try {
                v = Double.parseDouble(token);
            }
            catch (NumberFormatException e) {
                throw new SyntaxError("Invalid float value: \"" + token + "\"");
            }
        }
        if (this.varCurrent.arrayItems != null) {
            this.varCurrent.arrayItems[this.arrayValueIndex].initValue = v;
            if (++this.arrayValueIndex < this.varCurrent.arrayItems.length) return ParseState.VAR_VALUE;
            return ParseState.VAR_NAME;
        }
        this.varCurrent.initValue = v == 0.0 ? Double.NaN : v;
        return ParseState.VAR_NAME;
    }

    private ParseState parseModbusReg(String token) throws SyntaxError {
        block7: {
            try {
                String t = token.toUpperCase();
                if (t.startsWith("INPUT")) {
                    this.mbRegType = 1;
                    this.mbRegAddr = Integer.decode(token.substring(5));
                    break block7;
                }
                if (t.startsWith("COIL")) {
                    this.mbRegType = 2;
                    this.mbRegAddr = Integer.decode(token.substring(4));
                    break block7;
                }
                if (t.startsWith("IR")) {
                    this.mbRegType = 3;
                    this.mbRegAddr = Integer.decode(token.substring(2));
                    break block7;
                }
                if (t.startsWith("HR")) {
                    this.mbRegType = 4;
                    this.mbRegAddr = Integer.decode(token.substring(2));
                    break block7;
                }
                if (t.startsWith("END")) {
                    return ParseState.BLOCK_BEGIN;
                }
                throw new SyntaxError("Invalid MODBUS register: " + token);
            }
            catch (NumberFormatException e) {
                throw new SyntaxError("Invalid MODBUS register address: " + token);
            }
        }
        return ParseState.MODBUS_VAR;
    }

    private ParseState parseModbusVar(String token) throws SyntaxError {
        this.mbVar = token.equals("0") ? null : token;
        return ParseState.MODBUS_K;
    }

    private ParseState parseModbusKValue(String token) throws SyntaxError {
        int digits = -1;
        try {
            digits = Integer.decode(token);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.Modbus.allocUnresolved(this.mbRegType, this.mbRegAddr, this.mbVar, digits);
        return ParseState.MODBUS_REG;
    }

    private void require(String srcToken, String reqToken) throws SyntaxError {
        if (!srcToken.equalsIgnoreCase(reqToken)) {
            throw new SyntaxError("\"" + reqToken + "\" is missing");
        }
    }

    public Variable locateVar(String fullName) throws SyntaxError {
        Variable.NameParser vn = new Variable.NameParser(fullName);
        for (VariablesBlock d : this.AllVars) {
            Variable var;
            if (!d.name.equalsIgnoreCase(vn.domain) || (var = d.locateVar(vn.name, vn.type)) == null) continue;
            return var;
        }
        throw new SyntaxError("Unknown variable: \"" + fullName + "\"");
    }

    public StringList locateStrings(String name) throws SyntaxError {
        StringList sl = this.Strings.get(name.toUpperCase());
        if (sl == null) {
            throw new SyntaxError("Unknown string list: \"" + name + "\"");
        }
        return sl;
    }

    public Window locateWindow(String name) throws SyntaxError {
        Window w = this.Windows.get(name.toUpperCase());
        if (w == null) {
            throw new SyntaxError("Unknown window: \"" + name + "\"");
        }
        return w;
    }

    private int getCodeLineNum() {
        return this.codeSource.size() + this.lastComments.size() + 1;
    }

    private ParseState parseCommand(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            this.codeBlock.addItem(this.retCommand, this.getCodeLineNum());
            return ParseState.BLOCK_BEGIN;
        }
        if (token.startsWith(":")) {
            this.codeBlock.addLabel(token.substring(1));
            return ParseState.CMD;
        }
        CommandDef cmd = this.device.CommandMap.get(token.toUpperCase());
        if (cmd == null) {
            throw new SyntaxError("Unknown command: \"" + token + "\"");
        }
        this.codeItem = this.codeBlock.addItem(cmd, this.getCodeLineNum());
        this.codeArgIndex = 0;
        this.codeArrIndex = -1;
        if (cmd.Args.length == 0) {
            return ParseState.CMD;
        }
        return ParseState.CMD_ARG;
    }

    private ParseState parseCommandArg(String token) throws SyntaxError {
        ArgumentDef arg = this.codeItem.cmdDef.Args[this.codeArgIndex];
        if (arg.IsList) {
            if (this.codeArrIndex < 0) {
                this.codeArrSize = Program.decodeInt(token, "Invalid number");
                if (this.codeArrSize <= 0) {
                    throw new SyntaxError("Invalid list size:" + this.codeArrSize);
                }
                this.codeItem.addNumArg(arg, this.codeArrSize, false);
                this.codeArrIndex = 0;
                return ParseState.CMD_ARG;
            }
            this.addVarOrLabelArg(token, arg);
            ++this.codeArrIndex;
            if (this.codeArrIndex >= this.codeArrSize) {
                ++this.codeArgIndex;
            }
        } else {
            this.addVarOrLabelArg(token, arg);
            ++this.codeArgIndex;
        }
        if (this.codeArgIndex >= this.codeItem.cmdDef.Args.length) {
            return ParseState.CMD;
        }
        return ParseState.CMD_ARG;
    }

    private void addVarOrLabelArg(String fullName, ArgumentDef def) throws SyntaxError {
        if (def.Type == 100) {
            this.codeItem.addLabelArg(def, fullName);
        } else if (def.Type == 101) {
            this.codeItem.addSubCallArg(def, fullName);
        } else {
            Variable var = this.locateVar(fullName + (def.IsArray ? "[0]" : ""));
            if (var.type != def.Type) {
                throw new SyntaxError("Invalid variable type (" + fullName + "). Must be " + Variable.typeToString(def.Type));
            }
            if (var.block.readOnly && !def.IsReadOnly) {
                throw new SyntaxError("Read only variable (" + fullName + ") is forbidden here");
            }
            this.codeItem.addVarArg(def, var);
            if (def.IsArray && def.IsCheckedSize) {
                this.codeItem.addNumArg(def, var.arrayItems.length, true);
            }
        }
    }

    private ParseState parseSub(String token) throws SyntaxError {
        String name = token.toUpperCase();
        if (this.Subs.containsKey(name)) {
            throw new SyntaxError("Duplicate subprogram name: \"" + token + "\"");
        }
        this.openCodeBlock(new CodeBlock(token), this.device.CommandMap.get("RET"));
        this.Subs.put(name, this.codeBlock);
        return ParseState.CMD;
    }

    private ParseState parseStrings(String token) throws SyntaxError {
        this.stringList = new StringList(token.toUpperCase());
        return ParseState.STRING_NUM;
    }

    private ParseState parseStringNum(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            this.registerStrings(this.stringList);
            return ParseState.BLOCK_BEGIN;
        }
        int num = -1;
        try {
            num = Integer.decode(token);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (num != this.stringList.Strings.size()) {
            throw new SyntaxError("Invalid value: \"" + token + "\". Must be " + this.stringList.Strings.size());
        }
        return ParseState.STRING_TEXT;
    }

    private ParseState parseStringText(String token) throws SyntaxError {
        WindowString str = new WindowString(token, this.device.FONT, this.device.STRING_SIZE);
        if (str.Bytes.length != 6) {
            throw new SyntaxError("Invalid string length: \"" + token + "\" (" + str.Bytes.length + "). Must be 6.");
        }
        this.stringList.Strings.add(str);
        return ParseState.STRING_NUM;
    }

    public void registerStrings(StringList sl) throws SyntaxError {
        if (this.Strings.containsKey(sl.Name)) {
            throw new SyntaxError("Duplicate string list name: \"" + sl.Name + "\"");
        }
        this.Strings.put(sl.Name, sl);
    }

    public void registerWindow(Window w) throws SyntaxError {
        String key = w.Name.toUpperCase();
        if (this.Windows.containsKey(key)) {
            throw new SyntaxError("Duplicate window name: \"" + w.Name + "\"");
        }
        this.Windows.put(key, w);
        if (this.firstWindow == null) {
            this.firstWindow = w;
            w.visible = null;
        }
    }

    private ParseState parseWindow(String token) throws SyntaxError {
        this.window = new Window(token, this);
        this.registerWindow(this.window);
        return ParseState.WND_PARAM_NAME;
    }

    private ParseState parseWindowParamName(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        this.windowParam = token;
        return ParseState.WND_PARAM_VAL;
    }

    private ParseState parseWindowParamValue(String token) throws SyntaxError {
        this.window.setParam(this.windowParam, token);
        return ParseState.WND_PARAM_NAME;
    }

    private ParseState parseKey(String token) throws SyntaxError {
        if (token.toUpperCase().startsWith("END")) {
            return ParseState.BLOCK_BEGIN;
        }
        for (int i = 0; i < KEYS.length; ++i) {
            if (!KEYS[i].equalsIgnoreCase(token)) continue;
            this.keyWindowIndex = i;
            return ParseState.KEY_WINDOW;
        }
        throw new SyntaxError("Unknown key: \"" + token + "\", must be " + Arrays.toString(KEYS));
    }

    private ParseState parseKeyWindow(String token) throws SyntaxError {
        Window w = null;
        if (!token.equals("0")) {
            w = this.locateWindow(token);
        }
        this.keyWindows[this.keyWindowIndex] = w;
        return ParseState.KEY;
    }

    public static int decodeInt(String s, String errorPrefix) throws SyntaxError {
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            throw new SyntaxError(errorPrefix + ": \"" + s + "\"");
        }
    }

    public int getRamSize() {
        return this.RamVars.getSize();
    }

    public int getExtSize() {
        return this.ExtVars.getSize();
    }

    public int getStoreSize() {
        return this.StoreVars.getSize();
    }

    public int getAllCodeSize() {
        int size = this.MainCode.getSize();
        for (CodeBlock cb : this.Subs.values()) {
            size += cb.getSize();
        }
        return size;
    }

    public int getModbusSize() {
        return this.Modbus.getSize();
    }

    public int getWindowsSize() {
        int size = 0;
        for (Window w : this.Windows.values()) {
            size += w.getSize();
        }
        for (StringList sl : this.Strings.values()) {
            size += sl.getBytesCount();
        }
        return size;
    }

    public int getRamInitSize() {
        int size = 2;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.hasInitValue()) continue;
            size += 3 + v.getSize();
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            if (!v.hasInitValue()) continue;
            size += 3 + v.getSize();
        }
        return size;
    }

    public int getConstSize() {
        return this.Constants.getSize();
    }

    public int getFlashSize() {
        return this.device.CodeStart - this.device.FlashStart + this.getAllCodeSize() + this.getModbusSize() + this.getWindowsSize() + this.getRamInitSize() + this.getConstSize();
    }

    private void CheckMemSize(int size, int max, String memType) throws ErrorInFile {
        if (size > max) {
            throw new ErrorInFile(memType + " overflow (" + size + " > " + max + ")");
        }
    }

    private int fillByte(int b, byte[] buf, int offset) {
        buf[offset] = (byte)b;
        return offset + 1;
    }

    private int fillWord(int w, byte[] buf, int offset) {
        buf[offset] = (byte)(w >>> 8);
        buf[offset + 1] = (byte)w;
        return offset + 2;
    }

    private int fillBytes(byte[] bytes, byte[] buf, int offset) {
        for (byte b : bytes) {
            buf[offset++] = b;
        }
        return offset;
    }

    private int fillValues(VariablesBlock vb, byte[] buf, int offset) {
        for (Variable v : vb.map.values()) {
            offset = v.fillInitValue(buf, offset);
        }
        return offset;
    }

    protected int resolveLabel(String label, CodeBlock cb) throws SyntaxError {
        Integer addr = cb.Labels.get(label.toUpperCase());
        if (addr == null) {
            throw new SyntaxError("Unknown label: " + label);
        }
        return cb.startAddress + addr;
    }

    protected int resolveSub(String name) throws SyntaxError {
        CodeBlock sub = this.Subs.get(name.toUpperCase());
        if (sub == null) {
            throw new SyntaxError("Unknown subprogram: " + sub);
        }
        return sub.startAddress;
    }

    private int fillCode(CodeBlock cb, byte[] buf, int offset) throws SyntaxError {
        for (Command ci : cb.Items) {
            offset = this.fillWord(ci.cmdDef.Code, buf, offset);
            for (Argument arg : ci.Args) {
                if (arg.Type == 1) {
                    offset = this.fillByte((byte)((Integer)arg.Value).intValue(), buf, offset);
                    continue;
                }
                if (arg.Type == 5) {
                    offset = this.fillWord((Integer)arg.Value, buf, offset);
                    continue;
                }
                if (arg.Type == 2) {
                    offset = this.fillWord(((Variable)arg.Value).getAddress(), buf, offset);
                    continue;
                }
                if (arg.Type == 3) {
                    offset = this.fillWord(this.resolveLabel((String)arg.Value, cb), buf, offset);
                    continue;
                }
                if (arg.Type == 4) {
                    offset = this.fillWord(this.resolveSub((String)arg.Value), buf, offset);
                    continue;
                }
                throw new SyntaxError("Internal error. Arg type=" + arg.Type);
            }
        }
        return offset;
    }

    private int fillWindowString(WindowString value, byte[] buf, int offset) {
        return this.fillBytes(value.Bytes, buf, offset);
    }

    private int fillWindowAddress(Window w, byte[] buf, int offset) {
        if (w != null) {
            return this.fillWord(w.startAddress, buf, offset);
        }
        return this.fillWord(0, buf, offset);
    }

    private int fillWindowRef(Window w, byte[] buf, int offset) throws SyntaxError {
        return this.fillWord(w.startAddress, buf, offset);
    }

    private int fillWindowRefs(Window w, boolean up, boolean down, byte[] buf, int offset) throws SyntaxError {
        if (up) {
            offset = this.fillWindowRef(w.upLink, buf, offset);
        }
        if (down) {
            offset = this.fillWindowRef(w.downLink, buf, offset);
        }
        offset = this.fillWindowRef(w.leftLink, buf, offset);
        offset = this.fillWindowRef(w.rightLink, buf, offset);
        return offset;
    }

    public static int varTypeEncode(int type, int digits) throws SyntaxError {
        int res = 0;
        if (type == 2) {
            res = 1;
        } else if (type == 3) {
            if (digits == 0) {
                res = 2;
            } else if (digits == 1) {
                res = 3;
            } else if (digits == 2) {
                res = 4;
            } else if (digits == 3) {
                res = 5;
            } else {
                throw new SyntaxError("Invalid digits: " + digits);
            }
        }
        return res;
    }

    public static int digitsDecode(int encodedType) {
        if (encodedType == 3) {
            return 1;
        }
        if (encodedType == 4) {
            return 2;
        }
        if (encodedType == 5) {
            return 3;
        }
        return 0;
    }

    private int fillWindowVar(Variable var, int digits, byte[] buf, int offset, String varName) throws SyntaxError {
        if (var == null) {
            throw new SyntaxError(varName + " is not set");
        }
        int type = Program.varTypeEncode(var.type, digits);
        offset = this.fillByte((byte)type, buf, offset);
        offset = this.fillWord(var.getAddress(), buf, offset);
        return offset;
    }

    private int fillWindowHead(Window w, int type, boolean var, byte[] buf, int offset) throws SyntaxError {
        offset = this.fillByte((byte)type, buf, offset);
        offset = this.fillWindowString(w.title, buf, offset);
        if (var) {
            offset = this.fillWindowVar(w.var, w.digits, buf, offset, "Var");
        }
        return offset;
    }

    private int fillWindows(byte[] buf, int offset) throws SyntaxError {
        for (Window w : this.Windows.values()) {
            w.validate();
            offset = w.type != Window.WindowType.PASSWORD && w.visible != null ? this.fillWord(w.visible.getAddress(), buf, offset) : this.fillWord(0, buf, offset);
            if (w.type == Window.WindowType.STATIC) {
                offset = this.fillWindowHead(w, 0, false, buf, offset);
                offset = this.fillWindowString(w.text, buf, offset);
                offset = this.fillWindowRefs(w, true, true, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.DISP_NUM) {
                offset = this.fillWindowHead(w, 1, true, buf, offset);
                offset = this.fillWindowRefs(w, true, true, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.DISP_TEXT) {
                offset = this.fillWindowHead(w, 2, true, buf, offset);
                offset = this.fillWord(w.strings.startAddress, buf, offset);
                offset = this.fillWindowRefs(w, true, true, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.EDIT_NUM) {
                offset = this.fillWindowHead(w, 3, true, buf, offset);
                if (w.var.type != 1) {
                    offset = this.fillWord(w.min, buf, offset);
                    offset = this.fillWord(w.max, buf, offset);
                }
                offset = this.fillWindowRefs(w, true, false, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.EDIT_TEXT) {
                offset = this.fillWindowHead(w, 4, true, buf, offset);
                offset = this.fillWord(w.strings.startAddress, buf, offset);
                if (w.var.type != 1) {
                    offset = this.fillByte((byte)(w.strings.Strings.size() - 1), buf, offset);
                }
                offset = this.fillWindowRefs(w, true, false, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.INST_EDIT) {
                offset = this.fillWindowHead(w, 5, true, buf, offset);
                if (w.var.type != 1) {
                    offset = this.fillWord(w.min, buf, offset);
                    offset = this.fillWord(w.max, buf, offset);
                }
                offset = this.fillWindowRefs(w, true, false, buf, offset);
                continue;
            }
            if (w.type == Window.WindowType.PASSWORD) {
                offset = this.fillWindowHead(w, 6, false, buf, offset);
                offset = this.fillByte((byte)w.level, buf, offset);
                offset = this.fillWindowRef(w.rightLink, buf, offset);
                offset = this.fillWindowRef(w.leftLink, buf, offset);
                continue;
            }
            if (w.type != Window.WindowType.TABLEEDIT) continue;
            offset = this.fillByte(7, buf, offset);
            offset = this.fillWindowVar(w.titleVar, w.titleDigits, buf, offset, "TitleVar");
            offset = this.fillWindowVar(w.var, w.digits, buf, offset, "Var");
            offset = this.fillWord(w.var.arraySize(), buf, offset);
            offset = this.fillWord(w.min, buf, offset);
            offset = this.fillWord(w.max, buf, offset);
            offset = this.fillWindowRef(w.upLink, buf, offset);
        }
        for (StringList sl : this.Strings.values()) {
            for (WindowString ws : sl.Strings) {
                offset = this.fillBytes(ws.Bytes, buf, offset);
            }
        }
        return offset;
    }

    private int fillModbus(ArrayList<ModbusReg> list, boolean withType, byte[] buf, int offset) throws SyntaxError {
        offset = this.fillByte((byte)list.size(), buf, offset);
        for (int i = 0; i < list.size(); ++i) {
            ModbusReg r = list.get(i);
            int addr = 0;
            int type = 1;
            if (r != null) {
                addr = r.var.getAddress();
                type = Program.varTypeEncode(r.var.type, r.digits);
            }
            offset = this.fillWord(addr, buf, offset);
            if (!withType) continue;
            offset = this.fillByte((byte)type, buf, offset);
        }
        return offset;
    }

    private int fillRamVar(Variable v, byte[] buf, int offset) {
        if (v.hasInitValue()) {
            offset = this.fillWord(v.getAddress(), buf, offset);
            int type = 0;
            if (v.type == 2) {
                type = 1;
            } else if (v.type == 3) {
                type = 2;
            }
            offset = this.fillByte((byte)type, buf, offset);
            offset = v.fillInitValue(buf, offset);
        }
        return offset;
    }

    private int fillRamInit(byte[] buf, int offset) {
        int count = 0;
        for (Variable v : this.RamVars.map.values()) {
            if (!v.hasInitValue()) continue;
            ++count;
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            if (!v.hasInitValue()) continue;
            ++count;
        }
        offset = this.fillWord(count, buf, offset);
        for (Variable v : this.RamVars.map.values()) {
            offset = this.fillRamVar(v, buf, offset);
        }
        for (Variable v : this.device.SysOutVars.map.values()) {
            offset = this.fillRamVar(v, buf, offset);
        }
        return offset;
    }

    public void makeBinaryData() throws SyntaxError, ErrorInFile {
        this.MainCode.startAddress = this.device.CodeStart;
        int addr = this.MainCode.startAddress + this.MainCode.getSize();
        for (CodeBlock cb : this.Subs.values()) {
            cb.startAddress = addr;
            addr += cb.getSize();
        }
        this.Modbus.startAddress = addr;
        int ramInitAddr = addr += this.Modbus.getSize();
        addr += this.getRamInitSize();
        for (Window w : this.Windows.values()) {
            w.startAddress = addr;
            addr += w.getSize();
        }
        for (StringList sl : this.Strings.values()) {
            sl.startAddress = addr;
            addr += sl.getBytesCount();
        }
        this.Constants.startAddress = Math.max(this.device.ConstStart, addr);
        this.RamVars.startAddress = this.device.RamStart;
        this.ExtVars.startAddress = this.device.ExtStart;
        this.StoreVars.startAddress = this.device.StoreStart;
        this.CheckMemSize(this.getFlashSize(), this.device.FlashSize, "Flash memory");
        this.CheckMemSize(this.getConstSize(), this.device.MaxConstSize, "Flash memory for constants");
        this.CheckMemSize(this.getRamSize(), this.device.RamSize, "RAM");
        this.CheckMemSize(this.getStoreSize(), this.device.StoreSize, "Internal EEPROM");
        this.CheckMemSize(this.getExtSize(), this.device.ExtSize, "External EEPROM");
        this.store = new byte[this.getStoreSize()];
        this.fillValues(this.StoreVars, this.store, 0);
        this.ext = new byte[this.getExtSize()];
        this.fillValues(this.ExtVars, this.ext, 0);
        int minBlock = this.device.FlashSize - this.device.MaxConstSize;
        this.flash = new byte[Math.max(minBlock + this.getConstSize(), this.getFlashSize())];
        int flashWithoutConsts = this.getFlashSize() - this.getConstSize();
        if (flashWithoutConsts < minBlock) {
            this.flashGapSize = minBlock - flashWithoutConsts;
            this.flashGapOffset = flashWithoutConsts;
        } else {
            this.flashGapSize = 0;
            this.flashGapOffset = 0;
        }
        Arrays.fill(this.flash, (byte)-1);
        int offset = 0;
        offset = this.fillWindowAddress(this.firstWindow, this.flash, offset);
        for (Window w : this.keyWindows) {
            offset = this.fillWindowAddress(w, this.flash, offset);
        }
        offset = this.fillWord(this.Modbus.startAddress, this.flash, offset);
        int codeOffset = this.device.CodeStart - this.device.FlashStart;
        if (codeOffset < (offset = this.fillWord(ramInitAddr, this.flash, offset))) {
            throw new SyntaxError("Invalid code offset");
        }
        offset = this.fillCode(this.MainCode, this.flash, codeOffset);
        for (CodeBlock cb : this.Subs.values()) {
            offset = this.fillCode(cb, this.flash, offset);
        }
        offset = this.fillModbus(this.Modbus.Coils, false, this.flash, offset);
        offset = this.fillModbus(this.Modbus.Inputs, false, this.flash, offset);
        offset = this.fillModbus(this.Modbus.HRs, true, this.flash, offset);
        offset = this.fillModbus(this.Modbus.IRs, true, this.flash, offset);
        offset = this.fillRamInit(this.flash, offset);
        offset = this.fillWindows(this.flash, offset);
        offset = Math.max(offset, minBlock);
        if ((offset = this.fillValues(this.Constants, this.flash, offset)) != this.flash.length) {
            throw new Error("Internal error (" + offset + " != " + this.flash.length + ")");
        }
        this.codeCrc = this.calcFlashCRC32();
        offset = 64;
        offset = this.fillWord(1, this.flash, offset);
        offset = this.fillWord(this.codeCrc >>> 16, this.flash, offset);
        offset = this.fillWord(this.codeCrc, this.flash, offset);
        GregorianCalendar c = new GregorianCalendar();
        offset = this.fillByte(c.get(1) % 100, this.flash, offset);
        offset = this.fillByte(c.get(2) + 1, this.flash, offset);
        offset = this.fillByte(c.get(5), this.flash, offset);
        byte[] b = new byte[8];
        this.device.FONT.encodeString(this.id, b);
        offset = this.fillBytes(b, this.flash, offset);
    }

    private int calcFlashCRC32() {
        CRC32 crc = new CRC32();
        crc.update(this.flash, 0, 14);
        crc.update(this.flash, 128, this.flash.length - 128);
        return (int)crc.getValue();
    }

    protected int getWindowsAddress() {
        return this.Modbus.startAddress + this.Modbus.getSize() + this.getRamInitSize();
    }

    public void dumpBinaryData(PrintWriter pw) {
        pw.println(";---------------------- FLASH -----------------------------------------------------");
        pw.println();
        pw.println("; Code at $" + Integer.toHexString(this.MainCode.startAddress) + ", size: " + this.getAllCodeSize());
        pw.println("; Modbus at $" + Integer.toHexString(this.Modbus.startAddress) + ", size: " + this.getModbusSize());
        pw.println("; RAM init table at $" + Integer.toHexString(this.Modbus.startAddress + this.Modbus.getSize()) + ", size: " + this.getRamInitSize());
        pw.println("; Windows and strings at $" + Integer.toHexString(this.getWindowsAddress()) + ", size: " + this.getWindowsSize());
        if (this.flashGapSize > 0) {
            pw.println(";");
            this.printBytes(Arrays.copyOfRange(this.flash, 0, this.flashGapOffset), this.device.FlashStart, ".db ", pw);
            pw.println();
            pw.println();
            pw.println("; Constants at $" + Integer.toHexString(this.Constants.startAddress) + ", size: " + this.getConstSize());
            pw.println(";");
            this.printBytes(Arrays.copyOfRange(this.flash, this.flashGapOffset + this.flashGapSize, this.flash.length), this.Constants.startAddress, ".db ", pw);
            pw.println();
            pw.println();
        } else {
            pw.println("; Constants at $" + Integer.toHexString(this.Constants.startAddress) + ", size: " + this.getConstSize());
            pw.println(";");
            this.printBytes(this.flash, this.device.FlashStart, ".db ", pw);
        }
        pw.println();
        pw.println();
        pw.println(";------------------------------- EEPROM (Store) -----------------------------------");
        pw.println();
        pw.println("; Start: $" + Integer.toHexString(this.StoreVars.startAddress) + ", size: " + this.store.length);
        pw.println();
        this.printBytes(this.store, this.StoreVars.startAddress, "; ", pw);
        pw.println();
        pw.println();
        pw.println(";------------------------------- NVRAM (Ext) --------------------------------------");
        pw.println();
        pw.println("; Start: $" + Integer.toHexString(this.ExtVars.startAddress) + ", size: " + this.ext.length);
        pw.println();
        this.printBytes(this.ext, this.ExtVars.startAddress, "; ", pw);
    }

    protected String byteToHex(int b) {
        return "$" + Integer.toHexString((b &= 0xFF) >>> 4) + Integer.toHexString(b & 0xF);
    }

    protected String byteToHex2(int b) {
        return Integer.toHexString((b &= 0xFF) >>> 4) + Integer.toHexString(b & 0xF);
    }

    protected String wordToHex2(int w) {
        return this.byteToHex2(w >>> 8) + this.byteToHex2(w);
    }

    private void printBytes(byte[] buf, int addr, String dataPrefix, PrintWriter pw) {
        int start = 0;
        int i = 0;
        String s = "";
        while (start + i < buf.length) {
            s = s.length() == 0 ? dataPrefix + this.byteToHex(buf[start + i]) : s + ", " + this.byteToHex(buf[start + i]);
            if (++i < 16 && start + i < buf.length) continue;
            pw.println("; $" + this.wordToHex2(addr + start) + ":");
            pw.println(s);
            start += i;
            i = 0;
            s = "";
        }
    }

    static enum ParseState {
        PARSE_START,
        FILE_VERSION,
        PROG_ID,
        CODE_CRC,
        TARGET,
        BLOCK_BEGIN,
        VAR_NAME,
        VAR_VALUE,
        MODBUS_REG,
        MODBUS_VAR,
        MODBUS_K,
        MODBUS_K_VALUE,
        CMD,
        CMD_ARG,
        SUB,
        STRINGS,
        STRING_NUM,
        STRING_TEXT,
        WINDOW,
        WND_PARAM_NAME,
        WND_PARAM_VAL,
        KEY,
        KEY_WINDOW,
        PARSE_END;

    }
}

