/*
 * Decompiled with CFR 0.152.
 */
package certa.vics;

import certa.vics.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import javax.swing.ImageIcon;
import org.json.JSONArray;
import org.json.JSONObject;

public class Utils {
    public static final String RootDir;
    public static final DecimalFormatSymbols DECIMAL_SYMBOLS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteRip(String msg) {
        try (PrintWriter pw = new PrintWriter(RootDir + File.separatorChar + "crash.log", "UTF-8");){
            pw.write(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
            pw.write("\nVersion: " + Version.version + ", id: " + Version.id + ", date: " + Version.date);
            pw.write("\nThread: " + Thread.currentThread().getName() + "\n\n");
            pw.write(msg);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void WriteRip(Throwable ex, String comment) {
        try (PrintWriter pw = new PrintWriter(RootDir + File.separatorChar + "crash.log", "UTF-8");){
            pw.write(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
            pw.write("\nVersion: " + Version.version + ", id: " + Version.id + ", date: " + Version.date);
            pw.write("\nThread: " + Thread.currentThread().getName());
            pw.write("\nComment: " + comment + "\n\n");
            ex.printStackTrace(pw);
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public static void ProcessException(Throwable e, boolean halt) {
        Utils.ProcessException(e, null, halt);
    }

    public static void ProcessException(Throwable e, String comment, boolean halt) {
        if (e != null) {
            System.err.println("EXCEPTION" + (comment != null ? " (" + comment + ")" : ""));
            e.printStackTrace();
        }
        if (halt) {
            System.err.println("HALTED!");
            Utils.WriteRip(e, comment);
            Runtime.getRuntime().halt(1);
        }
    }

    public static void ProcessError(String message, boolean halt) {
        System.err.println("ERROR: '" + message + "'");
        new Exception("stack dump").printStackTrace();
        if (halt) {
            System.err.println("HALTED!");
            Utils.WriteRip(message);
            Runtime.getRuntime().halt(1);
        }
    }

    public static int Round(double d) {
        return d >= 0.0 ? (int)(d + 0.5) : (int)(d - 0.5);
    }

    public static long RoundLong(double d) {
        return d >= 0.0 ? (long)(d + 0.5) : (long)(d - 0.5);
    }

    public static double StringToDouble(String s) {
        double d;
        if (s == null) {
            s = "";
        }
        try {
            d = Double.parseDouble(s.replace(',', '.'));
        }
        catch (NumberFormatException nfe) {
            d = Double.NaN;
        }
        return d;
    }

    public static int BCDToInt(int v) {
        int d = 0;
        int k = 1;
        for (int i = 0; i < 8; ++i) {
            d += (v >>> i * 4 & 0xF) * k;
            k *= 10;
        }
        return d;
    }

    public static String numToString(double d) {
        if (d == (double)((long)d)) {
            return Long.toString((long)d);
        }
        return Double.toString(d);
    }

    public static String FormatDouble(double value, String format) {
        DecimalFormat df = new DecimalFormat(format, DECIMAL_SYMBOLS);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(value);
    }

    public static String FormatDouble(double value, int decimals) {
        String fmt = decimals > 0 ? String.format("0.%0" + decimals + "d", 0) : "0";
        return Utils.FormatDouble(value, fmt);
    }

    public static int StringToIntDef(String s, int def) {
        int i = def;
        if (s != null) {
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                i = def;
            }
        }
        return i;
    }

    public static boolean StringToBool(String s) {
        return Utils.StringToIntDef(s, 0) != 0;
    }

    public static String FullPath(String FileName) {
        return RootDir + File.separator + FileName;
    }

    public static String FullPath(String SubDir, String FileName) {
        return RootDir + File.separator + SubDir + File.separator + FileName;
    }

    public static boolean strEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static URL getResource(String name) {
        if (!Utils.strEmpty(name)) {
            return ClassLoader.getSystemResource(name);
        }
        return null;
    }

    public static InputStream getResourceStream(String name) {
        if (!Utils.strEmpty(name)) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static String loadStringFromFile(String fileName) {
        InputStream in = Utils.getResourceStream(fileName);
        if (in != null) {
            try {
                try {
                    Scanner s = new Scanner(in, "UTF-8");
                    try {
                        String string = s.useDelimiter("\\A").next();
                        s.close();
                        return string;
                    }
                    catch (Throwable throwable) {
                        s.close();
                        throw throwable;
                    }
                }
                finally {
                    in.close();
                }
            }
            catch (Throwable e) {
                Utils.ProcessException(e, fileName, false);
            }
        }
        return null;
    }

    public static JSONObject loadJsonFile(String fileName) {
        String s = Utils.loadStringFromFile(fileName);
        if (s != null) {
            return new JSONObject(s);
        }
        return null;
    }

    public static JSONArray loadJsonArrayFile(String fileName) {
        String s = Utils.loadStringFromFile(fileName);
        if (s != null) {
            return new JSONArray(s);
        }
        return null;
    }

    public static ImageIcon loadImageIcon(String fileName) {
        if (fileName != null) {
            URL imgURL = Utils.getResource(fileName);
            if (imgURL != null) {
                return new ImageIcon(imgURL, fileName);
            }
            System.err.println("Couldn't find file: " + fileName);
            return null;
        }
        return null;
    }

    public static String clearFileExt(String fileName, String ext) {
        int p;
        String s = '.' + ext;
        while ((p = fileName.lastIndexOf(s)) == fileName.length() - s.length()) {
            fileName = fileName.substring(0, p);
        }
        return fileName;
    }

    static {
        DECIMAL_SYMBOLS = new DecimalFormatSymbols();
        RootDir = System.getProperty("user.dir");
        DECIMAL_SYMBOLS.setDecimalSeparator('.');
        DECIMAL_SYMBOLS.setGroupingSeparator(',');
    }
}

