/*
 * Decompiled with CFR 0.152.
 */
package certa.spider.tool;

import certa.modbus.client.ModbusClientTransport;
import certa.modbus.client.RtuOverTcpTransport;
import certa.modbus.client.RtuTransportJSerialComm;
import certa.modbus.client.TcpTransport;
import certa.spider.tool.CommSettingsPanel;
import certa.spider.tool.MainFrame;
import certa.spider.tool.Register;
import certa.spider.tool.SpiderModbusClient;
import certa.spider.tool.Utils;
import java.util.List;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionThread
extends SwingWorker<Void, Void> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionThread.class);
    ModbusClientTransport transport;
    int id;
    MainFrame frame;
    volatile boolean done;
    final boolean calibration;
    public static final int DI_COUNT = 9;
    public static final int RELAY_COUNT = 7;
    public static final int FDO_COUNT = 1;
    public static final int DO_COUNT = 8;
    public static final int AO_COUNT = 3;
    public static final int AI_COUNT = 5;
    public final Register[] dinputs = ConnectionThread.createRegs(9);
    public final Register[] coils = ConnectionThread.createRegs(8);
    public final Register[] hregs = ConnectionThread.createRegs(75);
    public final Register[] ADCs = ConnectionThread.createRegs(5);
    public final Register[] Temps = ConnectionThread.createRegs(5);
    public final Register[] info = ConnectionThread.createRegs(7);
    public int requestsCount;
    public int errorsCount;
    public int version;
    public int stack;
    public boolean modeInit;
    public boolean modeNoProgram;
    public boolean modeCalibration;
    public boolean modeProgramming;
    public String progName;
    private String error = null;
    char[] chars = new char[]{'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '_', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '_', '_', '_', '_', '_', '\u0411', '\u0413', '\u0401', '\u0416', '\u0417', '\u0418', '\u0419', '\u041b', '\u041f', '\u0423', '\u0424', '\u0427', '\u0428', '\u042a', '\u042b', '\u042d', '\u042e', '\u042f', '\u0431', '\u0432', '\u0433', '\u0451', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043f', '\u0442', '\u0447', '\u0448', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f', '\"', '\"', '\"', '\"', '\u2116', '_', 'f', 'L', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '\u0414', '\u0426', '\u0429', '\u0434', '\u0444', '\u0446', '\u0449', '\'', '_', '~', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_'};
    private SpiderModbusClient modbus;

    public ConnectionThread(MainFrame mainFrame, CommSettingsPanel commSettingsPanel) {
        this.frame = mainFrame;
        this.calibration = commSettingsPanel.calibration;
        try {
            mainFrame.connected();
            if (commSettingsPanel.isRtu()) {
                this.transport = new RtuTransportJSerialComm(commSettingsPanel.getPortName(), commSettingsPanel.getBaudRate(), 8, commSettingsPanel.getParity(), commSettingsPanel.getStopBits(), 600, 50);
            } else if (commSettingsPanel.isTcp()) {
                this.transport = new TcpTransport(commSettingsPanel.getTcpHost(), commSettingsPanel.getTcpPort(), null, 0, 5000, 600, 50, true);
            } else if (commSettingsPanel.isRtuOverTcp()) {
                this.transport = new RtuOverTcpTransport(commSettingsPanel.getTcpHost(), commSettingsPanel.getTcpPort(), null, 0, 5000, 600, 50, true);
            } else {
                throw new Exception("Unknown transport");
            }
            this.id = commSettingsPanel.getDeviceId();
            this.execute();
        }
        catch (Throwable throwable) {
            Utils.ProcessException(throwable, false);
            this.error = throwable.getMessage();
            if (Utils.strEmpty(this.error)) {
                this.error = throwable.getClass().getSimpleName();
            }
            this.done();
        }
    }

    public void stop() {
        this.done = true;
    }

    private static Register[] createRegs(int n) {
        Register[] registerArray = new Register[n];
        for (int i = 0; i < registerArray.length; ++i) {
            registerArray[i] = new Register();
        }
        return registerArray;
    }

    private synchronized void incRequestsCount() {
        ++this.requestsCount;
    }

    private synchronized void incErrorosCount() {
        ++this.errorsCount;
    }

    private void setCalibrationMode(boolean bl) throws Exception {
        if (!this.calibration || this.modeCalibration == bl) {
            return;
        }
        log.trace("Set calibration mode: {}", (Object)bl);
        if (System.getProperty("spider.debug") != null) {
            this.modbus.InitReadAInputsRequest(this.id, 5000, 1);
        } else {
            this.modbus.InitSetCalibrationModeRequest(this.id, 1967, bl);
        }
        if (!this.modbus.execRequest()) {
            log.trace("Calibration mode setting failed!");
            if (this.modbus.getResult() == 1) {
                throw new Exception("\u0422\u0430\u0439\u043c\u0430\u0443\u0442 \u043f\u0440\u0438 \u0441\u043c\u0435\u043d\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 \u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0438.");
            }
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043c\u0435\u043d\u0435 \u0440\u0435\u0436\u0438\u043c\u0430 \u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0438. \u041a\u043e\u0434: " + this.modbus.getExceptionCode());
        }
        log.trace("Calibration mode is {}", (Object)bl);
    }

    private void processInfo() throws Exception {
        this.processRegArray(this.info, 0, 5032, this.info.length, false, true, false, false);
        boolean bl = this.info[0].isGood();
        this.stack = bl ? this.info[0].getValue() : 0;
        this.version = bl ? this.info[1].getValue() : 0;
        int n = this.info[2].getValue();
        this.modeInit = bl && (n & 1) != 0;
        this.modeCalibration = bl && (n & 2) != 0;
        this.modeProgramming = bl && (n & 4) != 0;
        this.modeNoProgram = bl && (n & 8) != 0;
        this.progName = "";
        if (bl) {
            n = this.info[3].getValue();
            this.progName = this.progName + this.chars[n & 0xFF];
            this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
            n = this.info[4].getValue();
            this.progName = this.progName + this.chars[n & 0xFF];
            this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
            n = this.info[5].getValue();
            this.progName = this.progName + this.chars[n & 0xFF];
            this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
            n = this.info[6].getValue();
            this.progName = this.progName + this.chars[n & 0xFF];
            this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        } else {
            this.progName = "?";
        }
    }

    private boolean execAndCheck() throws Exception {
        boolean bl = this.modbus.execRequest();
        this.incRequestsCount();
        if (!bl) {
            this.incErrorosCount();
            if (this.modbus.getResult() == 2) {
                throw new Exception("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReg(Register register, int n, boolean bl) throws Exception {
        boolean bl2 = false;
        int n2 = 0;
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            bl2 = register.needWrite;
            n2 = register.valueToWrite;
            register.needWrite = false;
        }
        if (bl2) {
            log.trace("Write {} at {}", (Object)(bl ? "HR" : "coil"), (Object)n);
            if (bl) {
                this.modbus.InitWriteRegisterRequest(this.id, n, n2);
            } else {
                this.modbus.InitWriteCoilRequest(this.id, n, n2 != 0);
            }
            if (!this.modbus.execRequest()) {
                this.incErrorosCount();
            }
            this.incRequestsCount();
        }
    }

    private void processRegArray(Register[] registerArray, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        int n4;
        if (bl) {
            for (n4 = 0; n4 < n3; ++n4) {
                this.writeReg(registerArray[n + n4], n2 + n4, bl2);
            }
        }
        if (bl2) {
            if (bl) {
                this.modbus.InitReadHoldingsRequest(this.id, n2, n3);
            } else {
                this.modbus.InitReadAInputsRequest(this.id, n2, n3);
            }
        } else if (bl) {
            this.modbus.InitReadCoilsRequest(this.id, n2, n3);
        } else {
            this.modbus.InitReadDInputsRequest(this.id, n2, n3);
        }
        if (bl4) {
            if (!this.modbus.execRequest()) {
                this.incErrorosCount();
            }
            this.incRequestsCount();
        } else {
            this.execAndCheck();
        }
        for (n4 = 0; n4 < n3; ++n4) {
            registerArray[n + n4].updateValue(this.modbus, n2 + n4, bl3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        block17: {
            try {
                this.modbus = new SpiderModbusClient();
                try {
                    this.modbus.setTransport(this.transport);
                    while (!this.done) {
                        if (this.calibration && !this.modeCalibration) {
                            this.setCalibrationMode(true);
                        }
                        this.processInfo();
                        if (!this.done) {
                            this.processRegArray(this.dinputs, 0, 5000, this.dinputs.length, false, false, false, true);
                        }
                        if (!this.done) {
                            this.processRegArray(this.coils, 0, 5000, 7, true, false, false, true);
                        }
                        if (!this.done) {
                            this.processRegArray(this.coils, 7, 5007, 1, true, false, false, true);
                        }
                        if (!this.done) {
                            this.processRegArray(this.hregs, 0, 5000, this.hregs.length, true, true, true, true);
                        }
                        if (!this.done) {
                            this.processRegArray(this.ADCs, 0, 5000, this.ADCs.length, false, true, true, true);
                        }
                        if (!this.done) {
                            this.processRegArray(this.Temps, 0, 5008, this.Temps.length, false, true, false, true);
                        }
                        this.publish(new Void[0]);
                        Thread.sleep(100L);
                    }
                    this.setCalibrationMode(false);
                }
                finally {
                    log.debug("doInBackground END");
                    this.modbus.close();
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("Interrupted");
            }
            catch (Throwable throwable) {
                Utils.ProcessException(throwable, false);
                this.error = throwable.getMessage();
                if (!Utils.strEmpty(this.error)) break block17;
                this.error = throwable.getClass().getSimpleName();
            }
        }
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            this.notifyAll();
        }
        return null;
    }

    @Override
    public void done() {
        if (this.modbus != null) {
            this.modbus.close();
        }
        this.frame.disconnected(this.error);
        log.debug("Connection DONE");
    }

    @Override
    protected void process(List<Void> list) {
        this.frame.updateData();
    }
}

