/*
 * Decompiled with CFR 0.152.
 */
package certa.netgate.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final String RootDir;
    public static final DecimalFormatSymbols DECIMAL_SYMBOLS;

    public static void WriteRip(String string) {
        try (PrintWriter printWriter = new PrintWriter(RootDir + File.separatorChar + "crash.log", "UTF-8");){
            printWriter.write(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
            printWriter.write("\nThread: " + Thread.currentThread().getName() + "\n\n");
            printWriter.write(string);
        }
        catch (FileNotFoundException | UnsupportedEncodingException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void WriteRip(Throwable throwable) {
        try (PrintWriter printWriter = new PrintWriter(RootDir + File.separatorChar + "crash.log", "UTF-8");){
            printWriter.write(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
            printWriter.write("\nThread: " + Thread.currentThread().getName() + "\n\n");
            throwable.printStackTrace(printWriter);
        }
        catch (FileNotFoundException | UnsupportedEncodingException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void ProcessException(Throwable throwable, boolean bl) {
        Utils.ProcessException(throwable, null, bl);
    }

    public static void ProcessException(Throwable throwable, String string, boolean bl) {
        Logger logger = LoggerFactory.getLogger("Main");
        if (throwable != null) {
            logger.error("EXCEPTION" + (string != null ? " (" + string + ")" : ""), throwable);
        }
        if (bl) {
            logger.error("HALTED!");
            Utils.WriteRip(throwable);
            Runtime.getRuntime().halt(1);
        }
    }

    public static void ProcessError(String string, boolean bl) {
        System.err.println("ERROR: '" + string + "'");
        new Exception("stack dump").printStackTrace();
        if (bl) {
            System.err.println("HALTED!");
            Utils.WriteRip(string);
            Runtime.getRuntime().halt(1);
        }
    }

    public static int Round(double d) {
        return d >= 0.0 ? (int)(d + 0.5) : (int)(d - 0.5);
    }

    public static long RoundLong(double d) {
        return d >= 0.0 ? (long)(d + 0.5) : (long)(d - 0.5);
    }

    public static double StringToDouble(String string) {
        double d;
        if (string == null) {
            string = "";
        }
        try {
            d = Double.parseDouble(string.replace(',', '.'));
        }
        catch (NumberFormatException numberFormatException) {
            d = Double.NaN;
        }
        return d;
    }

    public static int BCDToInt(int n) {
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < 8; ++i) {
            n2 += (n >>> i * 4 & 0xF) * n3;
            n3 *= 10;
        }
        return n2;
    }

    public static String numToString(double d) {
        if (d == (double)((long)d)) {
            return Long.toString((long)d);
        }
        return Double.toString(d);
    }

    public static String FormatDouble(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string, DECIMAL_SYMBOLS);
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat.format(d);
    }

    public static String FormatDouble(double d, int n) {
        String string = n > 0 ? String.format("0.%0" + n + "d", 0) : "0";
        return Utils.FormatDouble(d, string);
    }

    public static int StringToIntDef(String string, int n) {
        int n2 = n;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        }
        return n2;
    }

    public static boolean StringToBool(String string) {
        return Utils.StringToIntDef(string, 0) != 0;
    }

    public static String FullPath(String string) {
        return RootDir + File.separator + string;
    }

    public static String FullPath(String string, String string2) {
        return RootDir + File.separator + string + File.separator + string2;
    }

    public static boolean strEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static URL getResource(String string) {
        if (!Utils.strEmpty(string)) {
            return ClassLoader.getSystemResource(string);
        }
        return null;
    }

    public static InputStream getResourceStream(String string) {
        if (!Utils.strEmpty(string)) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return null;
    }

    public static ImageIcon loadImageIcon(String string) {
        if (string != null) {
            URL uRL = Utils.getResource(string);
            if (uRL != null) {
                return new ImageIcon(uRL, string);
            }
            System.err.println("Couldn't find file: " + string);
            return null;
        }
        return null;
    }

    static {
        DECIMAL_SYMBOLS = new DecimalFormatSymbols();
        RootDir = System.getProperty("user.dir");
        DECIMAL_SYMBOLS.setDecimalSeparator('.');
        DECIMAL_SYMBOLS.setGroupingSeparator(',');
    }
}

