/*
 * Decompiled with CFR 0.152.
 */
package certa.netgate.tool;

import certa.netgate.tool.CommSettingsPanel;
import certa.netgate.tool.ConnectDialog;
import certa.netgate.tool.ConnectionThread;
import certa.netgate.tool.EnterHandler;
import certa.netgate.tool.IntroPanel;
import certa.netgate.tool.Main;
import certa.netgate.tool.RegComboBox;
import certa.netgate.tool.Utils;
import certa.netgate.tool.VersionInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class MainFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    protected JButton btnConnect;
    protected JButton btnDisconnect;
    protected JButton btnClearMemory;
    protected JButton btnClearApp;
    protected JButton btnReboot;
    JLabel lblModel;
    JLabel lblVersion;
    JPanel pnlToolbar;
    JScrollPane scroll;
    JPanel pnlMainContent;
    JPanel pnlWorkContent;
    JPanel pnlStatus;
    JPanel pnlStatusStats;
    JLabel lblStatusNotConnected;
    JLabel lblStatusPort;
    JLabel lblStatusRequests;
    JLabel lblStatusErrors;
    JLabel lblLastCycle;
    JLabel lblMaxCycle;
    JLabel lblBaseErrors;
    JLabel lblStartsCount;
    JLabel lblBattery;
    JLabel lblCpuTemp;
    JLabel lblModeInit;
    JLabel lblModeNoProg;
    JLabel lblModeCalibr;
    JLabel lblModeProg;
    JLabel lblProgName;
    JLabel lblModeStopped;
    JLabel lblModeFatalError;
    IntroPanel pnlIntro;
    RS485ParamsPanel pnlNetParams1;
    RS485ParamsPanel pnlNetParams2;
    RS485ParamsPanel pnlNetParams3;
    RS485ParamsPanel pnlNetParams4;
    ModbusTcpParamsPanel pnlModbusTcpParams;
    EthernetParamsPanel pnlEthernetParams;
    ClockParamsPanel pnlClockParams;
    HmiPasswordsPanel pnlPasswords;
    protected ConnectionThread connection;
    static final String TITLE = "NetGate Tool v" + VersionInfo.fullString;
    static final String PROP_MAXIMIZE = "main.maximized";
    boolean calibration;
    ActionListener connect = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.connection != null) {
                return;
            }
            MainFrame.this.startWait();
            CommSettingsPanel commSettingsPanel = ConnectDialog.showDialog();
            if (commSettingsPanel != null) {
                MainFrame.this.calibration = commSettingsPanel.calibration;
                String string = commSettingsPanel.getDescr();
                MainFrame.this.lblStatusPort.setText(string);
                MainFrame.this.setTitle(TITLE + " - " + string + (MainFrame.this.calibration ? " - \u041a\u0410\u041b\u0418\u0411\u0420\u041e\u0412\u041a\u0410" : ""));
                MainFrame.this.connection = new ConnectionThread(Main.frameInstance(), commSettingsPanel);
            }
        }
    };
    ActionListener disconnect = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.closeConnection();
        }
    };
    ActionListener clearMemory = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(null, "<html>\u041f\u043e\u0441\u043b\u0435 \u0441\u0442\u0438\u0440\u0430\u043d\u0438\u044f \u043f\u0430\u043c\u044f\u0442\u0438, \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u0432\u0435\u0440\u043d\u0435\u0442\u0441\u044f \u043a \u0437\u0430\u0432\u043e\u0434\u0441\u043a\u0438\u043c \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430\u043c.<br>\u0421\u0442\u0435\u0440\u0435\u0442\u044c \u0432\u0441\u044e \u043f\u0430\u043c\u044f\u0442\u044c?</html>", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", 0) == 0) {
                MainFrame.this.connection.clearMemory();
                JOptionPane.showMessageDialog(null, "<html>\u041e\u0447\u0438\u0441\u0442\u043a\u0430 \u043f\u0430\u043c\u044f\u0442\u0438 \u0437\u0430\u043d\u0438\u043c\u0430\u0435\u0442 \u043f\u0440\u0438\u043c\u0435\u0440\u043d\u043e 15 \u0441\u0435\u043a\u0443\u043d\u0434.<br>\u041f\u043e\u0441\u043b\u0435 \u043e\u0447\u0438\u0441\u0442\u043a\u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0441\u044f \u0441 \u0437\u0430\u0432\u043e\u0434\u0441\u043a\u0438\u043c\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u043f\u043e\u0440\u0442\u043e\u0432.</html>");
            }
        }
    };
    ActionListener reboot = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(null, "<html>\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440?</html>", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", 0) == 0) {
                MainFrame.this.connection.rebootController();
            }
        }
    };
    ActionListener clearApp = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JOptionPane.showConfirmDialog(null, "<html>\u0421\u0442\u0435\u0440\u0435\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443?</html>", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435", 0) == 0) {
                MainFrame.this.connection.clearApp();
            }
        }
    };
    private int errors = 0;
    private static String[] SPEED = new String[]{"", "1200", "2400", "4800", "9600", "19200", "38400"};
    private static String[] STOP_BITS = new String[]{"", "1", "2"};
    private static String[] PARITY = new String[]{"", "NO", "EVEN", "ODD"};
    private static String[] WEEKDAY = new String[]{"", "\u041f\u041d", "\u0412\u0422", "\u0421\u0420", "\u0427\u0422", "\u041f\u0422", "\u0421\u0411", "\u0412\u0421"};
    private static String[] MONTH = new String[]{"", "\u044f\u043d\u0432\u0430\u0440\u044c", "\u0444\u0435\u0432\u0440\u0430\u043b\u044c", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0435\u043b\u044c", "\u043c\u0430\u0439", "\u0438\u044e\u043d\u044c", "\u0438\u044e\u043b\u044c", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u043e\u043a\u0442\u044f\u0431\u0440\u044c", "\u043d\u043e\u044f\u0431\u0440\u044c", "\u0434\u0435\u043a\u0430\u0431\u0440\u044c"};
    private static String[] SUMMERTIME = new String[]{"", "\u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u043e", "\u0417\u0430\u043f. \u0415\u0432\u0440\u043e\u043f\u0430", "\u0426\u0435\u043d\u0442\u0440. \u0415\u0432\u0440\u043e\u043f\u0430", "\u0412\u043e\u0441\u0442. \u0415\u0432\u0440\u043e\u043f\u0430", "\u0421\u0428\u0410, \u041a\u0430\u043d\u0430\u0434\u0430"};

    public MainFrame() {
        super(TITLE);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pnlToolbar = new JPanel(new MigLayout("", "", ""));
        this.btnConnect = new JButton("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c...");
        this.btnConnect.addActionListener(this.connect);
        this.btnDisconnect = new JButton("\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c");
        this.btnDisconnect.addActionListener(this.disconnect);
        this.lblModel = new JLabel(" ");
        this.lblVersion = new JLabel(" ");
        this.lblModeInit = new JLabel("<html><center><b><font color='black'>INIT</font></b></center></html>");
        this.lblModeNoProg = new JLabel("<html><center><b><font color='purple'>\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430<br>\u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430</font></b></center></html>");
        this.lblModeCalibr = new JLabel("<html><center><b><font color='DarkGreen'>\u0420\u0435\u0436\u0438\u043c<br>\u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0438</font></b></center></html>");
        this.lblModeProg = new JLabel("<html><center><b><font color='red'>\u0417\u0430\u043f\u0438\u0441\u044c<br>\u041f\u041e</font></b></center></html>");
        this.lblProgName = new JLabel(" ");
        this.lblModeStopped = new JLabel("<html><center><b><font color='blue'>STOP</font></b></center></html>");
        this.lblModeFatalError = new JLabel("<html><center><b><font color='red'>ERROR</font></b></center></html>");
        this.btnClearMemory = new JButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u043f\u0430\u043c\u044f\u0442\u044c");
        this.btnClearMemory.addActionListener(this.clearMemory);
        this.btnClearApp = new JButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443");
        this.btnClearApp.addActionListener(this.clearApp);
        this.btnReboot = new JButton("\u041f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c");
        this.btnReboot.addActionListener(this.reboot);
        this.pnlToolbar.add((Component)this.btnConnect, "");
        this.pnlToolbar.add((Component)this.btnDisconnect, "");
        this.pnlToolbar.add((Component)this.lblModel, "al left, gapx 20");
        this.pnlToolbar.add((Component)this.lblVersion, "al left, gapx 10");
        this.pnlToolbar.add((Component)this.lblModeInit, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeNoProg, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeCalibr, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.btnClearMemory, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeStopped, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeFatalError, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblModeProg, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.lblProgName, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.btnClearApp, "hidemode 3, al left, gapx 30");
        this.pnlToolbar.add((Component)this.btnReboot, "hidemode 3, al left, gapx 30");
        this.add((Component)this.pnlToolbar, "North");
        this.pnlMainContent = new JPanel(new CardLayout());
        this.pnlWorkContent = new JPanel(new MigLayout(""));
        this.scroll = new JScrollPane(this.pnlWorkContent);
        this.pnlIntro = new IntroPanel();
        this.add((Component)this.pnlMainContent, "Center");
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new BoxLayout(this.pnlStatus, 0));
        this.pnlStatus.setBorder(BorderFactory.createSoftBevelBorder(1));
        this.pnlStatusStats = new JPanel();
        this.pnlStatusStats.setLayout(new BoxLayout(this.pnlStatusStats, 0));
        this.lblStatusNotConnected = new JLabel("\u041d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
        this.lblStatusPort = new JLabel("");
        this.lblStatusRequests = new JLabel("");
        this.lblStatusErrors = new JLabel("");
        this.lblLastCycle = new JLabel("");
        this.lblMaxCycle = new JLabel("");
        this.lblBaseErrors = new JLabel("");
        this.lblStartsCount = new JLabel("");
        this.lblBattery = new JLabel("");
        this.lblCpuTemp = new JLabel("");
        this.pnlStatusStats.add(this.lblStatusPort);
        this.pnlStatusStats.add(new JLabel("    \u0422\u0435\u043c\u043f-\u0440\u0430: "));
        this.pnlStatusStats.add(this.lblCpuTemp);
        this.pnlStatusStats.add(new JLabel("    \u0411\u0430\u0442\u0430\u0440\u0435\u0439\u043a\u0430: "));
        this.pnlStatusStats.add(this.lblBattery);
        this.pnlStatusStats.add(new JLabel("    \u041a-\u0432\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439: "));
        this.pnlStatusStats.add(this.lblStartsCount);
        this.pnlStatusStats.add(new JLabel("    \u041e\u0448\u0438\u0431\u043a\u0438 BASE: "));
        this.pnlStatusStats.add(this.lblBaseErrors);
        this.pnlStatusStats.add(new JLabel("    \u0426\u0438\u043a\u043b: "));
        this.pnlStatusStats.add(this.lblLastCycle);
        this.pnlStatusStats.add(new JLabel(" \u043c\u0441 (\u043c\u0430\u043a\u0441. "));
        this.pnlStatusStats.add(this.lblMaxCycle);
        this.pnlStatusStats.add(new JLabel(")        \u0417\u0430\u043f\u0440\u043e\u0441\u044b: "));
        this.pnlStatusStats.add(this.lblStatusRequests);
        this.pnlStatusStats.add(new JLabel("    \u041e\u0448\u0438\u0431\u043a\u0438: "));
        this.pnlStatusStats.add(this.lblStatusErrors);
        this.pnlStatus.add(this.lblStatusNotConnected);
        this.pnlStatus.add(this.pnlStatusStats);
        this.add((Component)this.pnlStatus, "South");
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(980, 680));
        this.disconnected(null);
        this.pack();
        this.setLocationByPlatform(true);
        if (Main.props.getBool(PROP_MAXIMIZE, false)) {
            this.setExtendedState(6);
        }
    }

    private void createControls() {
        this.pnlWorkContent.removeAll();
        this.pnlNetParams1 = new RS485ParamsPanel(0, "RS485 \u2116 1");
        this.pnlNetParams2 = new RS485ParamsPanel(4, "RS485 \u2116 2");
        this.pnlNetParams3 = new RS485ParamsPanel(8, "RS485 \u2116 3");
        this.pnlNetParams4 = new RS485ParamsPanel(12, "RS485 \u2116 4");
        this.pnlModbusTcpParams = new ModbusTcpParamsPanel();
        this.pnlEthernetParams = new EthernetParamsPanel();
        this.pnlClockParams = new ClockParamsPanel();
        this.pnlPasswords = new HmiPasswordsPanel();
        this.pnlWorkContent.add((Component)new JLabel("<html>\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0440\u0442\u043e\u0432 \u0432\u0441\u0442\u0443\u043f\u0430\u044e\u0442 \u0432 \u0441\u0438\u043b\u0443 \u043f\u043e\u0441\u043b\u0435 \u0441\u043d\u044f\u0442\u0438\u044f \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u043a\u0438 Init, \u0438\u043b\u0438 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430.</html>"), "span, wrap");
        this.pnlWorkContent.add((Component)this.pnlNetParams1, "");
        this.pnlWorkContent.add((Component)this.pnlNetParams2, "");
        this.pnlWorkContent.add((Component)this.pnlNetParams3, "");
        this.pnlWorkContent.add((Component)this.pnlNetParams4, "wrap");
        this.pnlWorkContent.add((Component)this.pnlEthernetParams, "span, wrap");
        this.pnlWorkContent.add((Component)this.pnlModbusTcpParams, "");
        this.pnlWorkContent.add((Component)this.pnlClockParams, "");
        this.pnlWorkContent.add((Component)this.pnlPasswords, "span");
    }

    private void resetControls() {
        this.setTitle(TITLE);
        this.btnClearMemory.setVisible(false);
        this.btnClearApp.setVisible(false);
        this.btnReboot.setVisible(false);
        this.lblModel.setText("");
        this.lblVersion.setText("");
        this.lblProgName.setText("");
        this.lblModeInit.setVisible(false);
        this.lblModeNoProg.setVisible(false);
        this.lblModeCalibr.setVisible(false);
        this.lblModeStopped.setVisible(false);
        this.lblModeFatalError.setVisible(false);
        this.lblModeProg.setVisible(false);
        this.lblLastCycle.setText("-");
        this.lblMaxCycle.setText("-");
        this.lblBaseErrors.setText("-");
        this.lblStartsCount.setText("-");
        this.lblCpuTemp.setText("-");
        this.lblBattery.setText("-");
        this.lblStatusRequests.setText("-");
        this.lblStatusErrors.setText("-");
    }

    void startWait() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    void endWait() {
        this.setCursor(null);
    }

    public void connected() {
        this.createControls();
        this.pnlMainContent.removeAll();
        this.pnlMainContent.add(this.scroll);
        this.btnConnect.setEnabled(false);
        this.btnDisconnect.setEnabled(true);
        this.pnlStatusStats.setVisible(true);
        this.lblStatusNotConnected.setVisible(false);
        this.repaint();
    }

    public void disconnected(String string) {
        this.pnlMainContent.removeAll();
        this.pnlMainContent.add(this.pnlIntro);
        this.btnConnect.setEnabled(true);
        this.btnDisconnect.setEnabled(false);
        this.pnlStatusStats.setVisible(false);
        this.lblStatusNotConnected.setVisible(true);
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
        }
        this.connection = null;
        this.resetControls();
        this.repaint();
    }

    private void updateRegister(JTextField jTextField, ConnectionThread.Register register, int n, int n2, boolean bl) {
        String string = "-";
        if (register.isGood()) {
            string = register.isHex() ? Integer.toHexString(register.getValue()) : Utils.FormatDouble((double)register.getValue() / (double)n, n2);
        }
        if (bl) {
            jTextField.setBackground("1".equals(string) ? Color.GREEN : null);
        }
        String string2 = null;
        if (register.isWriting()) {
            string2 = Utils.FormatDouble((double)register.writingValue() / (double)n, n2);
        }
        this.updateRegisterText(jTextField, string, string2);
    }

    private void updateRegisterText(JTextField jTextField, String string, String string2) {
        if (string2 != null) {
            string = jTextField.getHorizontalAlignment() == 4 ? " -> " + string : string + " <- ";
        }
        if (!string.equals(jTextField.getText())) {
            jTextField.setText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        if (this.connection != null) {
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                this.lblModel.setText("<html><b>" + this.connection.model + "</b><br>(" + this.connection.baseModel + ")</html>");
                this.lblVersion.setText("<html>MPU v" + this.connection.firmware + "<br>BASE v" + this.connection.baseFirmware + "</html>");
                this.lblProgName.setText(this.connection.modeNoProgram ? "" : "<html>\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430:<br><b>" + this.connection.progName + "</b></html>");
                this.lblModeInit.setVisible(this.connection.modeInit);
                this.lblModeNoProg.setVisible(this.connection.modeNoProgram);
                this.lblModeCalibr.setVisible(this.connection.modeCalibration);
                this.btnClearMemory.setVisible(this.connection.modeCalibration);
                this.btnClearApp.setVisible(true);
                this.btnReboot.setVisible(true);
                this.lblModeStopped.setVisible(this.connection.modeStopped);
                this.lblModeFatalError.setVisible(this.connection.modeFatalError);
                this.lblModeProg.setVisible(this.connection.modeProgramming);
                this.lblLastCycle.setText(Integer.toString(this.connection.lastCycle));
                this.lblMaxCycle.setText(Integer.toString(this.connection.maxCycle));
                this.lblBaseErrors.setText(Integer.toString(this.connection.baseErrors));
                this.lblStartsCount.setText(Integer.toString(this.connection.startsCount));
                this.lblCpuTemp.setText(Utils.FormatDouble((double)this.connection.cpuTemp, 1) + " \u00b0C");
                this.lblBattery.setText(" " + Utils.FormatDouble((double)this.connection.batteryVolts, 2) + " V ");
                if (this.connection.badBattery) {
                    this.lblBattery.setOpaque(true);
                    this.lblBattery.setBackground(Color.RED);
                } else {
                    this.lblBattery.setOpaque(false);
                    this.lblBattery.setBackground(null);
                }
                this.lblStatusRequests.setText(" " + Integer.toString(this.connection.requestsCount) + " ");
                int n = this.connection.errorsCount;
                this.lblStatusErrors.setText(" " + Integer.toString(n) + " ");
                if (n != this.errors) {
                    this.errors = n;
                    this.lblStatusErrors.setOpaque(true);
                    this.lblStatusErrors.setBackground(Color.RED);
                } else {
                    this.lblStatusErrors.setOpaque(false);
                    this.lblStatusErrors.setBackground(null);
                }
                this.pnlNetParams1.updateData();
                this.pnlNetParams2.updateData();
                this.pnlNetParams3.updateData();
                this.pnlNetParams4.updateData();
                this.pnlModbusTcpParams.updateData();
                this.pnlEthernetParams.updateData();
                this.pnlClockParams.updateData();
                this.pnlPasswords.updateData();
            }
        }
    }

    public void loadConfig(File file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        if (this.connection != null) {
            this.connection.stop();
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                try {
                    this.connection.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeConnection();
        this.setDefaultCloseOperation(3);
        Main.props.saveBool(PROP_MAXIMIZE, this.getExtendedState() == 6);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private static JTextField createRegView(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        return jTextField;
    }

    private static JTextField createRegEdit(int n, ActionListener actionListener) {
        JTextField jTextField = new JTextField(n);
        jTextField.addKeyListener(new EnterHandler(actionListener, jTextField));
        return jTextField;
    }

    static RegComboBox createRegCombo(String[] stringArray, KeyListener keyListener) {
        RegComboBox regComboBox = new RegComboBox(stringArray);
        regComboBox.addKeyListener(keyListener);
        regComboBox.setSelectedIndex(0);
        return regComboBox;
    }

    private void writeReg(ConnectionThread.Register register, int n, int n2, int n3) {
        this.writeReg(register, n, n2, n3, false);
    }

    private void writeReg(ConnectionThread.Register register, int n, int n2, int n3, boolean bl) {
        if (n >= n2 && n <= n3) {
            this.connection.writeRegister(register, n, bl);
        }
    }

    private void writeRegFromTF(ConnectionThread.Register register, JTextField jTextField, int n, int n2, int n3, JTextField jTextField2) {
        this.writeRegFromTF(register, jTextField, n, n2, n3, jTextField2, false);
    }

    private void writeRegFromTF(ConnectionThread.Register register, JTextField jTextField, int n, int n2, int n3, JTextField jTextField2, boolean bl) {
        if (jTextField2 != null && jTextField2 != jTextField) {
            return;
        }
        int n4 = n2 - 1;
        if (register.isHex()) {
            try {
                n4 = Integer.parseInt(jTextField.getText(), 16);
            }
            catch (Exception exception) {
                n4 = n2 - 1;
            }
        } else {
            double d = Utils.StringToDouble(jTextField.getText());
            jTextField.setText("");
            if (Double.isNaN(d)) {
                return;
            }
            n4 = Utils.Round(d * (double)n);
        }
        if (n4 >= n2 && n4 <= n3) {
            this.connection.writeRegister(register, n4, bl);
        }
    }

    private static JTextField[] createRegViews(int n, int n2) {
        JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jTextFieldArray[i] = MainFrame.createRegView(n2);
            jTextFieldArray[i].setHorizontalAlignment(4);
        }
        return jTextFieldArray;
    }

    private static JTextField[] createRegEdits(int n, int n2, ActionListener actionListener) {
        JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jTextFieldArray[i] = MainFrame.createRegEdit(n2, actionListener);
        }
        return jTextFieldArray;
    }

    void resetTF(JTextField[] jTextFieldArray) {
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            jTextFieldArray[i].setText("");
        }
    }

    class ClockParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField tfSeconds;
        JTextField tfMinutes;
        JTextField tfHours;
        JTextField tfDayOfWeek;
        JTextField tfDayOfMonth;
        JTextField tfMonth;
        JTextField tfYear;
        JTextField tfSummerTime;
        JTextField tfCalibr;
        JTextField tfNewSeconds;
        JTextField tfNewMinutes;
        JTextField tfNewHours;
        JTextField tfNewDayOfWeek;
        JTextField tfNewDayOfMonth;
        JTextField tfNewMonth;
        JTextField tfNewYear;
        JTextField tfSetSecond;
        JTextField tfSetMinute;
        JTextField tfSetHour;
        RegComboBox cbxSetDOW;
        JTextField tfSetDate;
        RegComboBox cbxSetMonth;
        JTextField tfSetYear;
        RegComboBox cbxSetSummerTime;
        JTextField tfSetCalibr;
        protected JButton btnWrite;
        protected JButton btnSync;

        public ClockParamsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRTC2[0], ClockParamsPanel.this.cbxSetSummerTime.getSelectedIndex() - 1, 0, 4);
                            ClockParamsPanel.this.cbxSetSummerTime.setSelectedIndex(0);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC3[0], ClockParamsPanel.this.tfSetCalibr, 1, -500, 500, null, true);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[1], ClockParamsPanel.this.tfSetMinute, 1, 0, 59, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[2], ClockParamsPanel.this.tfSetHour, 1, 0, 23, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRTC[3], ClockParamsPanel.this.cbxSetDOW.getSelectedIndex(), 1, 7);
                            ClockParamsPanel.this.cbxSetDOW.setSelectedIndex(0);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[4], ClockParamsPanel.this.tfSetDate, 1, 1, 31, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRTC[5], ClockParamsPanel.this.cbxSetMonth.getSelectedIndex(), 1, 12);
                            ClockParamsPanel.this.cbxSetMonth.setSelectedIndex(0);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[6], ClockParamsPanel.this.tfSetYear, 1, 0, 99, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRTC[0], ClockParamsPanel.this.tfSetSecond, 1, 0, 59, null, true);
                            ClockParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfSeconds = MainFrame.createRegView(9);
            this.tfMinutes = MainFrame.createRegView(9);
            this.tfHours = MainFrame.createRegView(9);
            this.tfDayOfWeek = MainFrame.createRegView(9);
            this.tfDayOfMonth = MainFrame.createRegView(9);
            this.tfMonth = MainFrame.createRegView(9);
            this.tfYear = MainFrame.createRegView(9);
            this.tfSummerTime = MainFrame.createRegView(9);
            this.tfCalibr = MainFrame.createRegView(9);
            this.tfNewSeconds = MainFrame.createRegView(4);
            this.tfNewMinutes = MainFrame.createRegView(4);
            this.tfNewHours = MainFrame.createRegView(4);
            this.tfNewDayOfWeek = MainFrame.createRegView(4);
            this.tfNewDayOfMonth = MainFrame.createRegView(4);
            this.tfNewMonth = MainFrame.createRegView(4);
            this.tfNewYear = MainFrame.createRegView(4);
            this.tfSetSecond = MainFrame.createRegEdit(4, this.write);
            this.tfSetMinute = MainFrame.createRegEdit(4, this.write);
            this.tfSetHour = MainFrame.createRegEdit(4, this.write);
            this.cbxSetDOW = MainFrame.createRegCombo(WEEKDAY, this.enter);
            this.tfSetDate = MainFrame.createRegEdit(4, this.write);
            this.cbxSetMonth = MainFrame.createRegCombo(MONTH, this.enter);
            this.tfSetYear = MainFrame.createRegEdit(4, this.write);
            this.cbxSetSummerTime = MainFrame.createRegCombo(SUMMERTIME, this.enter);
            this.tfSetCalibr = MainFrame.createRegEdit(6, this.write);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.btnSync = MainFrame.createButton("\u0417\u0430\u043f. \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Calendar calendar = Calendar.getInstance();
                    ClockParamsPanel.this.tfSetYear.setText(Integer.toString(calendar.get(1) % 100));
                    ClockParamsPanel.this.cbxSetMonth.setSelectedIndex(calendar.get(2) + 1);
                    ClockParamsPanel.this.tfSetDate.setText(Integer.toString(calendar.get(5)));
                    int n = calendar.get(7) - 1;
                    if (n == 0) {
                        n = 7;
                    }
                    ClockParamsPanel.this.cbxSetDOW.setSelectedIndex(n);
                    ClockParamsPanel.this.tfSetHour.setText(Integer.toString(calendar.get(11)));
                    ClockParamsPanel.this.tfSetMinute.setText(Integer.toString(calendar.get(12)));
                    ClockParamsPanel.this.tfSetSecond.setText(Integer.toString(calendar.get(13)));
                    ClockParamsPanel.this.write.actionPerformed(null);
                }
            });
            this.setBorder(BorderFactory.createTitledBorder("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0447\u0430\u0441\u043e\u0432"));
            this.add((Component)new JLabel("\u0412\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e\u0442\u0441\u044f \u0432 RTC \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0435\u043a\u0443\u043d\u0434"), "span");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430:"), "al right");
                this.add((Component)this.tfCalibr, "");
                this.add((Component)this.tfSetCalibr, "span 2, wrap");
            }
            this.add((Component)new JLabel("\u041b\u0435\u0442\u043d\u0435\u0435 \u0432\u0440\u0435\u043c\u044f:"), "al right");
            this.add((Component)this.tfSummerTime, "");
            this.add((Component)this.cbxSetSummerTime, "span 2, wrap");
            this.add((Component)new JLabel("\u0413\u043e\u0434:"), "al right");
            this.add((Component)this.tfYear, "");
            this.add((Component)this.tfNewYear, "");
            this.add((Component)this.tfSetYear, "wrap");
            this.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446:"), "al right");
            this.add((Component)this.tfMonth, "");
            this.add((Component)this.tfNewMonth, "");
            this.add((Component)this.cbxSetMonth, "wrap");
            this.add((Component)new JLabel("\u0414\u0435\u043d\u044c:"), "al right");
            this.add((Component)this.tfDayOfMonth, "");
            this.add((Component)this.tfNewDayOfMonth, "");
            this.add((Component)this.tfSetDate, "wrap");
            this.add((Component)new JLabel("\u0414\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438:"), "al right");
            this.add((Component)this.tfDayOfWeek, "");
            this.add((Component)this.tfNewDayOfWeek, "");
            this.add((Component)this.cbxSetDOW, "wrap");
            this.add((Component)new JLabel("\u0427\u0430\u0441:"), "al right");
            this.add((Component)this.tfHours, "");
            this.add((Component)this.tfNewHours, "");
            this.add((Component)this.tfSetHour, "wrap");
            this.add((Component)new JLabel("\u041c\u0438\u043d\u0443\u0442\u0430:"), "al right");
            this.add((Component)this.tfMinutes, "");
            this.add((Component)this.tfNewMinutes, "");
            this.add((Component)this.tfSetMinute, "wrap");
            this.add((Component)new JLabel("\u0421\u0435\u043a\u0443\u043d\u0434\u0430:"), "al right");
            this.add((Component)this.tfSeconds, "");
            this.add((Component)this.tfNewSeconds, "");
            this.add((Component)this.tfSetSecond, "wrap");
            this.add((Component)this.btnSync, "span 2, align left");
            this.add((Component)this.btnWrite, "span 2, align right");
        }

        public void updateData() {
            if (this.isVisible()) {
                MainFrame.this.updateRegister(this.tfNewSeconds, MainFrame.this.connection.hregsRTC[0], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewMinutes, MainFrame.this.connection.hregsRTC[1], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewHours, MainFrame.this.connection.hregsRTC[2], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewDayOfWeek, MainFrame.this.connection.hregsRTC[3], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewDayOfMonth, MainFrame.this.connection.hregsRTC[4], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewMonth, MainFrame.this.connection.hregsRTC[5], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNewYear, MainFrame.this.connection.hregsRTC[6], 1, 0, false);
                MainFrame.this.updateRegister(this.tfSummerTime, MainFrame.this.connection.hregsRTC2[0], 1, 0, false);
                int n = Utils.StringToIntDef(this.tfSummerTime.getText(), -1);
                if (n >= 0 && n < SUMMERTIME.length - 1) {
                    this.tfSummerTime.setText(SUMMERTIME[n + 1]);
                }
                MainFrame.this.updateRegister(this.tfCalibr, MainFrame.this.connection.hregsRTC3[0], 1, 0, false);
                MainFrame.this.updateRegister(this.tfSeconds, MainFrame.this.connection.iregsRTC[0], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMinutes, MainFrame.this.connection.iregsRTC[1], 1, 0, false);
                MainFrame.this.updateRegister(this.tfHours, MainFrame.this.connection.iregsRTC[2], 1, 0, false);
                MainFrame.this.updateRegister(this.tfDayOfWeek, MainFrame.this.connection.iregsRTC[3], 1, 0, false);
                n = Utils.StringToIntDef(this.tfDayOfWeek.getText(), -1);
                if (n > 0 && n < WEEKDAY.length) {
                    this.tfDayOfWeek.setText(WEEKDAY[n]);
                }
                MainFrame.this.updateRegister(this.tfDayOfMonth, MainFrame.this.connection.iregsRTC[4], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMonth, MainFrame.this.connection.iregsRTC[5], 1, 0, false);
                n = Utils.StringToIntDef(this.tfMonth.getText(), -1);
                if (n > 0 && n < MONTH.length) {
                    this.tfMonth.setText(MONTH[n]);
                }
                MainFrame.this.updateRegister(this.tfYear, MainFrame.this.connection.iregsRTC[6], 1, 0, false);
            }
        }
    }

    class EthernetParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField[] tfIP;
        JTextField[] tfMask;
        JTextField[] tfGW;
        JTextField[] tfMAC;
        JTextField[] tfSetIP;
        JTextField[] tfSetMask;
        JTextField[] tfSetGW;
        JTextField[] tfSetMAC;
        protected JButton btnWrite;

        public EthernetParamsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[0], EthernetParamsPanel.this.tfSetIP[0], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[1], EthernetParamsPanel.this.tfSetIP[1], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[2], EthernetParamsPanel.this.tfSetIP[2], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[3], EthernetParamsPanel.this.tfSetIP[3], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[4], EthernetParamsPanel.this.tfSetMask[0], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[5], EthernetParamsPanel.this.tfSetMask[1], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[6], EthernetParamsPanel.this.tfSetMask[2], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[7], EthernetParamsPanel.this.tfSetMask[3], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[8], EthernetParamsPanel.this.tfSetGW[0], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[9], EthernetParamsPanel.this.tfSetGW[1], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[10], EthernetParamsPanel.this.tfSetGW[2], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[11], EthernetParamsPanel.this.tfSetGW[3], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[12], EthernetParamsPanel.this.tfSetMAC[0], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[13], EthernetParamsPanel.this.tfSetMAC[1], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[14], EthernetParamsPanel.this.tfSetMAC[2], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[15], EthernetParamsPanel.this.tfSetMAC[3], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[16], EthernetParamsPanel.this.tfSetMAC[4], 1, 0, 255, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[17], EthernetParamsPanel.this.tfSetMAC[5], 1, 0, 255, null);
                            EthernetParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfIP = MainFrame.createRegViews(4, 3);
            this.tfMask = MainFrame.createRegViews(4, 3);
            this.tfGW = MainFrame.createRegViews(4, 3);
            this.tfMAC = MainFrame.createRegViews(6, 3);
            this.tfSetIP = MainFrame.createRegEdits(4, 3, this.write);
            this.tfSetMask = MainFrame.createRegEdits(4, 3, this.write);
            this.tfSetGW = MainFrame.createRegEdits(4, 3, this.write);
            this.tfSetMAC = MainFrame.createRegEdits(6, 3, this.write);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b Ethernet"));
            this.add((Component)new JLabel("  IP:"), "al right");
            this.add((Component)this.tfIP[0], "");
            this.add((Component)this.tfIP[1], "");
            this.add((Component)this.tfIP[2], "");
            this.add((Component)this.tfIP[3], "");
            this.add((Component)new JLabel("   \u041c\u0430\u0441\u043a\u0430:"), "al right");
            this.add((Component)this.tfMask[0], "");
            this.add((Component)this.tfMask[1], "");
            this.add((Component)this.tfMask[2], "");
            this.add((Component)this.tfMask[3], "");
            this.add((Component)new JLabel("   \u0428\u043b\u044e\u0437:"), "al right");
            this.add((Component)this.tfGW[0], "");
            this.add((Component)this.tfGW[1], "");
            this.add((Component)this.tfGW[2], "");
            this.add((Component)this.tfGW[3], "");
            this.add((Component)new JLabel("   MAC:"), "al right");
            this.add((Component)this.tfMAC[0], "");
            this.add((Component)this.tfMAC[1], "");
            this.add((Component)this.tfMAC[2], "");
            this.add((Component)this.tfMAC[3], "");
            this.add((Component)this.tfMAC[4], "");
            this.add((Component)this.tfMAC[5], "wrap");
            this.add((Component)this.tfSetIP[0], "skip 1");
            this.add((Component)this.tfSetIP[1], "");
            this.add((Component)this.tfSetIP[2], "");
            this.add((Component)this.tfSetIP[3], "");
            this.add((Component)this.tfSetMask[0], "skip 1");
            this.add((Component)this.tfSetMask[1], "");
            this.add((Component)this.tfSetMask[2], "");
            this.add((Component)this.tfSetMask[3], "");
            this.add((Component)this.tfSetGW[0], "skip 1");
            this.add((Component)this.tfSetGW[1], "");
            this.add((Component)this.tfSetGW[2], "");
            this.add((Component)this.tfSetGW[3], "");
            this.add((Component)this.tfSetMAC[0], "skip 1");
            this.add((Component)this.tfSetMAC[1], "");
            this.add((Component)this.tfSetMAC[2], "");
            this.add((Component)this.tfSetMAC[3], "");
            this.add((Component)this.tfSetMAC[4], "");
            this.add((Component)this.tfSetMAC[5], "wrap");
            this.add((Component)new JLabel("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0443\u043b\u0438 \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"), "skip 1, span 17, al left");
            this.add((Component)this.btnWrite, "span 4, align right");
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 12; i <= 17; ++i) {
                    MainFrame.this.connection.hregsEthernet[i].setHex(true);
                }
                MainFrame.this.updateRegister(this.tfIP[0], MainFrame.this.connection.hregsEthernet[0], 1, 0, false);
                MainFrame.this.updateRegister(this.tfIP[1], MainFrame.this.connection.hregsEthernet[1], 1, 0, false);
                MainFrame.this.updateRegister(this.tfIP[2], MainFrame.this.connection.hregsEthernet[2], 1, 0, false);
                MainFrame.this.updateRegister(this.tfIP[3], MainFrame.this.connection.hregsEthernet[3], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMask[0], MainFrame.this.connection.hregsEthernet[4], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMask[1], MainFrame.this.connection.hregsEthernet[5], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMask[2], MainFrame.this.connection.hregsEthernet[6], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMask[3], MainFrame.this.connection.hregsEthernet[7], 1, 0, false);
                MainFrame.this.updateRegister(this.tfGW[0], MainFrame.this.connection.hregsEthernet[8], 1, 0, false);
                MainFrame.this.updateRegister(this.tfGW[1], MainFrame.this.connection.hregsEthernet[9], 1, 0, false);
                MainFrame.this.updateRegister(this.tfGW[2], MainFrame.this.connection.hregsEthernet[10], 1, 0, false);
                MainFrame.this.updateRegister(this.tfGW[3], MainFrame.this.connection.hregsEthernet[11], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[0], MainFrame.this.connection.hregsEthernet[12], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[1], MainFrame.this.connection.hregsEthernet[13], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[2], MainFrame.this.connection.hregsEthernet[14], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[3], MainFrame.this.connection.hregsEthernet[15], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[4], MainFrame.this.connection.hregsEthernet[16], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMAC[5], MainFrame.this.connection.hregsEthernet[17], 1, 0, false);
            }
        }
    }

    class ModbusTcpParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField[] tfPort;
        JTextField[] tfSetPort;
        protected JButton btnWrite;

        public ModbusTcpParamsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            for (int i = 0; i < ModbusTcpParamsPanel.this.tfPort.length; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsEthernet[18 + i], ModbusTcpParamsPanel.this.tfSetPort[i], 1, 0, 65535, null);
                            }
                            ModbusTcpParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfPort = MainFrame.createRegViews(4, 4);
            this.tfSetPort = MainFrame.createRegEdits(4, 4, this.write);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder("\u041f\u043e\u0440\u0442\u044b MODBUS TCP"));
            for (int i = 0; i < this.tfPort.length; ++i) {
                this.add((Component)new JLabel("\u041f\u043e\u0440\u0442 \u2116" + (i + 1) + ":"), "");
                this.add((Component)this.tfPort[i], "");
                this.add((Component)this.tfSetPort[i], "wrap");
            }
            this.add((Component)this.btnWrite, "span 4, align right");
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 0; i < this.tfPort.length; ++i) {
                    MainFrame.this.updateRegister(this.tfPort[i], MainFrame.this.connection.hregsEthernet[18 + i], 1, 0, false);
                }
            }
        }
    }

    class HmiPasswordsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField[] tfPwd;
        JTextField[] tfSetPwd;
        String[] pwdNames;
        protected JButton btnWrite;

        public HmiPasswordsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            for (int i = 0; i < HmiPasswordsPanel.this.tfPwd.length; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsPasswords[i], HmiPasswordsPanel.this.tfSetPwd[i], 1, 0, 9999, null);
                            }
                            HmiPasswordsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfPwd = MainFrame.createRegViews(3, 4);
            this.tfSetPwd = MainFrame.createRegEdits(3, 4, this.write);
            this.pwdNames = new String[]{"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c:", "\u0421\u0435\u0440\u0432\u0438\u0441:", "\u0420\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a:"};
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder("\u041f\u0430\u0440\u043e\u043b\u0438 \u0434\u043b\u044f \u0434\u0438\u0441\u043f\u043b\u0435\u044f"));
            for (int i = 0; i < this.tfPwd.length; ++i) {
                this.add((Component)new JLabel(this.pwdNames[i]), "");
                this.add((Component)this.tfPwd[i], "");
                this.add((Component)this.tfSetPwd[i], "wrap");
            }
            this.add((Component)this.btnWrite, "span 4, align right");
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 0; i < this.tfPwd.length; ++i) {
                    MainFrame.this.updateRegister(this.tfPwd[i], MainFrame.this.connection.hregsPasswords[i], 1, 0, false);
                }
            }
        }
    }

    class RS485ParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final int startAddr;
        ActionListener write;
        EnterHandler enter;
        JTextField tfNetId;
        JTextField tfNetSpeed;
        JTextField tfNetParity;
        JTextField tfNetStopBits;
        JTextField tfSetNetId;
        RegComboBox cbxSetNetSpeed;
        RegComboBox cbxSetNetParity;
        RegComboBox cbxSetNetStopBits;
        protected JButton btnWrite;

        public RS485ParamsPanel(int n, String string) {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregsRS485[RS485ParamsPanel.this.startAddr], RS485ParamsPanel.this.tfSetNetId, 1, 1, 254, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRS485[RS485ParamsPanel.this.startAddr + 1], RS485ParamsPanel.this.cbxSetNetSpeed.getSelectedIndex() - 1, 0, 5);
                            RS485ParamsPanel.this.cbxSetNetSpeed.setSelectedIndex(0);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRS485[RS485ParamsPanel.this.startAddr + 2], RS485ParamsPanel.this.cbxSetNetStopBits.getSelectedIndex(), 1, 2);
                            RS485ParamsPanel.this.cbxSetNetStopBits.setSelectedIndex(0);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregsRS485[RS485ParamsPanel.this.startAddr + 3], RS485ParamsPanel.this.cbxSetNetParity.getSelectedIndex() - 1, 0, 2);
                            RS485ParamsPanel.this.cbxSetNetParity.setSelectedIndex(0);
                            RS485ParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfNetId = MainFrame.createRegView(6);
            this.tfNetSpeed = MainFrame.createRegView(6);
            this.tfNetParity = MainFrame.createRegView(6);
            this.tfNetStopBits = MainFrame.createRegView(6);
            this.tfSetNetId = MainFrame.createRegEdit(4, this.write);
            this.cbxSetNetSpeed = MainFrame.createRegCombo(SPEED, this.enter);
            this.cbxSetNetParity = MainFrame.createRegCombo(PARITY, this.enter);
            this.cbxSetNetStopBits = MainFrame.createRegCombo(STOP_BITS, this.enter);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.startAddr = n;
            this.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441:"), "al right");
            this.add((Component)this.tfNetId, "");
            this.add((Component)this.tfSetNetId, "wrap");
            this.add((Component)new JLabel("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c:"), "al right");
            this.add((Component)this.tfNetSpeed, "");
            this.add((Component)this.cbxSetNetSpeed, "wrap");
            this.add((Component)new JLabel("\u0427\u0435\u0442\u043d\u043e\u0441\u0442\u044c:"), "al right");
            this.add((Component)this.tfNetParity, "");
            this.add((Component)this.cbxSetNetParity, "wrap");
            this.add((Component)new JLabel("\u0421\u0442\u043e\u043f-\u0431\u0438\u0442\u044b:"), "al right");
            this.add((Component)this.tfNetStopBits, "");
            this.add((Component)this.cbxSetNetStopBits, "wrap");
            this.add((Component)this.btnWrite, "span 2, align right");
        }

        private String parityString(int n) {
            if (++n >= 0 && n < PARITY.length) {
                return PARITY[n];
            }
            return Integer.toString(n);
        }

        public void updateData() {
            if (this.isVisible()) {
                ConnectionThread.Register register;
                MainFrame.this.updateRegister(this.tfNetId, MainFrame.this.connection.hregsRS485[this.startAddr], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNetSpeed, MainFrame.this.connection.hregsRS485[this.startAddr + 1], 1, 0, false);
                int n = Utils.StringToIntDef(this.tfNetSpeed.getText(), -1);
                if (n >= 0 && n < SPEED.length - 1) {
                    this.tfNetSpeed.setText(SPEED[n + 1]);
                }
                MainFrame.this.updateRegisterText(this.tfNetParity, (register = MainFrame.this.connection.hregsRS485[this.startAddr + 3]).isGood() ? this.parityString(register.getValue()) : "-", register.needWrite ? this.parityString(register.writingValue()) : null);
                MainFrame.this.updateRegister(this.tfNetStopBits, MainFrame.this.connection.hregsRS485[this.startAddr + 2], 1, 0, false);
            }
        }
    }

    class UpDownHandler
    extends KeyAdapter {
        private final ConnectionThread.Register reg;
        private final JTextField tf;

        public UpDownHandler(ConnectionThread.Register register, JTextField jTextField) {
            this.reg = register;
            this.tf = jTextField;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incRegValue(int n) {
            if (MainFrame.this.connection != null) {
                ConnectionThread connectionThread = MainFrame.this.connection;
                synchronized (connectionThread) {
                    if (this.reg.isGood()) {
                        int n2 = Utils.StringToIntDef(this.tf.getText(), -1);
                        if (n2 < 0) {
                            int n3 = n2 = this.reg.needWrite ? this.reg.valueToWrite : this.reg.getValue();
                        }
                        if ((n2 += n) >= 0 && n2 <= 1023) {
                            MainFrame.this.connection.writeRegister(this.reg, n2, false);
                            this.tf.setText(Integer.toString(n2));
                        }
                    }
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38) {
                this.incRegValue(keyEvent.isControlDown() ? 10 : 1);
            }
            if (keyEvent.getKeyCode() == 40) {
                this.incRegValue(keyEvent.isControlDown() ? -10 : -1);
            }
            if (keyEvent.getKeyCode() == 27) {
                this.tf.setText("");
            }
        }
    }

    class IncAction
    implements ActionListener {
        final JTextField src;
        final JTextField tgt;
        final int step;

        IncAction(JTextField jTextField, JTextField jTextField2, int n) {
            this.src = jTextField;
            this.tgt = jTextField2;
            this.step = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = Utils.StringToIntDef(this.tgt.getText(), -1);
            if (n < 0) {
                n = Utils.StringToIntDef(this.src.getText(), -1);
            }
            if (n > 0) {
                if ((n += this.step) < 0) {
                    n = 0;
                }
                if (n > 65535) {
                    n = 65535;
                }
                this.tgt.setText(Integer.toString(n));
            }
            this.tgt.requestFocusInWindow();
        }
    }

    class CopyAction
    implements ActionListener {
        final JTextField src;
        final JTextField tgt;

        CopyAction(JTextField jTextField, JTextField jTextField2) {
            this.src = jTextField;
            this.tgt = jTextField2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.tgt.setText(this.src.getText());
            this.tgt.requestFocusInWindow();
        }
    }
}

