/*
 * Decompiled with CFR 0.152.
 */
package certa.netgate.tool;

import certa.modbus.client.ModbusClient;
import certa.modbus.client.ModbusClientTransport;
import certa.modbus.client.RtuOverTcpTransport;
import certa.modbus.client.RtuTransportJSerialComm;
import certa.modbus.client.TcpTransport;
import certa.netgate.tool.CommSettingsPanel;
import certa.netgate.tool.MainFrame;
import certa.netgate.tool.MentorModbusClient;
import certa.netgate.tool.Utils;
import java.util.List;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionThread
extends SwingWorker<Void, Void> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionThread.class);
    final int MAX_FIRMWARE = 5;
    ModbusClientTransport transport;
    int id;
    MainFrame frame;
    volatile boolean done;
    volatile boolean clearMem = false;
    volatile boolean clearApp = false;
    volatile boolean reboot = false;
    final boolean calibration;
    public static final int DI_COUNT_MAX = 18;
    public static final int AI_COUNT_MAX = 8;
    public static final int AO_COUNT_MAX = 6;
    public static final int COUNTERS_COUNT_MAX = 10;
    public static final int RELAY_COUNT = 9;
    public static final int FDO_COUNT = 1;
    public static final int DO_COUNT = 10;
    public final Register[] iregsRTC = ConnectionThread.createRegs(7, false);
    private final Register[] iregs60xx = ConnectionThread.createRegs(24, true);
    public final Register[] hregsRTC = ConnectionThread.createRegs(7, false);
    public final Register[] hregsRTC2 = ConnectionThread.createRegs(1, false);
    public final Register[] hregsRTC3 = ConnectionThread.createRegs(1, false);
    public final Register[] hregsPasswords = ConnectionThread.createRegs(3, false);
    public final Register[] hregsRS485 = ConnectionThread.createRegs(16, true);
    public final Register[] hregsEthernet = ConnectionThread.createRegs(22, true);
    public int requestsCount;
    public int errorsCount;
    public String model = "";
    public String firmware = "";
    public int lastCycle;
    public int maxCycle;
    public int startsCount;
    public int baseErrors;
    public float cpuTemp;
    public float batteryVolts;
    public String baseModel = "";
    public String baseFirmware = "";
    public boolean modeInit;
    public boolean modeCalibration;
    public boolean modeNoProgram;
    public boolean modeProgramming;
    public boolean modeFatalError;
    public boolean modeStopped;
    public boolean badBattery;
    public String progName = "";
    public int flashSize;
    public int eepromSize;
    public int nvramSize;
    public int ramSize;
    public int extEepromSize;
    private String error = null;
    char[] chars = new char[]{'_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '_', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '_', '_', '_', '_', '_', '\u0411', '\u0413', '\u0401', '\u0416', '\u0417', '\u0418', '\u0419', '\u041b', '\u041f', '\u0423', '\u0424', '\u0427', '\u0428', '\u042a', '\u042b', '\u042d', '\u042e', '\u042f', '\u0431', '\u0432', '\u0433', '\u0451', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043f', '\u0442', '\u0447', '\u0448', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f', '\"', '\"', '\"', '\"', '\u2116', '_', 'f', 'L', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '\u0414', '\u0426', '\u0429', '\u0434', '\u0444', '\u0446', '\u0449', '\'', '_', '~', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_', '_'};
    Register[] tmpRegs = new Register[128];
    private MentorModbusClient modbus;
    private boolean timeout;

    private String getToolByFirmware(int n) {
        String string = "NetGateTool \u0432\u0435\u0440\u0441\u0438\u0438 ";
        if (n == 1 || n == 2) {
            string = string + "1.1.x";
        }
        string = n == 3 ? string + "1.2.x" : "\u043d\u043e\u0432\u044b\u0439 NetGateTool.";
        return string;
    }

    public ConnectionThread(MainFrame mainFrame, CommSettingsPanel commSettingsPanel) {
        this.frame = mainFrame;
        this.calibration = commSettingsPanel.calibration;
        try {
            mainFrame.connected();
            if (commSettingsPanel.isRtu()) {
                this.transport = new RtuTransportJSerialComm(commSettingsPanel.getPortName(), commSettingsPanel.getBaudRate(), 8, commSettingsPanel.getParity(), commSettingsPanel.getStopBits(), 2000, 50);
            } else if (commSettingsPanel.isTcp()) {
                this.transport = new TcpTransport(commSettingsPanel.getTcpHost(), commSettingsPanel.getTcpPort(), null, 0, 5000, 2000, 50, true);
            } else if (commSettingsPanel.isRtuOverTcp()) {
                this.transport = new RtuOverTcpTransport(commSettingsPanel.getTcpHost(), commSettingsPanel.getTcpPort(), null, 0, 5000, 2000, 50, true);
            } else {
                throw new Exception("Unknown transport");
            }
            this.id = commSettingsPanel.getDeviceId();
            this.execute();
        }
        catch (Throwable throwable) {
            Utils.ProcessException(throwable, false);
            this.error = throwable.getMessage();
            if (Utils.strEmpty(this.error)) {
                this.error = throwable.getClass().getSimpleName();
            }
            this.done();
        }
    }

    public void stop() {
        this.done = true;
    }

    public void clearMemory() {
        if (this.calibration) {
            this.clearMem = true;
        }
    }

    public void rebootController() {
        this.reboot = true;
    }

    public void clearApp() {
        this.clearApp = true;
    }

    private static Register[] createRegs(int n, boolean bl) {
        Register[] registerArray = new Register[n];
        for (int i = 0; i < registerArray.length; ++i) {
            registerArray[i] = new Register();
            registerArray[i].setUnsigned(bl);
        }
        return registerArray;
    }

    private synchronized void incRequestsCount() {
        ++this.requestsCount;
    }

    private synchronized void incErrorosCount() {
        ++this.errorsCount;
    }

    private void setCalibrationMode(boolean bl) throws Exception {
        if (this.modeCalibration == bl) {
            return;
        }
        log.trace("Set calibration mode: {}", (Object)bl);
        this.modbus.InitWriteRegisterRequest(this.id, 7000, bl ? 3233 : 369);
        if (!this.modbus.execRequest()) {
            log.trace("Calibration mode setting failed!");
        }
    }

    private void clearMemoryCmd() throws Exception {
        log.trace("CLEAR MEMORY");
        this.modbus.InitWriteRegisterRequest(this.id, 7000, 27954);
        if (!this.modbus.execRequest()) {
            if (this.modbus.getResult() == 1) {
                throw new InterruptedException();
            }
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0442\u0438\u0440\u0430\u043d\u0438\u0438 \u043f\u0430\u043c\u044f\u0442\u0438: " + this.modbus.getResultAsString());
        }
    }

    private void rebootCmd() throws Exception {
        log.trace("RESTART CONTROLLER");
        this.modbus.InitWriteRegisterRequest(this.id, 7000, 369);
        if (!this.modbus.execRequest() && this.modbus.getResult() != 1) {
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0435 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430: " + this.modbus.getResultAsString());
        }
    }

    private void clearAppCmd() throws Exception {
        log.trace("CLEAR APPLICATION");
        this.modbus.InitWriteRegisterRequest(this.id, 7000, 18546);
        if (!this.modbus.execRequest()) {
            throw new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u0442\u0438\u0440\u0430\u043d\u0438\u0438 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b: " + this.modbus.getResultAsString());
        }
        this.rebootCmd();
    }

    private void processInfo() throws Exception {
        if (!this.iregs60xx[0].isGood()) {
            return;
        }
        int n = this.iregs60xx[0].getValue();
        this.model = n == 51 ? "NetGate" : "---";
        n = this.iregs60xx[1].getValue();
        int n2 = n / 100;
        this.firmware = n2 + "." + n % 100;
        if (n2 < 5) {
            throw new Exception("<html>\u041d\u0435\u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438 (" + this.firmware + ").<br>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 " + this.getToolByFirmware(n2) + "</html>");
        }
        n = this.iregs60xx[2].getValue();
        this.baseModel = n == 0 ? "BASE-40" : "---";
        n = this.iregs60xx[3].getValue();
        this.baseFirmware = n / 100 + "." + n % 100;
        this.progName = "";
        n = this.iregs60xx[4].getValue();
        this.progName = this.progName + this.chars[n & 0xFF];
        this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        n = this.iregs60xx[5].getValue();
        this.progName = this.progName + this.chars[n & 0xFF];
        this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        n = this.iregs60xx[6].getValue();
        this.progName = this.progName + this.chars[n & 0xFF];
        this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        n = this.iregs60xx[7].getValue();
        this.progName = this.progName + this.chars[n & 0xFF];
        this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        n = this.iregs60xx[8].getValue();
        this.progName = this.progName + this.chars[n & 0xFF];
        this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        n = this.iregs60xx[9].getValue();
        this.progName = this.progName + this.chars[n & 0xFF];
        this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        n = this.iregs60xx[10].getValue();
        this.progName = this.progName + this.chars[n & 0xFF];
        this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        n = this.iregs60xx[11].getValue();
        this.progName = this.progName + this.chars[n & 0xFF];
        this.progName = this.progName + this.chars[n >>> 8 & 0xFF];
        this.flashSize = this.iregs60xx[12].getValue();
        this.eepromSize = this.iregs60xx[13].getValue();
        this.nvramSize = this.iregs60xx[14].getValue();
        this.ramSize = this.iregs60xx[15].getValue();
        this.extEepromSize = this.iregs60xx[16].getValue();
        n = this.iregs60xx[17].getValue();
        this.modeInit = (n & 1) != 0;
        this.modeCalibration = (n & 2) != 0;
        this.modeProgramming = (n & 4) != 0;
        this.modeStopped = (n & 8) != 0;
        this.modeFatalError = (n & 0x10) != 0;
        this.modeNoProgram = (n & 0x20) == 0;
        this.badBattery = (n & 0x40) != 0;
        this.lastCycle = this.iregs60xx[18].getValue();
        this.maxCycle = this.iregs60xx[19].getValue();
        this.startsCount = this.iregs60xx[20].getValue();
        this.baseErrors = this.iregs60xx[21].getValue();
        this.batteryVolts = (float)this.iregs60xx[22].getValue() / 100.0f;
        this.cpuTemp = (float)this.iregs60xx[23].getValue() / 10.0f;
    }

    private boolean execAndCheck() throws Exception {
        boolean bl = this.modbus.execRequest();
        this.incRequestsCount();
        if (!bl) {
            this.incErrorosCount();
            if (this.modbus.getResult() == 2 && this.modbus.getExceptionCode() == 2) {
                throw new Exception("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            }
            this.setBadData();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReg(Register register, int n, boolean bl) throws Exception {
        boolean bl2 = false;
        int n2 = 0;
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            bl2 = register.needWrite;
            n2 = register.valueToWrite;
            register.needWrite = false;
        }
        if (bl2) {
            log.trace("Write {} at {}: {}", bl ? "HR" : "coil", n, n2);
            if (bl) {
                this.modbus.InitWriteRegisterRequest(this.id, n, n2);
            } else {
                this.modbus.InitWriteCoilRequest(this.id, n, n2 != 0);
            }
            if (!this.modbus.execRequest()) {
                this.incErrorosCount();
            }
            this.incRequestsCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRegs(Register[] registerArray, int n, int n2, boolean bl) throws Exception {
        int[] nArray = bl ? new int[n2] : null;
        boolean[] blArray = bl ? null : new boolean[n2];
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            for (int i = 0; i < n2; ++i) {
                if (bl) {
                    nArray[i] = registerArray[i].valueToWrite;
                } else {
                    blArray[i] = registerArray[i].valueToWrite != 0;
                }
                registerArray[i].needWrite = false;
            }
        }
        log.trace("Write {} {}s at {}", n2, bl ? "HR" : "coil", n);
        if (bl) {
            this.modbus.InitWriteRegistersRequest(this.id, n, nArray);
        } else {
            this.modbus.InitWriteCoilsRequest(this.id, n, blArray);
        }
        if (!this.modbus.execRequest()) {
            this.incErrorosCount();
        }
        this.incRequestsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRegArray(Register[] registerArray, int n, int n2, boolean bl, boolean bl2, boolean bl3) throws Exception {
        int n3;
        if (n2 <= 0) {
            return;
        }
        if (bl) {
            int n4;
            n3 = 0;
            while (n3 < n2) {
                n4 = 0;
                int n5 = n + n3;
                ConnectionThread connectionThread = this;
                synchronized (connectionThread) {
                    while (n3 < n2) {
                        Register register = registerArray[n3++];
                        if (!register.needWrite || register.postpone) break;
                        this.tmpRegs[n4++] = register;
                    }
                }
                if (n4 == 1) {
                    this.writeReg(this.tmpRegs[0], n5, bl2);
                    continue;
                }
                if (n4 <= 1) continue;
                this.writeRegs(this.tmpRegs, n5, n4, bl2);
            }
            for (n4 = 0; n4 < n2; ++n4) {
                this.writeReg(registerArray[n4], n + n4, bl2);
            }
        }
        if (bl2) {
            if (bl) {
                this.modbus.InitReadHoldingsRequest(this.id, n, n2);
            } else {
                this.modbus.InitReadAInputsRequest(this.id, n, n2);
            }
        } else if (bl) {
            this.modbus.InitReadCoilsRequest(this.id, n, n2);
        } else {
            this.modbus.InitReadDInputsRequest(this.id, n, n2);
        }
        if (bl3) {
            if (!this.modbus.execRequest()) {
                this.incErrorosCount();
                if (this.modbus.getResult() == 1) {
                    this.setBadData();
                }
            }
            this.incRequestsCount();
        } else {
            this.execAndCheck();
        }
        for (n3 = 0; n3 < n2; ++n3) {
            registerArray[n3].updateValue(this.modbus, n + n3);
        }
    }

    private void setRegsBad(Register[] registerArray) {
        for (Register register : registerArray) {
            register.good = false;
        }
    }

    private void setBadData() {
        this.timeout = true;
        this.setRegsBad(this.iregsRTC);
        this.setRegsBad(this.iregs60xx);
        this.setRegsBad(this.hregsRTC);
        this.setRegsBad(this.hregsRTC2);
        this.setRegsBad(this.hregsRTC3);
        this.setRegsBad(this.hregsPasswords);
        this.setRegsBad(this.hregsRS485);
        this.setRegsBad(this.hregsEthernet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        block22: {
            try {
                this.modbus = new MentorModbusClient();
                try {
                    this.modbus.setTransport(this.transport);
                    while (!this.done) {
                        this.timeout = false;
                        this.processRegArray(this.iregs60xx, 6000, this.iregs60xx.length, false, true, false);
                        this.processInfo();
                        if (!this.timeout && !this.done && this.clearMem) {
                            this.clearMem = false;
                            this.clearMemoryCmd();
                        }
                        if (!this.timeout && !this.done && this.reboot) {
                            this.reboot = false;
                            this.rebootCmd();
                        }
                        if (!this.timeout && !this.done && this.clearApp) {
                            this.clearApp = false;
                            this.clearAppCmd();
                        }
                        if (!this.timeout && !this.done && this.calibration && !this.modeCalibration) {
                            this.setCalibrationMode(true);
                        }
                        if (!this.timeout && !this.done) {
                            this.processRegArray(this.iregsRTC, 5100, this.iregsRTC.length, false, true, true);
                        }
                        if (!this.timeout && !this.done) {
                            this.processRegArray(this.hregsRTC, 5100, this.hregsRTC.length, true, true, true);
                        }
                        if (!this.timeout && !this.done) {
                            this.processRegArray(this.hregsRTC2, 5107, this.hregsRTC2.length, true, true, true);
                        }
                        if (!this.timeout && !this.done) {
                            this.processRegArray(this.hregsRTC3, 5108, this.hregsRTC3.length, true, true, true);
                        }
                        if (!this.timeout && !this.done) {
                            this.processRegArray(this.hregsPasswords, 5120, this.hregsPasswords.length, true, true, true);
                        }
                        if (!this.timeout && !this.done) {
                            this.processRegArray(this.hregsEthernet, 6032, this.hregsEthernet.length, true, true, true);
                        }
                        if (!this.timeout && !this.done) {
                            this.processRegArray(this.hregsRS485, 6000, this.hregsRS485.length, true, true, true);
                        }
                        this.publish(new Void[0]);
                        Thread.sleep(100L);
                    }
                    if (this.calibration) {
                        this.setCalibrationMode(false);
                    }
                }
                finally {
                    log.debug("doInBackground END");
                    this.modbus.close();
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("Interrupted");
            }
            catch (Throwable throwable) {
                Utils.ProcessException(throwable, false);
                this.error = throwable.getMessage();
                if (!Utils.strEmpty(this.error)) break block22;
                this.error = throwable.getClass().getSimpleName();
            }
        }
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            this.notifyAll();
        }
        return null;
    }

    @Override
    public void done() {
        if (this.modbus != null) {
            this.modbus.close();
        }
        this.frame.disconnected(this.error);
        log.debug("Connection DONE");
    }

    @Override
    protected void process(List<Void> list) {
        this.frame.updateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRegister(Register register, int n, boolean bl) {
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            register.writeValue(n, bl);
        }
    }

    public static class Register {
        private boolean good = false;
        private int value;
        protected boolean needWrite;
        protected int valueToWrite;
        protected boolean postpone;
        private boolean unsigned;
        private boolean hex;

        public void setUnsigned(boolean bl) {
            this.unsigned = bl;
        }

        public void setHex(boolean bl) {
            this.hex = bl;
        }

        public boolean isHex() {
            return this.hex;
        }

        public boolean isGood() {
            return this.good;
        }

        public int getValue() {
            return this.value;
        }

        public boolean isWriting() {
            return this.needWrite;
        }

        public int writingValue() {
            return this.valueToWrite;
        }

        private void writeValue(int n, boolean bl) {
            this.needWrite = true;
            this.valueToWrite = n;
            this.postpone = bl;
        }

        private void updateValue(ModbusClient modbusClient, int n) {
            this.good = modbusClient.getResult() == 0;
            int n2 = modbusClient.getFunction();
            if (this.good) {
                if (n2 == 2 || n2 == 1) {
                    int n3 = this.value = modbusClient.getResponseBit(n) ? 1 : 0;
                }
                if (n2 == 4 || n2 == 3) {
                    this.value = modbusClient.getResponseRegister(n, this.unsigned);
                }
            }
        }
    }
}

