/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.client;

import certa.modbus.ModbusPdu;
import certa.modbus.client.ModbusClientTransport;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusClient
extends ModbusPdu
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ModbusClient.class);
    public static final byte RESULT_OK = 0;
    public static final byte RESULT_TIMEOUT = 1;
    public static final byte RESULT_EXCEPTION = 2;
    public static final byte RESULT_BAD_RESPONSE = 3;
    private boolean requestReady = false;
    private boolean responseReady = false;
    private byte srvId;
    private int expectedPduSize;
    private int expectedAddress = -1;
    private int expectedCount = -1;
    private int result;
    private ModbusClientTransport transport;

    public void setTransport(ModbusClientTransport modbusClientTransport) {
        this.transport = modbusClientTransport;
    }

    public byte getServerId() {
        return this.srvId;
    }

    protected int getExpectedPduSize() {
        return this.expectedPduSize;
    }

    protected void initCustomRequest(int n, int n2, byte by, int n3) {
        this.setPduSize(n2);
        this.writeByteToPDU(0, by);
        this.srvId = (byte)n;
        this.expectedAddress = -1;
        this.expectedCount = -1;
        this.expectedPduSize = n3;
        this.requestReady = true;
        this.responseReady = false;
    }

    protected void initRequest(int n, int n2, byte by, int n3, int n4, int n5, int n6, int n7) {
        this.setPduSize(n2);
        this.writeByteToPDU(0, by);
        this.writeInt16ToPDU(1, n3);
        this.writeInt16ToPDU(3, n4);
        this.srvId = (byte)n;
        this.expectedAddress = n5;
        this.expectedCount = n6;
        this.expectedPduSize = n7;
        this.requestReady = true;
        this.responseReady = false;
    }

    public void InitReadCoilsRequest(int n, int n2, int n3) {
        if (n3 < 1 || n3 > 2000) {
            throw new IllegalArgumentException();
        }
        this.initRequest(n, 5, (byte)1, n2, n3, n2, n3, 2 + ModbusClient.bytesCount(n3));
    }

    public void InitReadDInputsRequest(int n, int n2, int n3) {
        if (n3 < 1 || n3 > 2000) {
            throw new IllegalArgumentException();
        }
        this.initRequest(n, 5, (byte)2, n2, n3, n2, n3, 2 + ModbusClient.bytesCount(n3));
    }

    public void InitReadHoldingsRequest(int n, int n2, int n3) {
        if (n3 < 1 || n3 > 125) {
            throw new IllegalArgumentException();
        }
        this.initRequest(n, 5, (byte)3, n2, n3, n2, n3, 2 + n3 * 2);
    }

    public void InitReadAInputsRequest(int n, int n2, int n3) {
        if (n3 < 1 || n3 > 125) {
            throw new IllegalArgumentException();
        }
        this.initRequest(n, 5, (byte)4, n2, n3, n2, n3, 2 + n3 * 2);
    }

    public void InitWriteCoilRequest(int n, int n2, boolean bl) {
        this.initRequest(n, 5, (byte)5, n2, bl ? 65280 : 0, -1, -1, 5);
    }

    public void InitWriteRegisterRequest(int n, int n2, int n3) {
        this.initRequest(n, 5, (byte)6, n2, n3, -1, -1, 5);
    }

    public void InitWriteCoilsRequest(int n, int n2, boolean[] blArray) {
        if (blArray.length > 1968) {
            throw new IllegalArgumentException();
        }
        int n3 = ModbusClient.bytesCount(blArray.length);
        this.initRequest(n, 6 + n3, (byte)15, n2, blArray.length, -1, -1, 5);
        this.writeByteToPDU(5, (byte)n3);
        for (int i = 0; i < n3; ++i) {
            byte by = 0;
            for (int j = 0; j < 8; ++j) {
                int n4 = i * 8 + j;
                if (n4 >= blArray.length || !blArray[n4]) continue;
                by = (byte)(by | 1 << j);
            }
            this.writeByteToPDU(6 + i, by);
        }
    }

    public void InitWriteRegistersRequest(int n, int n2, int[] nArray) {
        if (nArray.length > 123) {
            throw new IllegalArgumentException();
        }
        int n3 = nArray.length * 2;
        this.initRequest(n, 6 + n3, (byte)16, n2, nArray.length, -1, -1, 5);
        this.writeByteToPDU(5, (byte)n3);
        for (int i = 0; i < nArray.length; ++i) {
            this.writeInt16ToPDU(6 + i * 2, nArray[i]);
        }
    }

    public boolean execRequest() throws Exception {
        if (!this.requestReady) {
            throw new IllegalStateException("Call InitXXXRequest() first.");
        }
        if (this.transport == null) {
            throw new IllegalStateException("Transport is not set.");
        }
        this.transport.sendRequest(this);
        this.requestReady = false;
        this.result = this.transport.waitResponse(this);
        boolean bl = this.responseReady = this.result == 0;
        if (!this.responseReady && log != null && log.isWarnEnabled()) {
            if (this.result == 2) {
                log.warn("Exception 0x{} from {}", (Object)ModbusClient.byteToHex((byte)this.getExceptionCode()), (Object)this.getServerId());
            } else {
                log.warn(this.getResultAsString() + " from {}", (Object)this.getServerId());
            }
        }
        return this.responseReady;
    }

    public int getResult() {
        return this.result;
    }

    public String getResultAsString() {
        switch (this.result) {
            case 0: {
                return "OK";
            }
            case 3: {
                return "Bad response";
            }
            case 2: {
                return "Exception " + this.getExceptionCode();
            }
            case 1: {
                return "Timeout";
            }
        }
        return null;
    }

    public int getExceptionCode() {
        if ((this.getFunction() & 0x80) == 0 || this.getPduSize() < 2) {
            return 0;
        }
        return this.readByteFromPDU(1, true);
    }

    public int getResponseAddress() {
        if (this.responseReady && this.expectedAddress >= 0) {
            return this.expectedAddress;
        }
        throw new IllegalStateException();
    }

    public int getResponseCount() {
        if (this.responseReady && this.expectedCount >= 0) {
            return this.expectedCount;
        }
        throw new IllegalStateException();
    }

    public boolean getResponseBit(int n) {
        if (this.getFunction() == 1 || this.getFunction() == 2) {
            int n2 = n - this.getResponseAddress();
            if (n2 < 0 || n2 >= this.getResponseCount()) {
                throw new IndexOutOfBoundsException();
            }
            byte by = this.readByteFromPDU(2 + n2 / 8);
            return (by & 1 << n2 % 8) != 0;
        }
        throw new IllegalStateException();
    }

    public int getResponseRegister(int n, boolean bl) {
        if (this.getFunction() == 3 || this.getFunction() == 4) {
            int n2 = n - this.getResponseAddress();
            if (n2 < 0 || n2 >= this.getResponseCount()) {
                throw new IndexOutOfBoundsException();
            }
            return this.readInt16FromPDU(2 + n2 * 2, bl);
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }
}

