/*
 * Decompiled with CFR 0.152.
 */
package certa.mio.tool;

import certa.mio.Utils;
import certa.mio.VersionInfo;
import certa.mio.tool.CommSettingsPanel;
import certa.mio.tool.ConnectDialog;
import certa.mio.tool.ConnectionThread;
import certa.mio.tool.EditFieldKeysHandler;
import certa.mio.tool.IntroPanel;
import certa.mio.tool.Main;
import certa.mio.tool.Mio8UI6DOPanel;
import certa.mio.tool.Mio8UI8DIPanel;
import certa.mio.tool.MioADI1Panel;
import certa.mio.tool.MioAO1Panel;
import certa.mio.tool.RegComboBox;
import certa.mio.tool.Register;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class MainFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    public static final String[] MODELS = new String[]{"\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e", "8UI.8DI", "8DI.6DO", "ADI-1", "AO-1"};
    public static final int MAX_MODEL = MODELS.length - 1;
    protected JButton btnConnect;
    protected JButton btnDisconnect;
    JPanel pnlToolbar;
    JScrollPane scroll;
    JPanel pnlMainContent;
    JPanel pnlWorkContent;
    JPanel pnlStatus;
    JPanel pnlStatusStats;
    JLabel lblStatusNotConnected;
    JLabel lblStatusPort;
    JLabel lblStatusRequests;
    JLabel lblStatusErrors;
    IntroPanel pnlIntro;
    ModelPanel pnlModel;
    NetParamsPanel pnlNet;
    Mio8UI8DIPanel pnl8UI8DI;
    Mio8UI6DOPanel pnl8DI6DO;
    MioADI1Panel pnlADI1;
    MioAO1Panel pnlAO1;
    protected ConnectionThread connection;
    static final String TITLE = "MIO Tool";
    static final String PROP_MAXIMIZE = "main.maximized";
    ActionListener connect = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.connection != null) {
                return;
            }
            CommSettingsPanel commSettingsPanel = ConnectDialog.showDialog();
            if (commSettingsPanel != null) {
                String string = commSettingsPanel.getDescr();
                MainFrame.this.lblStatusPort.setText("<html><b>" + string + "</b></html>");
                MainFrame.this.setTitle("MIO Tool - " + string + (Main.calibration ? " - \u041a\u0410\u041b\u0418\u0411\u0420\u041e\u0412\u041a\u0410" : ""));
                MainFrame.this.connection = new ConnectionThread(Main.frameInstance(), commSettingsPanel);
            }
        }
    };
    ActionListener disconnect = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.connection != null) {
                MainFrame.this.connection.stop();
            }
        }
    };
    private static String[] SPEED = new String[]{"", "2400", "4800", "9600", "14400", "19200", "38400"};
    private static int[] SPEED_VALUES = new int[]{0, 2400, 4800, 9600, 14400, 19200, 38400};
    private static String[] STOP_BITS = new String[]{"", "1", "2"};
    private static String[] PARITY = new String[]{"", "NO", "EVEN", "ODD"};

    public MainFrame() {
        super(TITLE);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pnlToolbar = new JPanel(new MigLayout("", "[]20[][grow]", ""));
        this.btnConnect = new JButton("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c...");
        this.btnConnect.addActionListener(this.connect);
        this.btnDisconnect = new JButton("\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c");
        this.btnDisconnect.addActionListener(this.disconnect);
        JLabel jLabel = new JLabel("\u0412\u0435\u0440\u0441\u0438\u044f: " + VersionInfo.shortString);
        this.pnlToolbar.add((Component)this.btnConnect, "");
        this.pnlToolbar.add((Component)this.btnDisconnect, "");
        this.pnlToolbar.add((Component)jLabel, "al right");
        this.add((Component)this.pnlToolbar, "North");
        this.pnlMainContent = new JPanel(new CardLayout());
        this.pnlWorkContent = new JPanel(new MigLayout("", "10[][]", "10[][]"));
        this.scroll = new JScrollPane(this.pnlWorkContent);
        this.pnlIntro = new IntroPanel();
        this.pnlModel = new ModelPanel();
        this.pnlNet = new NetParamsPanel();
        this.pnl8UI8DI = new Mio8UI8DIPanel();
        this.pnl8DI6DO = new Mio8UI6DOPanel();
        this.pnlADI1 = new MioADI1Panel();
        this.pnlAO1 = new MioAO1Panel();
        this.pnlWorkContent.add((Component)this.pnlModel, "");
        this.pnlWorkContent.add((Component)this.pnlNet, "wrap");
        this.pnlWorkContent.add((Component)this.pnl8UI8DI, "span 2, hidemode 3");
        this.pnlWorkContent.add((Component)this.pnl8DI6DO, "span 2, hidemode 3");
        this.pnlWorkContent.add((Component)this.pnlADI1, "span 2, hidemode 3");
        this.pnlWorkContent.add((Component)this.pnlAO1, "span 2, hidemode 3");
        this.add((Component)this.pnlMainContent, "Center");
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new BoxLayout(this.pnlStatus, 0));
        this.pnlStatus.setBorder(BorderFactory.createSoftBevelBorder(1));
        this.pnlStatusStats = new JPanel();
        this.pnlStatusStats.setLayout(new BoxLayout(this.pnlStatusStats, 0));
        this.lblStatusNotConnected = new JLabel("\u041d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
        this.lblStatusPort = new JLabel("");
        this.lblStatusRequests = new JLabel("");
        this.lblStatusErrors = new JLabel("");
        this.pnlStatusStats.add(this.lblStatusPort);
        this.pnlStatusStats.add(new JLabel("      \u0417\u0430\u043f\u0440\u043e\u0441\u044b: "));
        this.pnlStatusStats.add(this.lblStatusRequests);
        this.pnlStatusStats.add(new JLabel("    \u041e\u0448\u0438\u0431\u043a\u0438: "));
        this.pnlStatusStats.add(this.lblStatusErrors);
        this.pnlStatus.add(this.lblStatusNotConnected);
        this.pnlStatus.add(this.pnlStatusStats);
        this.add((Component)this.pnlStatus, "South");
        this.setMinimumSize(new Dimension(320, 240));
        this.setPreferredSize(new Dimension(800, 640));
        this.disconnected(null);
        this.pack();
        this.setLocationByPlatform(true);
        if (Main.props.getBool(PROP_MAXIMIZE, true)) {
            this.setExtendedState(6);
        }
    }

    private void resetControls() {
        this.setTitle(TITLE);
        this.pnlModel.tfModel.setText("");
        this.pnlModel.tfVersion.setText("");
        this.pnlModel.tfResetCount.setText("");
        this.lblStatusRequests.setText("0");
        this.lblStatusErrors.setText("0");
        this.pnlNet.setVisible(false);
        this.pnl8UI8DI.setVisible(false);
        this.pnl8DI6DO.setVisible(false);
        this.pnlADI1.setVisible(false);
        this.pnlAO1.setVisible(false);
    }

    public void connected() {
        this.pnlMainContent.removeAll();
        this.pnlMainContent.add(this.scroll);
        this.btnConnect.setEnabled(false);
        this.btnDisconnect.setEnabled(true);
        this.btnDisconnect.setEnabled(true);
        this.pnlModel.setVisible(true);
        this.pnlStatusStats.setVisible(true);
        this.lblStatusNotConnected.setVisible(false);
        MainFrame.updateTextField(this.pnlModel.tfModel, "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435...");
        MainFrame.updateTextField(this.pnlModel.tfVersion, "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435...");
        this.repaint();
    }

    public void disconnected(String string) {
        this.pnlMainContent.removeAll();
        this.pnlMainContent.add(this.pnlIntro);
        this.btnConnect.setEnabled(true);
        this.btnDisconnect.setEnabled(false);
        this.pnlModel.setVisible(false);
        this.pnlStatusStats.setVisible(false);
        this.lblStatusNotConnected.setVisible(true);
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
        }
        this.connection = null;
        this.resetControls();
        this.repaint();
    }

    static void updateTextField(JTextField jTextField, String string) {
        if (!string.equals(jTextField.getText())) {
            jTextField.setText(string);
        }
    }

    static void updateRegister(JTextField jTextField, Register register, int n, int n2, boolean bl) {
        String string = "-";
        if (register.isGood()) {
            string = Utils.FormatDouble((double)register.getValue() / (double)n, n2);
        }
        if (bl) {
            jTextField.setBackground("1".equals(string) ? Color.GREEN : null);
        }
        String string2 = null;
        if (register.isWriting()) {
            string2 = Utils.FormatDouble((double)register.writingValue() / (double)n, n2);
        }
        MainFrame.updateRegisterText(jTextField, string, string2);
    }

    static void updateRegister32(JTextField jTextField, Register register, Register register2) {
        String string = "-";
        if (register.isGood() && register2.isGood()) {
            string = Utils.FormatDouble((double)register2.getValue() * 65536.0 + (double)register.getValue(), 0);
        }
        String string2 = null;
        if (register.isWriting() || register2.isWriting()) {
            string2 = Utils.FormatDouble((double)register2.writingValue() * 65536.0 + (double)register.writingValue(), 0);
        }
        MainFrame.updateRegisterText(jTextField, string, string2);
    }

    static void updateRegisterText(JTextField jTextField, String string, String string2) {
        if (!Utils.strEmpty(string2)) {
            string = jTextField.getHorizontalAlignment() == 4 ? string2 + " --> " + string : string + " <-- " + string2;
        }
        if (!string.equals(jTextField.getText())) {
            jTextField.setText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        if (this.connection != null) {
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                this.pnlModel.updateData();
                this.lblStatusRequests.setText(Integer.toString(this.connection.requestsCount));
                this.lblStatusErrors.setText(Integer.toString(this.connection.errorsCount));
                boolean bl = this.connection.modelDetected && this.connection.versionDetected;
                this.pnlNet.setVisible(bl);
                this.pnl8UI8DI.setVisible(bl && this.connection.model == 1);
                this.pnl8DI6DO.setVisible(bl && this.connection.model == 2);
                this.pnlADI1.setVisible(bl && this.connection.model == 3);
                this.pnlAO1.setVisible(bl && this.connection.model == 4);
                this.pnlNet.updateData();
                this.pnl8DI6DO.updateData();
                this.pnl8UI8DI.updateData();
                this.pnlADI1.updateData();
                this.pnlAO1.updateData();
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.connection != null) {
            this.connection.stop();
        }
        this.setDefaultCloseOperation(3);
        Main.props.saveBool(PROP_MAXIMIZE, this.getExtendedState() == 6);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static JButton createWriteButton(ActionListener actionListener) {
        JButton jButton = new JButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c");
        jButton.addActionListener(actionListener);
        return jButton;
    }

    static JTextField createRegView(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        return jTextField;
    }

    static RegComboBox createRegCombo(String[] stringArray, KeyListener keyListener) {
        RegComboBox regComboBox = new RegComboBox(stringArray);
        regComboBox.addKeyListener(keyListener);
        regComboBox.setSelectedIndex(0);
        return regComboBox;
    }

    static JTextField createRegEdit(int n, KeyListener keyListener) {
        JTextField jTextField = new JTextField(n);
        jTextField.addKeyListener(keyListener);
        return jTextField;
    }

    static void writeReg(Register register, int n, int n2, int n3) {
        if (n >= n2 && n <= n3) {
            register.writeValue(n);
        }
    }

    static void writeRegFromTF(Register register, JTextField jTextField, int n, int n2, int n3) {
        double d = Utils.StringToDouble(jTextField.getText());
        jTextField.setText("");
        if (Double.isNaN(d)) {
            return;
        }
        int n4 = Utils.Round(d * (double)n);
        if (n4 >= n2 && n4 <= n3) {
            register.writeValue(n4);
        }
    }

    static void writeRegFromTF32(Register register, Register register2, JTextField jTextField) {
        double d = Utils.StringToDouble(jTextField.getText());
        jTextField.setText("");
        if (Double.isNaN(d)) {
            return;
        }
        long l = Math.round(d);
        if (l >= 0L && l <= 0xFFFFFFFFL) {
            register.writeValue((int)(l & 0xFFFFL));
            register2.writeValue((int)(l >>> 16 & 0xFFFFL));
        }
    }

    static JTextField[] createRegViews(int n, int n2) {
        JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jTextFieldArray[i] = MainFrame.createRegView(n2);
            jTextFieldArray[i].setHorizontalAlignment(4);
        }
        return jTextFieldArray;
    }

    static JTextField[] createRegEdits(int n, int n2, ActionListener actionListener) {
        EditFieldKeysHandler editFieldKeysHandler = new EditFieldKeysHandler(actionListener, null, null);
        JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jTextFieldArray[i] = MainFrame.createRegEdit(n2, editFieldKeysHandler);
        }
        return jTextFieldArray;
    }

    static RegComboBox[] createRegCombos(int n, String[] stringArray, ActionListener actionListener) {
        EditFieldKeysHandler editFieldKeysHandler = new EditFieldKeysHandler(actionListener, null, null);
        RegComboBox[] regComboBoxArray = new RegComboBox[n];
        for (int i = 0; i < n; ++i) {
            regComboBoxArray[i] = MainFrame.createRegCombo(stringArray, editFieldKeysHandler);
        }
        return regComboBoxArray;
    }

    class NetParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EditFieldKeysHandler enter;
        JTextField tfNetId;
        JTextField tfNetSpeed;
        JTextField tfNetParity;
        JTextField tfNetStopBits;
        JTextField tfSetNetId;
        RegComboBox cbxSetNetSpeed;
        RegComboBox cbxSetNetParity;
        RegComboBox cbxSetNetStopBits;
        protected JButton btnWrite;

        public NetParamsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.writeRegFromTF(MainFrame.this.connection.netId, NetParamsPanel.this.tfSetNetId, 1, 1, 254);
                            MainFrame.writeReg(MainFrame.this.connection.netSpeed, SPEED_VALUES[NetParamsPanel.this.cbxSetNetSpeed.getSelectedIndex()], 2400, 38400);
                            NetParamsPanel.this.cbxSetNetSpeed.setSelectedIndex(0);
                            MainFrame.writeReg(MainFrame.this.connection.netParity, NetParamsPanel.this.cbxSetNetParity.getSelectedIndex() - 1, 0, 2);
                            NetParamsPanel.this.cbxSetNetParity.setSelectedIndex(0);
                            MainFrame.writeReg(MainFrame.this.connection.netStopBits, NetParamsPanel.this.cbxSetNetStopBits.getSelectedIndex(), 1, 2);
                            NetParamsPanel.this.cbxSetNetStopBits.setSelectedIndex(0);
                            NetParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EditFieldKeysHandler(this.write, null, null);
            this.tfNetId = MainFrame.createRegView(14);
            this.tfNetSpeed = MainFrame.createRegView(14);
            this.tfNetParity = MainFrame.createRegView(14);
            this.tfNetStopBits = MainFrame.createRegView(14);
            this.tfSetNetId = MainFrame.createRegEdit(4, this.enter);
            this.cbxSetNetSpeed = MainFrame.createRegCombo(SPEED, this.enter);
            this.cbxSetNetParity = MainFrame.createRegCombo(PARITY, this.enter);
            this.cbxSetNetStopBits = MainFrame.createRegCombo(STOP_BITS, this.enter);
            this.btnWrite = MainFrame.createWriteButton(this.write);
            this.setBorder(BorderFactory.createTitledBorder("\u0421\u0435\u0442\u0435\u0432\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438"));
            this.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441:"), "al right");
            this.add((Component)this.tfNetId, "");
            this.add((Component)this.tfSetNetId, "wrap");
            this.add((Component)new JLabel("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c:"), "al right");
            this.add((Component)this.tfNetSpeed, "");
            this.add((Component)this.cbxSetNetSpeed, "wrap");
            this.add((Component)new JLabel("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c \u0447\u0435\u0442\u043d\u043e\u0441\u0442\u0438:"), "al right");
            this.add((Component)this.tfNetParity, "");
            this.add((Component)this.cbxSetNetParity, "wrap");
            this.add((Component)new JLabel("\u0421\u0442\u043e\u043f-\u0431\u0438\u0442\u044b:"), "al right");
            this.add((Component)this.tfNetStopBits, "");
            this.add((Component)this.cbxSetNetStopBits, "wrap");
            this.add((Component)this.btnWrite, "skip 1");
            this.add((Component)new JLabel("\u0412\u0445\u043e\u0434 Init \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d \u0441 \u043e\u0431\u0449\u0435\u0439 \u043a\u043b\u0435\u043c\u043c\u043e\u0439 (20)"), "newline, span");
        }

        private String parityString(int n) {
            if (++n >= 0 && n < PARITY.length) {
                return PARITY[n];
            }
            return Integer.toString(n);
        }

        public void updateData() {
            if (this.isVisible()) {
                MainFrame.updateRegister(this.tfNetId, MainFrame.this.connection.netId, 1, 0, false);
                MainFrame.updateRegister(this.tfNetSpeed, MainFrame.this.connection.netSpeed, 1, 0, false);
                Register register = MainFrame.this.connection.netParity;
                MainFrame.updateRegisterText(this.tfNetParity, register.isGood() ? this.parityString(register.getValue()) : "-", register.needWrite ? this.parityString(register.writingValue()) : null);
                MainFrame.updateRegister(this.tfNetStopBits, MainFrame.this.connection.netStopBits, 1, 0, false);
            }
        }
    }

    class ModelPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField tfModel;
        JTextField tfVersion;
        JTextField tfResetCount;

        public ModelPanel() {
            super(new MigLayout("", "", ""));
            this.setBorder(BorderFactory.createTitledBorder("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f"));
            this.tfModel = new JTextField(12);
            this.tfModel.setEditable(false);
            this.tfVersion = new JTextField(12);
            this.tfVersion.setEditable(false);
            this.tfResetCount = new JTextField(12);
            this.tfResetCount.setEditable(false);
            this.add((Component)new JLabel("\u041c\u043e\u0434\u0435\u043b\u044c MIO:"), "al right");
            this.add((Component)this.tfModel, "wrap");
            this.add((Component)new JLabel("\u0412\u0435\u0440\u0441\u0438\u044f \u043f\u0440\u043e\u0448\u0438\u0432\u043a\u0438:"), "al right");
            this.add((Component)this.tfVersion, "wrap");
            this.add((Component)new JLabel("\u041a\u043e\u043b-\u0432\u043e \u0441\u0431\u0440\u043e\u0441\u043e\u0432:"), "al right");
            this.add((Component)this.tfResetCount, "");
        }

        public void updateData() {
            if (this.isVisible()) {
                if (MainFrame.this.connection.modelDetected) {
                    int n = MainFrame.this.connection.model;
                    if (n < 0 || n > MAX_MODEL) {
                        n = 0;
                    }
                    MainFrame.updateTextField(this.tfModel, MODELS[n]);
                    if (n >= 3) {
                        MainFrame.updateTextField(this.tfResetCount, Integer.toString(MainFrame.this.connection.resetCount[0].getValue()));
                    }
                }
                if (MainFrame.this.connection.versionDetected) {
                    MainFrame.updateTextField(this.tfVersion, Integer.toString(MainFrame.this.connection.version));
                }
            }
        }
    }
}

