/*
 * Decompiled with CFR 0.152.
 */
package certa.mio.tool;

import certa.mio.Utils;
import certa.mio.tool.CommSettingsPanel;
import certa.mio.tool.Main;
import certa.mio.tool.MainFrame;
import certa.mio.tool.Register;
import certa.modbus.client.ModbusClient;
import certa.modbus.client.ModbusClientTransport;
import certa.modbus.client.RtuOverTcpTransport;
import certa.modbus.client.RtuTransportJSerialComm;
import certa.modbus.client.TcpTransport;
import java.util.List;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionThread
extends SwingWorker<Void, Void> {
    private static final Logger log = LoggerFactory.getLogger(ConnectionThread.class);
    public static final int MODEL_8UI8DI = 1;
    public static final int MODEL_8DI6DO = 2;
    public static final int MODEL_ADI1 = 3;
    public static final int MODEL_AO1 = 4;
    ModbusClientTransport transport;
    int id;
    MainFrame frame;
    volatile boolean done;
    public int version = -1;
    public boolean versionDetected = false;
    public int model = -1;
    public boolean modelDetected = false;
    public final Register netId = new Register();
    public final Register netSpeed = new Register();
    public final Register netParity = new Register();
    public final Register netStopBits = new Register();
    public final Register[] digitalInputs = ConnectionThread.createRegs(16);
    public final Register[] coils = ConnectionThread.createRegs(6);
    public final Register[] analogInputs = ConnectionThread.createRegs(48);
    public final Register[] adcCodes = ConnectionThread.createRegs(8);
    public final Register[] delays = ConnectionThread.createRegs(16);
    public final Register[] filters = ConnectionThread.createRegs(8);
    public final Register[] timesDO = ConnectionThread.createRegs(6);
    public final Register[] saveDO = ConnectionThread.createRegs(6);
    public final Register calibrPwd = new Register();
    public final Register calibrCmd = new Register();
    public final Register[] resetCount = ConnectionThread.createRegs(1);
    public final Register[] counters = ConnectionThread.createRegs(16);
    public final Register[] analogOutputs = ConnectionThread.createRegs(4);
    public final Register[] dacCodes = ConnectionThread.createRegs(4);
    public int requestsCount;
    public int errorsCount;
    private String error = null;
    private ModbusClient modbus;

    public ConnectionThread(MainFrame mainFrame, CommSettingsPanel commSettingsPanel) {
        this.frame = mainFrame;
        try {
            mainFrame.connected();
            if (commSettingsPanel.isRtu()) {
                this.transport = new RtuTransportJSerialComm(commSettingsPanel.getPortName(), commSettingsPanel.getBaudRate(), 8, commSettingsPanel.getParity(), commSettingsPanel.getStopBits(), 2000, 50);
            } else if (commSettingsPanel.isTcp()) {
                this.transport = new TcpTransport(commSettingsPanel.getTcpHost(), commSettingsPanel.getTcpPort(), null, 0, 5000, 2000, 50, true);
            } else if (commSettingsPanel.isRtuOverTcp()) {
                this.transport = new RtuOverTcpTransport(commSettingsPanel.getTcpHost(), commSettingsPanel.getTcpPort(), null, 0, 5000, 2000, 50, true);
            } else {
                throw new Exception("Unknown transport");
            }
            this.id = commSettingsPanel.getDeviceId();
            this.execute();
        }
        catch (Throwable throwable) {
            Utils.ProcessException(throwable, false);
            this.error = throwable.getMessage();
            if (Utils.strEmpty(this.error)) {
                this.error = throwable.getClass().getSimpleName();
            }
            this.done();
        }
    }

    public void stop() {
        this.done = true;
        this.cancel(true);
    }

    private static Register[] createRegs(int n) {
        Register[] registerArray = new Register[n];
        for (int i = 0; i < registerArray.length; ++i) {
            registerArray[i] = new Register();
        }
        return registerArray;
    }

    private synchronized void setVersion(int n) {
        this.version = n;
        this.versionDetected = true;
    }

    private synchronized void setModel(int n) {
        this.model = n;
        this.modelDetected = true;
    }

    private synchronized void incRequestsCount() {
        ++this.requestsCount;
    }

    private synchronized void incErrorosCount() {
        ++this.errorsCount;
    }

    private boolean noSuchAddress() {
        return this.modbus.getResult() == 2 && this.modbus.getExceptionCode() == 2;
    }

    private void readVersion() throws Exception {
        if (this.versionDetected) {
            return;
        }
        log.trace("Read version");
        this.modbus.InitReadAInputsRequest(this.id, 1000, 1);
        if (this.modbus.execRequest()) {
            this.setVersion(this.modbus.getResponseRegister(1000, true));
        } else if (this.noSuchAddress()) {
            this.setVersion(0);
        } else {
            this.incErrorosCount();
        }
        this.incRequestsCount();
        if (this.versionDetected) {
            log.trace("Version: {}", (Object)this.version);
        }
    }

    private void readModel() throws Exception {
        if (this.modelDetected) {
            return;
        }
        log.trace("Read model");
        this.modbus.InitReadAInputsRequest(this.id, 1001, 1);
        if (this.modbus.execRequest()) {
            this.setModel(this.modbus.getResponseRegister(1001, true));
        } else if (this.noSuchAddress()) {
            this.setModel(0);
        } else {
            this.incErrorosCount();
        }
        this.incRequestsCount();
        if (this.modelDetected && this.model == 0) {
            this.modbus.InitReadAInputsRequest(this.id, 0, 24);
            if (this.modbus.execRequest()) {
                this.setModel(1);
            } else if (this.noSuchAddress()) {
                this.setModel(2);
            } else {
                this.incErrorosCount();
            }
            this.incRequestsCount();
        }
        if (this.modelDetected) {
            log.trace("Model: {}", (Object)this.model);
        }
    }

    private boolean execAndCheck() throws Exception {
        boolean bl = this.modbus.execRequest();
        this.incRequestsCount();
        if (!bl) {
            this.incErrorosCount();
            if (this.modbus.getResult() == 2) {
                throw new Exception("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c\u043e\u0435 \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e");
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReg(Register register, int n, boolean bl) throws Exception {
        boolean bl2 = false;
        int n2 = 0;
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            bl2 = register.needWrite;
            n2 = register.valueToWrite;
            register.needWrite = false;
        }
        if (bl2) {
            log.trace("Write {} at {}", (Object)(bl ? "HR" : "coil"), (Object)n);
            if (bl) {
                this.modbus.InitWriteRegisterRequest(this.id, n, n2);
            } else {
                this.modbus.InitWriteCoilRequest(this.id, n, n2 != 0);
            }
            if (!this.modbus.execRequest()) {
                this.incErrorosCount();
            }
            this.incRequestsCount();
        }
    }

    private void processNetParams() throws Exception {
        this.writeReg(this.netId, 0, true);
        this.writeReg(this.netSpeed, 1, true);
        this.writeReg(this.netStopBits, 2, true);
        this.writeReg(this.netParity, 3, true);
        log.trace("Read network parameters");
        this.modbus.InitReadHoldingsRequest(this.id, 0, 1);
        this.execAndCheck();
        this.netId.updateValue(this.modbus, 0, true);
        this.modbus.InitReadHoldingsRequest(this.id, 1, 3);
        this.execAndCheck();
        this.netSpeed.updateValue(this.modbus, 1, true);
        this.netStopBits.updateValue(this.modbus, 2, true);
        this.netParity.updateValue(this.modbus, 3, true);
    }

    private void processRegArray(Register[] registerArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        int n3;
        if (bl) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.writeReg(registerArray[n3], n + n3, bl2);
            }
        }
        if (bl2) {
            if (bl) {
                this.modbus.InitReadHoldingsRequest(this.id, n, n2);
            } else {
                this.modbus.InitReadAInputsRequest(this.id, n, n2);
            }
        } else if (bl) {
            this.modbus.InitReadCoilsRequest(this.id, n, n2);
        } else {
            this.modbus.InitReadDInputsRequest(this.id, n, n2);
        }
        if (bl4) {
            if (!this.modbus.execRequest()) {
                this.incErrorosCount();
            }
            this.incRequestsCount();
        } else {
            this.execAndCheck();
        }
        for (n3 = 0; n3 < n2; ++n3) {
            registerArray[n3].updateValue(this.modbus, n + n3, bl3);
        }
    }

    private void process8UI8DI() throws Exception {
        log.trace("Read 8UI.8DI registers");
        this.processRegArray(this.digitalInputs, 0, 16, false, false, false, false);
        this.processRegArray(this.analogInputs, 0, 24, false, true, false, false);
        this.processRegArray(this.delays, 4, 16, true, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processADI1() throws Exception {
        log.trace("Process ADI-1 registers");
        boolean bl = false;
        ConnectionThread connectionThread = this;
        synchronized (connectionThread) {
            bl = this.calibrPwd.needWrite && this.calibrCmd.needWrite;
        }
        if (bl) {
            this.writeReg(this.calibrPwd, 1099, true);
            this.writeReg(this.calibrCmd, 1100, true);
        }
        this.processRegArray(this.digitalInputs, 0, 16, false, false, false, false);
        this.processRegArray(this.analogInputs, 0, 48, false, true, false, false);
        this.processRegArray(this.adcCodes, 1100, 8, false, true, true, false);
        this.processRegArray(this.delays, 4, 16, true, true, true, false);
        this.processRegArray(this.filters, 20, 8, true, true, true, false);
        this.processRegArray(this.counters, 28, 16, true, true, true, false);
        this.processRegArray(this.resetCount, 1002, 1, false, true, true, false);
    }

    private void processAO1() throws Exception {
        log.trace("Process AO-1 registers");
        this.processRegArray(this.analogOutputs, 4, 4, true, true, false, false);
        this.processRegArray(this.resetCount, 1002, 1, false, true, true, false);
        if (Main.calibration) {
            this.writeReg(this.calibrPwd, 1099, true);
            for (int i = 0; i < this.dacCodes.length; ++i) {
                this.writeReg(this.dacCodes[i], 1100 + i, true);
            }
            this.processRegArray(this.dacCodes, 1100, 4, true, true, true, false);
        }
    }

    private void process8DI6DO() throws Exception {
        log.trace("Read 8DI.6DO registers");
        this.processRegArray(this.digitalInputs, 0, 8, false, false, false, false);
        this.processRegArray(this.coils, 0, 6, true, false, false, false);
        this.processRegArray(this.saveDO, 1000, 6, true, false, false, true);
        this.processRegArray(this.delays, 4, 8, true, true, true, false);
        this.processRegArray(this.timesDO, 20, 6, true, true, true, true);
    }

    @Override
    protected Void doInBackground() throws Exception {
        block15: {
            try {
                this.modbus = new ModbusClient();
                try {
                    this.modbus.setTransport(this.transport);
                    while (!this.done) {
                        this.readVersion();
                        this.readModel();
                        if (this.versionDetected && this.modelDetected) {
                            this.processNetParams();
                            if (this.model == 1) {
                                this.process8UI8DI();
                            } else if (this.model == 2) {
                                this.process8DI6DO();
                            } else if (this.model == 3) {
                                this.processADI1();
                            } else if (this.model == 4) {
                                this.processAO1();
                            }
                        }
                        this.publish(new Void[0]);
                        Thread.sleep(200L);
                    }
                }
                finally {
                    log.debug("DONE");
                    this.modbus.close();
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug("Interrupted");
            }
            catch (Throwable throwable) {
                Utils.ProcessException(throwable, false);
                this.error = throwable.getMessage();
                if (!Utils.strEmpty(this.error)) break block15;
                this.error = throwable.getClass().getSimpleName();
            }
        }
        return null;
    }

    @Override
    public void done() {
        if (this.modbus != null) {
            this.modbus.close();
        }
        this.frame.disconnected(this.error);
    }

    @Override
    protected void process(List<Void> list) {
        this.frame.updateData();
    }
}

