/*
 * Decompiled with CFR 0.152.
 */
package certa.modbus.server;

import certa.modbus.ModbusPdu;
import certa.modbus.server.AModbusServer;
import certa.modbus.server.ModbusTcpServer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

class ModbusTcpServerConnection
extends ModbusPdu
implements Runnable,
Closeable {
    private AtomicBoolean active = new AtomicBoolean(true);
    private final Thread thread;
    private final Socket socket;
    private final AModbusServer server;
    private final byte[] buffer = new byte[260];

    public ModbusTcpServerConnection(AModbusServer aModbusServer, Socket socket) {
        this.server = aModbusServer;
        this.socket = socket;
        this.thread = new Thread(null, this);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void close() {
        if (this.active.getAndSet(false)) {
            this.server.log.debug("Closing connection");
            this.thread.interrupt();
            this.closeSocket();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void closeSocket() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            this.server.log.error("EXCEPTION in ModbusTcpServerConnection.close()", iOException);
        }
    }

    private boolean waitRequest() throws IOException {
        InputStream inputStream = this.socket.getInputStream();
        int n = inputStream.read(this.buffer, 0, 6);
        if (n < 0) {
            this.server.log.trace("End of Stream");
            this.close();
            return false;
        }
        if (n < 6) {
            this.server.logData("Read (incomplete MBAP): ", this.buffer, 0, n);
            this.server.log.warn("Error reading MBAP header");
            this.close();
            return false;
        }
        int n2 = ModbusTcpServerConnection.bytesToInt16(this.buffer[5], this.buffer[4], true);
        if (n2 < 2 || n2 > this.buffer.length - 6) {
            this.server.logData("Read (invalid length): ", this.buffer, 0, n);
            this.server.log.warn("Invalid data length: {}", (Object)n2);
            this.close();
            return false;
        }
        n = inputStream.read(this.buffer, 6, n2);
        if (n < n2) {
            this.server.logData("Read (incomplete PDU): ", this.buffer, 0, n + 6);
            this.server.log.warn("Error reading PDU");
            this.close();
            return false;
        }
        this.server.logData("Read (complete): ", this.buffer, 0, n2 + 6);
        this.pduSize = n2 - 1;
        System.arraycopy(this.buffer, 7, this.pdu, 0, this.pduSize);
        return true;
    }

    private void sendResponse() throws IOException {
        if (this.pduSize == 0) {
            return;
        }
        this.buffer[4] = ModbusTcpServerConnection.highByte(this.pduSize + 1);
        this.buffer[5] = ModbusTcpServerConnection.lowByte(this.pduSize + 1);
        System.arraycopy(this.pdu, 0, this.buffer, 7, this.pduSize);
        int n = this.pduSize + 7;
        this.server.logData("Write: ", this.buffer, 0, n);
        this.socket.getOutputStream().write(this.buffer, 0, n);
    }

    @Override
    public void run() {
        this.server.log.debug("CONNECTION THREAD START");
        this.server.log.info("Client connected: {}", (Object)this.socket.getRemoteSocketAddress());
        try {
            try {
                while (this.active.get() && !Thread.currentThread().isInterrupted()) {
                    if (this.waitRequest()) {
                        if (!this.server.processor.processRequest(this)) continue;
                        this.sendResponse();
                        continue;
                    }
                    Thread.sleep(1000L);
                }
            }
            finally {
                this.active.set(false);
                this.closeSocket();
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.server.log.debug("Client timeout");
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable throwable) {
            this.server.log.error("CONNECTION THREAD TERMINATED ", throwable);
        }
        ((ModbusTcpServer)this.server).unregisterConnection(this);
        this.server.log.debug("CONNECTION THREAD END");
        this.server.log.info("Client disconnected: {}", (Object)this.socket.getRemoteSocketAddress());
    }
}

