/*
 * Decompiled with CFR 0.152.
 */
package certa.atom.tool;

import certa.atom.tool.CommSettingsPanel;
import certa.atom.tool.ConnectDialog;
import certa.atom.tool.ConnectionThread;
import certa.atom.tool.EnterHandler;
import certa.atom.tool.IntroPanel;
import certa.atom.tool.Main;
import certa.atom.tool.RegComboBox;
import certa.atom.tool.Register;
import certa.atom.tool.Utils;
import certa.atom.tool.VersionInfo;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class MainFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    protected JButton btnConnect;
    protected JButton btnDisconnect;
    JLabel lblModel;
    JLabel lblVersion;
    JPanel pnlToolbar;
    JScrollPane scroll;
    JPanel pnlMainContent;
    JPanel pnlWorkContent;
    JPanel pnlStatus;
    JPanel pnlStatusStats;
    JLabel lblStatusNotConnected;
    JLabel lblStatusPort;
    JLabel lblStatusRequests;
    JLabel lblStatusErrors;
    JLabel lblStatusStack;
    JLabel lblModeInit;
    JLabel lblModeNoProg;
    JLabel lblModeCalibr;
    JLabel lblModeProg;
    JLabel lblProgName;
    IntroPanel pnlIntro;
    AInputsPtPanel pnlAnalogInPt;
    AInputsNTCPanel pnlAnalogInNTC;
    AInputsVoltPanel pnlAnalogInVolt;
    DInputsPanel pnlDigitalIn;
    AOutputsPanel pnlAnalogOut;
    DOutputsPanel pnlDigitalOut;
    NetParamsPanel pnlNetParams1;
    NetParamsPanel pnlNetParams2;
    ClockParamsPanel pnlClockParams;
    protected ConnectionThread connection;
    static final String TITLE = "Atom Tool v" + VersionInfo.fullString;
    static final String PROP_MAXIMIZE = "main.maximized";
    boolean calibration;
    ActionListener connect = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MainFrame.this.connection != null) {
                return;
            }
            CommSettingsPanel commSettingsPanel = ConnectDialog.showDialog();
            if (commSettingsPanel != null) {
                MainFrame.this.calibration = commSettingsPanel.calibration;
                String string = commSettingsPanel.getDescr();
                MainFrame.this.lblStatusPort.setText("<html><b>" + string + "</b></html>");
                MainFrame.this.setTitle(TITLE + " - " + string + (MainFrame.this.calibration ? " - \u041a\u0410\u041b\u0418\u0411\u0420\u041e\u0412\u041a\u0410" : ""));
                MainFrame.this.connection = new ConnectionThread(Main.frameInstance(), commSettingsPanel);
            }
        }
    };
    ActionListener disconnect = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.closeConnection();
        }
    };
    private static String[] SPEED = new String[]{"", "1200", "2400", "4800", "9600", "19200", "38400"};
    private static String[] STOP_BITS = new String[]{"", "1", "2"};
    private static String[] PARITY = new String[]{"", "NO", "EVEN", "ODD"};
    private static String[] WEEKDAY = new String[]{"", "\u041f\u041d", "\u0412\u0422", "\u0421\u0420", "\u0427\u0422", "\u041f\u0422", "\u0421\u0411", "\u0412\u0421"};
    private static String[] MONTH = new String[]{"", "\u044f\u043d\u0432\u0430\u0440\u044c", "\u0444\u0435\u0432\u0440\u0430\u043b\u044c", "\u043c\u0430\u0440\u0442", "\u0430\u043f\u0440\u0435\u043b\u044c", "\u043c\u0430\u0439", "\u0438\u044e\u043d\u044c", "\u0438\u044e\u043b\u044c", "\u0430\u0432\u0433\u0443\u0441\u0442", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044c", "\u043e\u043a\u0442\u044f\u0431\u0440\u044c", "\u043d\u043e\u044f\u0431\u0440\u044c", "\u0434\u0435\u043a\u0430\u0431\u0440\u044c"};

    public MainFrame() {
        super(TITLE);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        this.pnlToolbar = new JPanel(new MigLayout("", "[]20[]30[]30[]30[]30[]30[]30[grow]", ""));
        this.btnConnect = new JButton("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c...");
        this.btnConnect.addActionListener(this.connect);
        this.btnDisconnect = new JButton("\u041e\u0442\u043a\u043b\u044e\u0447\u0438\u0442\u044c");
        this.btnDisconnect.addActionListener(this.disconnect);
        this.lblModel = new JLabel(" ");
        this.lblVersion = new JLabel(" ");
        this.lblModeInit = new JLabel("<html><center><b><font color='blue'>\u041f\u0435\u0440\u0435\u043c\u044b\u0447\u043a\u0430<br>INIT</font></b></center></html>");
        this.lblModeNoProg = new JLabel("<html><center><b><font color='purple'>\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430<br>\u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430</font></b></center></html>");
        this.lblModeCalibr = new JLabel("<html><center><b><font color='red'>\u0420\u0435\u0436\u0438\u043c<br>\u043a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0438</font></b></center></html>");
        this.lblModeProg = new JLabel("<html><center><b><font color='red'>\u0417\u0430\u043f\u0438\u0441\u044c<br>\u041f\u041e</font></b></center></html>");
        this.lblProgName = new JLabel(" ");
        this.pnlToolbar.add((Component)this.btnConnect, "");
        this.pnlToolbar.add((Component)this.btnDisconnect, "");
        this.pnlToolbar.add((Component)this.lblModel, "al left");
        this.pnlToolbar.add((Component)this.lblVersion, "al left");
        this.pnlToolbar.add((Component)this.lblModeInit, "al left");
        this.pnlToolbar.add((Component)this.lblModeNoProg, "al left");
        this.pnlToolbar.add((Component)this.lblModeCalibr, "al left");
        this.pnlToolbar.add((Component)this.lblModeProg, "al left");
        this.pnlToolbar.add((Component)this.lblProgName, "al left");
        this.add((Component)this.pnlToolbar, "North");
        this.pnlMainContent = new JPanel(new CardLayout());
        this.pnlWorkContent = new JPanel(new MigLayout(""));
        this.scroll = new JScrollPane(this.pnlWorkContent);
        this.pnlIntro = new IntroPanel();
        this.add((Component)this.pnlMainContent, "Center");
        this.pnlStatus = new JPanel();
        this.pnlStatus.setLayout(new BoxLayout(this.pnlStatus, 0));
        this.pnlStatus.setBorder(BorderFactory.createSoftBevelBorder(1));
        this.pnlStatusStats = new JPanel();
        this.pnlStatusStats.setLayout(new BoxLayout(this.pnlStatusStats, 0));
        this.lblStatusNotConnected = new JLabel("\u041d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e");
        this.lblStatusPort = new JLabel("");
        this.lblStatusRequests = new JLabel("");
        this.lblStatusErrors = new JLabel("");
        this.lblStatusStack = new JLabel("");
        this.pnlStatusStats.add(this.lblStatusPort);
        this.pnlStatusStats.add(new JLabel("    \u0421\u0442\u0435\u043a: "));
        this.pnlStatusStats.add(this.lblStatusStack);
        this.pnlStatusStats.add(new JLabel("      \u0417\u0430\u043f\u0440\u043e\u0441\u044b: "));
        this.pnlStatusStats.add(this.lblStatusRequests);
        this.pnlStatusStats.add(new JLabel("    \u041e\u0448\u0438\u0431\u043a\u0438: "));
        this.pnlStatusStats.add(this.lblStatusErrors);
        this.pnlStatus.add(this.lblStatusNotConnected);
        this.pnlStatus.add(this.pnlStatusStats);
        this.add((Component)this.pnlStatus, "South");
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(980, 620));
        this.disconnected(null);
        this.pack();
        this.setLocationByPlatform(true);
        if (Main.props.getBool(PROP_MAXIMIZE, false)) {
            this.setExtendedState(6);
        }
    }

    private void createControls() {
        this.pnlWorkContent.removeAll();
        this.pnlAnalogInPt = new AInputsPtPanel();
        this.pnlAnalogInNTC = new AInputsNTCPanel();
        this.pnlAnalogInVolt = new AInputsVoltPanel();
        this.pnlDigitalIn = new DInputsPanel(6);
        this.pnlAnalogOut = new AOutputsPanel();
        this.pnlDigitalOut = new DOutputsPanel();
        this.pnlNetParams1 = new NetParamsPanel(59, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0440\u0442\u0430 1 (\u043a\u043b\u0435\u043c\u043c\u044b 3, 4)");
        this.pnlNetParams2 = new NetParamsPanel(64, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0440\u0442\u0430 2 (\u043a\u043b\u0435\u043c\u043c\u044b 9, 10, 11)");
        this.pnlClockParams = new ClockParamsPanel();
        this.pnlWorkContent.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0440\u0442\u043e\u0432 \u0432\u0441\u0442\u0443\u043f\u0430\u044e\u0442 \u0432 \u0441\u0438\u043b\u0443 \u043f\u043e\u0441\u043b\u0435 \u0441\u043d\u044f\u0442\u0438\u044f \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u043a\u0438. \u0415\u0441\u043b\u0438 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u043a\u0438 \u043d\u0435\u0442 - \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u043b\u0435\u0440\u0430"), "span, wrap");
        this.pnlWorkContent.add((Component)this.pnlNetParams1, "split, span");
        this.pnlWorkContent.add((Component)this.pnlNetParams2, "");
        this.pnlWorkContent.add((Component)this.pnlClockParams, "wrap");
        if (this.calibration) {
            this.pnlWorkContent.add((Component)this.pnlAnalogInPt, "split, span");
            this.pnlWorkContent.add((Component)this.pnlAnalogInNTC, "wrap");
            this.pnlWorkContent.add((Component)this.pnlAnalogInVolt, "split, span");
            this.pnlWorkContent.add((Component)this.pnlAnalogOut, "");
            this.pnlWorkContent.add((Component)this.pnlDigitalIn, "");
            this.pnlWorkContent.add((Component)this.pnlDigitalOut, "");
            this.setExtendedState(6);
        } else {
            this.pnlWorkContent.add((Component)this.pnlAnalogInPt, "");
            this.pnlWorkContent.add((Component)this.pnlAnalogInNTC, "");
            this.pnlWorkContent.add((Component)this.pnlAnalogInVolt, "");
            this.pnlWorkContent.add((Component)this.pnlDigitalIn, "");
            this.pnlWorkContent.add((Component)this.pnlAnalogOut, "");
            this.pnlWorkContent.add((Component)this.pnlDigitalOut, "");
        }
    }

    private void resetControls() {
        this.setTitle(TITLE);
        this.lblModel.setText("");
        this.lblVersion.setText("");
        this.lblProgName.setText("");
        this.lblModeInit.setVisible(false);
        this.lblModeNoProg.setVisible(false);
        this.lblModeCalibr.setVisible(false);
        this.lblModeProg.setVisible(false);
        this.lblStatusStack.setText("-");
        this.lblStatusRequests.setText("-");
        this.lblStatusErrors.setText("-");
    }

    void startWait() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    void endWait() {
        this.setCursor(null);
    }

    public void connected() {
        this.createControls();
        this.pnlMainContent.removeAll();
        this.pnlMainContent.add(this.scroll);
        this.btnConnect.setEnabled(false);
        this.btnDisconnect.setEnabled(true);
        this.pnlStatusStats.setVisible(true);
        this.lblStatusNotConnected.setVisible(false);
        this.repaint();
    }

    public void disconnected(String string) {
        this.pnlMainContent.removeAll();
        this.pnlMainContent.add(this.pnlIntro);
        this.btnConnect.setEnabled(true);
        this.btnDisconnect.setEnabled(false);
        this.pnlStatusStats.setVisible(false);
        this.lblStatusNotConnected.setVisible(true);
        if (string != null) {
            JOptionPane.showMessageDialog(this, string, "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
        }
        this.connection = null;
        this.resetControls();
        this.repaint();
    }

    private void updateRegister(JTextField jTextField, Register register, int n, int n2, boolean bl) {
        String string = "-";
        if (register.isGood()) {
            string = Utils.FormatDouble((double)register.getValue() / (double)n, n2);
        }
        if (bl) {
            jTextField.setBackground("1".equals(string) ? Color.GREEN : null);
        }
        String string2 = null;
        if (register.isWriting()) {
            string2 = Utils.FormatDouble((double)register.writingValue() / (double)n, n2);
        }
        this.updateRegisterText(jTextField, string, string2);
    }

    private void updateRegisterText(JTextField jTextField, String string, String string2) {
        if (!Utils.strEmpty(string2)) {
            string = jTextField.getHorizontalAlignment() == 4 ? string2 + "  -->  " + string : string + "  <--  " + string2;
        }
        if (!string.equals(jTextField.getText())) {
            jTextField.setText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        if (this.connection != null) {
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                this.lblModel.setText("<html><b>" + this.connection.model + "</b></html>");
                this.lblVersion.setText("\u041f\u0440\u043e\u0448\u0438\u0432\u043a\u0430: " + this.connection.version);
                this.lblProgName.setText(this.connection.modeNoProgram ? "" : "<html>\u041f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430: <b>" + this.connection.progName + "</b></html>");
                this.lblModeInit.setVisible(this.connection.modeInit);
                this.lblModeNoProg.setVisible(this.connection.modeNoProgram);
                this.lblModeCalibr.setVisible(this.connection.modeCalibration);
                this.lblModeProg.setVisible(this.connection.modeProgramming);
                this.lblStatusStack.setText(Integer.toString(this.connection.stack));
                this.lblStatusRequests.setText(Integer.toString(this.connection.requestsCount));
                this.lblStatusErrors.setText(Integer.toString(this.connection.errorsCount));
                this.pnlNetParams1.updateData();
                this.pnlNetParams2.updateData();
                this.pnlClockParams.updateData();
                this.pnlDigitalIn.updateData();
                this.pnlAnalogInPt.updateData();
                this.pnlAnalogInNTC.updateData();
                this.pnlAnalogInVolt.updateData();
                this.pnlAnalogOut.updateData();
                this.pnlDigitalOut.updateData();
            }
        }
    }

    public void loadConfig(File file) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        if (this.connection != null) {
            this.connection.stop();
            ConnectionThread connectionThread = this.connection;
            synchronized (connectionThread) {
                try {
                    this.connection.wait(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeConnection();
        this.setDefaultCloseOperation(3);
        Main.props.saveBool(PROP_MAXIMIZE, this.getExtendedState() == 6);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static JButton createButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private static JTextField createRegView(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setEditable(false);
        jTextField.setFocusable(false);
        return jTextField;
    }

    private static JTextField createRegEdit(int n, ActionListener actionListener) {
        JTextField jTextField = new JTextField(n);
        jTextField.addKeyListener(new EnterHandler(actionListener, jTextField));
        return jTextField;
    }

    static RegComboBox createRegCombo(String[] stringArray, KeyListener keyListener) {
        RegComboBox regComboBox = new RegComboBox(stringArray);
        regComboBox.addKeyListener(keyListener);
        regComboBox.setSelectedIndex(0);
        return regComboBox;
    }

    private void writeReg(Register register, int n, int n2, int n3) {
        if (n >= n2 && n <= n3) {
            register.writeValue(n);
        }
    }

    private void writeRegFromTF(Register register, JTextField jTextField, int n, int n2, int n3, JTextField jTextField2) {
        if (jTextField2 != null && jTextField2 != jTextField) {
            return;
        }
        double d = Utils.StringToDouble(jTextField.getText());
        jTextField.setText("");
        if (Double.isNaN(d)) {
            return;
        }
        int n4 = Utils.Round(d * (double)n);
        if (n4 >= n2 && n4 <= n3) {
            register.writeValue(n4);
        }
    }

    private static JTextField[] createRegViews(int n, int n2) {
        JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jTextFieldArray[i] = MainFrame.createRegView(n2);
            jTextFieldArray[i].setHorizontalAlignment(4);
        }
        return jTextFieldArray;
    }

    private static JTextField[] createRegEdits(int n, int n2, ActionListener actionListener) {
        JTextField[] jTextFieldArray = new JTextField[n];
        for (int i = 0; i < n; ++i) {
            jTextFieldArray[i] = MainFrame.createRegEdit(n2, actionListener);
        }
        return jTextFieldArray;
    }

    void resetTF(JTextField[] jTextFieldArray) {
        for (int i = 0; i < jTextFieldArray.length; ++i) {
            jTextFieldArray[i].setText("");
        }
    }

    JLabel jumpersImage(String string, String string2) {
        JLabel jLabel = new JLabel(new ImageIcon(Utils.getResource(string)));
        jLabel.setToolTipText(string2);
        return jLabel;
    }

    class ClockParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener write;
        EnterHandler enter;
        JTextField tfSeconds;
        JTextField tfMinutes;
        JTextField tfHours;
        JTextField tfDayOfWeek;
        JTextField tfDayOfMonth;
        JTextField tfMonth;
        JTextField tfYear;
        JTextField tfSetSecond;
        JTextField tfSetMinute;
        JTextField tfSetHour;
        RegComboBox cbxSetDOW;
        JTextField tfSetDate;
        RegComboBox cbxSetMonth;
        JTextField tfSetYear;
        protected JButton btnWrite;
        protected JButton btnSync;

        public ClockParamsPanel() {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[68], ClockParamsPanel.this.tfSetSecond, 1, 0, 59, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[69], ClockParamsPanel.this.tfSetMinute, 1, 0, 59, null);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[70], ClockParamsPanel.this.tfSetHour, 1, 0, 23, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregs[71], ClockParamsPanel.this.cbxSetDOW.getSelectedIndex(), 1, 7);
                            ClockParamsPanel.this.cbxSetDOW.setSelectedIndex(0);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[72], ClockParamsPanel.this.tfSetDate, 1, 1, 31, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregs[73], ClockParamsPanel.this.cbxSetMonth.getSelectedIndex(), 1, 12);
                            ClockParamsPanel.this.cbxSetMonth.setSelectedIndex(0);
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[74], ClockParamsPanel.this.tfSetYear, 1, 0, 99, null);
                            ClockParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfSeconds = MainFrame.createRegView(14);
            this.tfMinutes = MainFrame.createRegView(14);
            this.tfHours = MainFrame.createRegView(14);
            this.tfDayOfWeek = MainFrame.createRegView(14);
            this.tfDayOfMonth = MainFrame.createRegView(14);
            this.tfMonth = MainFrame.createRegView(14);
            this.tfYear = MainFrame.createRegView(14);
            this.tfSetSecond = MainFrame.createRegEdit(4, this.write);
            this.tfSetMinute = MainFrame.createRegEdit(4, this.write);
            this.tfSetHour = MainFrame.createRegEdit(4, this.write);
            this.cbxSetDOW = MainFrame.createRegCombo(WEEKDAY, this.enter);
            this.tfSetDate = MainFrame.createRegEdit(4, this.write);
            this.cbxSetMonth = MainFrame.createRegCombo(MONTH, this.enter);
            this.tfSetYear = MainFrame.createRegEdit(4, this.write);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.btnSync = MainFrame.createButton("\u0417\u0430\u043f. \u0442\u0435\u043a\u0443\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f", new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Calendar calendar = Calendar.getInstance();
                    ClockParamsPanel.this.tfSetYear.setText(Integer.toString(calendar.get(1) % 100));
                    ClockParamsPanel.this.cbxSetMonth.setSelectedIndex(calendar.get(2) + 1);
                    ClockParamsPanel.this.tfSetDate.setText(Integer.toString(calendar.get(5)));
                    int n = calendar.get(7) - 1;
                    if (n == 0) {
                        n = 7;
                    }
                    ClockParamsPanel.this.cbxSetDOW.setSelectedIndex(n);
                    ClockParamsPanel.this.tfSetHour.setText(Integer.toString(calendar.get(11)));
                    ClockParamsPanel.this.tfSetMinute.setText(Integer.toString(calendar.get(12)));
                    ClockParamsPanel.this.tfSetSecond.setText(Integer.toString(calendar.get(13)));
                    ClockParamsPanel.this.write.actionPerformed(null);
                }
            });
            this.setBorder(BorderFactory.createTitledBorder("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0447\u0430\u0441\u043e\u0432"));
            this.add((Component)new JLabel("\u0413\u043e\u0434:"), "al right");
            this.add((Component)this.tfYear, "");
            this.add((Component)this.tfSetYear, "wrap");
            this.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446:"), "al right");
            this.add((Component)this.tfMonth, "");
            this.add((Component)this.cbxSetMonth, "wrap");
            this.add((Component)new JLabel("\u0414\u0435\u043d\u044c:"), "al right");
            this.add((Component)this.tfDayOfMonth, "");
            this.add((Component)this.tfSetDate, "wrap");
            this.add((Component)new JLabel("\u0414\u0435\u043d\u044c \u043d\u0435\u0434\u0435\u043b\u0438:"), "al right");
            this.add((Component)this.tfDayOfWeek, "");
            this.add((Component)this.cbxSetDOW, "wrap");
            this.add((Component)new JLabel("\u0427\u0430\u0441:"), "al right");
            this.add((Component)this.tfHours, "");
            this.add((Component)this.tfSetHour, "wrap");
            this.add((Component)new JLabel("\u041c\u0438\u043d\u0443\u0442\u0430:"), "al right");
            this.add((Component)this.tfMinutes, "");
            this.add((Component)this.tfSetMinute, "wrap");
            this.add((Component)new JLabel("\u0421\u0435\u043a\u0443\u043d\u0434\u0430:"), "al right");
            this.add((Component)this.tfSeconds, "");
            this.add((Component)this.tfSetSecond, "wrap");
            this.add((Component)this.btnSync, "span 2");
            this.add((Component)this.btnWrite, "");
        }

        public void updateData() {
            if (this.isVisible()) {
                MainFrame.this.updateRegister(this.tfSeconds, MainFrame.this.connection.hregs[68], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMinutes, MainFrame.this.connection.hregs[69], 1, 0, false);
                MainFrame.this.updateRegister(this.tfHours, MainFrame.this.connection.hregs[70], 1, 0, false);
                MainFrame.this.updateRegister(this.tfDayOfWeek, MainFrame.this.connection.hregs[71], 1, 0, false);
                int n = Utils.StringToIntDef(this.tfDayOfWeek.getText(), -1);
                if (n > 0 && n < WEEKDAY.length) {
                    this.tfDayOfWeek.setText(WEEKDAY[n]);
                }
                MainFrame.this.updateRegister(this.tfDayOfMonth, MainFrame.this.connection.hregs[72], 1, 0, false);
                MainFrame.this.updateRegister(this.tfMonth, MainFrame.this.connection.hregs[73], 1, 0, false);
                n = Utils.StringToIntDef(this.tfMonth.getText(), -1);
                if (n > 0 && n < MONTH.length) {
                    this.tfMonth.setText(MONTH[n]);
                }
                MainFrame.this.updateRegister(this.tfYear, MainFrame.this.connection.hregs[74], 1, 0, false);
            }
        }
    }

    class NetParamsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final int startAddr;
        ActionListener write;
        EnterHandler enter;
        JTextField tfNetId;
        JTextField tfNetSpeed;
        JTextField tfNetParity;
        JTextField tfNetStopBits;
        JTextField tfSetNetId;
        RegComboBox cbxSetNetSpeed;
        RegComboBox cbxSetNetParity;
        RegComboBox cbxSetNetStopBits;
        protected JButton btnWrite;

        public NetParamsPanel(int n, String string) {
            super(new MigLayout("", "", ""));
            this.write = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[NetParamsPanel.this.startAddr], NetParamsPanel.this.tfSetNetId, 1, 1, 254, null);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregs[NetParamsPanel.this.startAddr + 1], NetParamsPanel.this.cbxSetNetSpeed.getSelectedIndex() - 1, 0, 5);
                            NetParamsPanel.this.cbxSetNetSpeed.setSelectedIndex(0);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregs[NetParamsPanel.this.startAddr + 3], NetParamsPanel.this.cbxSetNetParity.getSelectedIndex() - 1, 0, 2);
                            NetParamsPanel.this.cbxSetNetParity.setSelectedIndex(0);
                            MainFrame.this.writeReg(MainFrame.this.connection.hregs[NetParamsPanel.this.startAddr + 2], NetParamsPanel.this.cbxSetNetStopBits.getSelectedIndex(), 1, 2);
                            NetParamsPanel.this.cbxSetNetStopBits.setSelectedIndex(0);
                            NetParamsPanel.this.updateData();
                        }
                    }
                }
            };
            this.enter = new EnterHandler(this.write, null);
            this.tfNetId = MainFrame.createRegView(14);
            this.tfNetSpeed = MainFrame.createRegView(14);
            this.tfNetParity = MainFrame.createRegView(14);
            this.tfNetStopBits = MainFrame.createRegView(14);
            this.tfSetNetId = MainFrame.createRegEdit(4, this.write);
            this.cbxSetNetSpeed = MainFrame.createRegCombo(SPEED, this.enter);
            this.cbxSetNetParity = MainFrame.createRegCombo(PARITY, this.enter);
            this.cbxSetNetStopBits = MainFrame.createRegCombo(STOP_BITS, this.enter);
            this.btnWrite = MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c", this.write);
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.startAddr = n;
            this.add((Component)new JLabel("\u0410\u0434\u0440\u0435\u0441:"), "al right");
            this.add((Component)this.tfNetId, "");
            this.add((Component)this.tfSetNetId, "wrap");
            this.add((Component)new JLabel("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c:"), "al right");
            this.add((Component)this.tfNetSpeed, "");
            this.add((Component)this.cbxSetNetSpeed, "wrap");
            this.add((Component)new JLabel("\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c \u0447\u0435\u0442\u043d\u043e\u0441\u0442\u0438:"), "al right");
            this.add((Component)this.tfNetParity, "");
            this.add((Component)this.cbxSetNetParity, "wrap");
            this.add((Component)new JLabel("\u0421\u0442\u043e\u043f-\u0431\u0438\u0442\u044b:"), "al right");
            this.add((Component)this.tfNetStopBits, "");
            this.add((Component)this.cbxSetNetStopBits, "wrap");
            this.add((Component)this.btnWrite, "skip 1");
        }

        private String parityString(int n) {
            if (++n >= 0 && n < PARITY.length) {
                return PARITY[n];
            }
            return Integer.toString(n);
        }

        public void updateData() {
            if (this.isVisible()) {
                Register register;
                MainFrame.this.updateRegister(this.tfNetId, MainFrame.this.connection.hregs[this.startAddr], 1, 0, false);
                MainFrame.this.updateRegister(this.tfNetSpeed, MainFrame.this.connection.hregs[this.startAddr + 1], 1, 0, false);
                int n = Utils.StringToIntDef(this.tfNetSpeed.getText(), -1);
                if (n >= 0 && n < SPEED.length - 1) {
                    this.tfNetSpeed.setText(SPEED[n + 1]);
                }
                MainFrame.this.updateRegisterText(this.tfNetParity, (register = MainFrame.this.connection.hregs[this.startAddr + 3]).isGood() ? this.parityString(register.getValue()) : "-", register.needWrite ? this.parityString(register.writingValue()) : null);
                MainFrame.this.updateRegister(this.tfNetStopBits, MainFrame.this.connection.hregs[this.startAddr + 2], 1, 0, false);
            }
        }
    }

    class UpDownHandler
    extends KeyAdapter {
        private final int regAddr;
        private final JTextField tf;

        public UpDownHandler(int n, JTextField jTextField) {
            this.regAddr = n;
            this.tf = jTextField;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void incRegValue(int n) {
            if (MainFrame.this.connection != null) {
                Register register = MainFrame.this.connection.hregs[this.regAddr];
                ConnectionThread connectionThread = MainFrame.this.connection;
                synchronized (connectionThread) {
                    if (register.isGood()) {
                        int n2 = Utils.StringToIntDef(this.tf.getText(), -1);
                        if (n2 < 0) {
                            int n3 = n2 = register.needWrite ? register.valueToWrite : register.getValue();
                        }
                        if ((n2 += n) >= 0 && n2 <= 1023) {
                            register.writeValue(n2);
                            this.tf.setText(Integer.toString(n2));
                        }
                    }
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 38) {
                this.incRegValue(keyEvent.isControlDown() ? 10 : 1);
            }
            if (keyEvent.getKeyCode() == 40) {
                this.incRegValue(keyEvent.isControlDown() ? -10 : -1);
            }
            if (keyEvent.getKeyCode() == 27) {
                this.tf.setText("");
            }
        }
    }

    class AOutputsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JTextField[] tfOut;
        JTextField[] tfDAC;
        JTextField[] tfW;
        JTextField[] tfSetDAC;
        JTextField[] tfSetW;
        JTextField[] tfSetOut;

        public AOutputsPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < MainFrame.this.connection.actualAoCount; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[52 + i], AOutputsPanel.this.tfSetOut[i], 100, 0, 1200, jTextField);
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[40 + i], AOutputsPanel.this.tfSetDAC[i], 1, 0, 65535, jTextField);
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[46 + i], AOutputsPanel.this.tfSetW[i], 1, 0, 65535, jTextField);
                            }
                            AOutputsPanel.this.updateData();
                        }
                    }
                }
            };
            this.tfOut = MainFrame.createRegViews(4, 10);
            this.tfDAC = MainFrame.createRegViews(4, 10);
            this.tfW = MainFrame.createRegViews(4, 10);
            this.tfSetDAC = MainFrame.createRegEdits(4, 6, this.writeData);
            this.tfSetW = MainFrame.createRegEdits(4, 5, this.writeData);
            this.tfSetOut = MainFrame.createRegEdits(4, 5, this.writeData);
            this.setBorder(BorderFactory.createTitledBorder("\u0410\u043d\u0430\u043b\u043e\u0433\u043e\u0432\u044b\u0435 \u0432\u044b\u0445\u043e\u0434\u044b"));
            this.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435, \u0412"), "skip 1, span 2, al right");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0426\u0410\u041f"), "span 2, al right");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u043e\u0432\u043a\u0430 W"), "span 2, al right, wrap");
            }
            for (int i = 0; i < 4; ++i) {
                this.add((Component)new JLabel("AO" + (i + 1) + ": "), MainFrame.this.calibration ? "al right" : "al right, newline");
                this.add((Component)this.tfOut[i], "");
                if (!MainFrame.this.calibration) continue;
                this.add((Component)this.tfSetOut[i], "");
                this.add((Component)this.tfDAC[i], "");
                this.add((Component)this.tfSetDAC[i], "");
                this.tfSetDAC[i].addKeyListener(new UpDownHandler(40 + i, this.tfSetDAC[i]));
                this.add((Component)this.tfW[i], "");
                this.add((Component)this.tfSetW[i], "");
                this.add((Component)MainFrame.createButton("<-", new CopyAction(this.tfDAC[i], this.tfSetW[i])), "wrap");
            }
            if (MainFrame.this.calibration) {
                this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0432\u0441\u0435", this.writeData), "span, al right");
            }
        }

        public void updateData() {
            if (this.isVisible()) {
                int n;
                for (n = 0; n < this.tfOut.length; ++n) {
                    MainFrame.this.updateRegister(this.tfOut[n], MainFrame.this.connection.hregs[52 + n], 100, 2, false);
                }
                for (n = 0; n < this.tfDAC.length; ++n) {
                    MainFrame.this.updateRegister(this.tfDAC[n], MainFrame.this.connection.hregs[40 + n], 1, 0, false);
                }
                for (n = 0; n < this.tfW.length; ++n) {
                    MainFrame.this.updateRegister(this.tfW[n], MainFrame.this.connection.hregs[46 + n], 1, 0, false);
                }
            }
        }
    }

    class DOutputsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener coilsOn;
        ActionListener coilsOff;
        JTextField[] tfCoils;

        public DOutputsPanel() {
            JButton jButton;
            super(new MigLayout("", "", ""));
            this.coilsOn = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            for (int i = 0; i < MainFrame.this.connection.coils.length; ++i) {
                                MainFrame.this.writeReg(MainFrame.this.connection.coils[i], 1, 0, 1);
                            }
                            DOutputsPanel.this.updateData();
                        }
                    }
                }
            };
            this.coilsOff = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            for (int i = 0; i < MainFrame.this.connection.coils.length; ++i) {
                                MainFrame.this.writeReg(MainFrame.this.connection.coils[i], 0, 0, 1);
                            }
                            DOutputsPanel.this.updateData();
                        }
                    }
                }
            };
            this.tfCoils = MainFrame.createRegViews(7, 7);
            this.setBorder(BorderFactory.createTitledBorder("\u0414\u0438\u0441\u043a\u0440\u0435\u0442\u043d\u044b\u0435 \u0432\u044b\u0445\u043e\u0434\u044b"));
            for (int i = 0; i < 7; ++i) {
                this.add((Component)new JLabel((i < 5 ? "DO" + (i + 1) : "FDO" + (i - 5 + 1)) + ": "), "al right");
                this.add((Component)this.tfCoils[i], MainFrame.this.calibration ? "" : "wrap");
                if (!MainFrame.this.calibration) continue;
                jButton = new JButton("1/0");
                jButton.addActionListener(new CoilAction(i));
                this.add((Component)jButton, "wrap");
            }
            if (MainFrame.this.calibration) {
                JPanel jPanel = new JPanel(new MigLayout("", "", ""));
                jButton = new JButton("\u0412\u0441\u0435 1");
                jButton.addActionListener(this.coilsOn);
                jPanel.add((Component)jButton, "");
                jButton = new JButton("\u0412\u0441\u0435 0");
                jButton.addActionListener(this.coilsOff);
                jPanel.add((Component)jButton, "");
                this.add((Component)jPanel, "span, al center");
            }
        }

        public void updateData() {
            if (this.isVisible() && this.isVisible()) {
                for (int i = 0; i < this.tfCoils.length; ++i) {
                    MainFrame.this.updateRegister(this.tfCoils[i], MainFrame.this.connection.coils[i], 1, 0, true);
                }
            }
        }

        class CoilAction
        implements ActionListener {
            final int address;

            public CoilAction(int n) {
                this.address = n;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.connection != null) {
                    ConnectionThread connectionThread = MainFrame.this.connection;
                    synchronized (connectionThread) {
                        Register register = MainFrame.this.connection.coils[this.address];
                        int n = register.getValue();
                        MainFrame.this.writeReg(register, n == 0 ? 1 : 0, 0, 1);
                        DOutputsPanel.this.updateData();
                    }
                }
            }
        }
    }

    class DInputsPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField[] tfDI;

        public DInputsPanel(int n) {
            super(new MigLayout("", "[][]20[][]", ""));
            this.tfDI = MainFrame.createRegViews(12, 4);
            this.setBorder(BorderFactory.createTitledBorder("\u0414\u0438\u0441\u043a\u0440\u0435\u0442\u043d\u044b\u0435 \u0432\u0445\u043e\u0434\u044b"));
            this.add((Component)MainFrame.this.jumpersImage("pt1000.png", "\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u0435\u043a \u0434\u043b\u044f \u0434\u0438\u0441\u043a\u0440\u0435\u0442\u043d\u043e\u0433\u043e \u0432\u0445\u043e\u0434\u0430"), "al left");
            this.add((Component)new JLabel("\u043f\u0435\u0440\u0435\u043c\u044b\u0447\u043a\u0438 - \u043a\u0430\u043a Pt1000"), "span, al right, wrap");
            for (int i = 0; i < Math.min(n, this.tfDI.length); ++i) {
                if (i + n < this.tfDI.length) {
                    this.add((Component)new JLabel("DI" + (i + 1) + ": "), "al right");
                    this.add((Component)this.tfDI[i], "");
                    this.add((Component)new JLabel("DI" + (i + n + 1) + ": "), "al right");
                    this.add((Component)this.tfDI[i + n], "wrap");
                    continue;
                }
                this.add((Component)new JLabel("DI" + (i + 1) + ": "), "al right");
                this.add((Component)this.tfDI[i], "wrap");
            }
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 0; i < MainFrame.this.connection.actualDiCount; ++i) {
                    MainFrame.this.updateRegister(this.tfDI[i], MainFrame.this.connection.dinputs[i], 1, 0, true);
                }
            }
        }
    }

    class AInputsVoltPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JTextField[] tfVoltage;
        JTextField[] tfADCVolt;
        JTextField[] tfCalVolt;
        JTextField[] tfSetVolt;

        public AInputsVoltPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < MainFrame.this.connection.actualAiCount; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[32 + i], AInputsVoltPanel.this.tfSetVolt[i], 1, 0, 65535, jTextField);
                            }
                            AInputsVoltPanel.this.updateData();
                        }
                    }
                }
            };
            this.tfVoltage = MainFrame.createRegViews(8, MainFrame.this.calibration ? 4 : 8);
            this.tfADCVolt = MainFrame.createRegViews(8, 5);
            this.tfCalVolt = MainFrame.createRegViews(8, 10);
            this.tfSetVolt = MainFrame.createRegEdits(8, 5, this.writeData);
            this.setBorder(BorderFactory.createTitledBorder("\u0410\u043d. \u0432\u0445\u043e\u0434\u044b 0-10 \u0412"));
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("<html><b>U =  10 \u0412</b></html>"), "skip 3, span 3, al center, wrap");
            }
            this.add((Component)MainFrame.this.jumpersImage("volts.png", "\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u0435\u043a \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u044f"), "al left");
            this.add((Component)new JLabel("\u041d\u0430\u043f\u0440., \u0412"), MainFrame.this.calibration ? "al center" : "al center, wrap");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u0410\u0426\u041f"), "al center");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 U"), "span 3, al right, wrap");
            }
            for (int i = 0; i < 8; ++i) {
                this.add((Component)new JLabel("AI" + (i + 1) + ": "), "al right");
                this.add((Component)this.tfVoltage[i], MainFrame.this.calibration ? "" : "wrap");
                if (!MainFrame.this.calibration) continue;
                this.add((Component)this.tfADCVolt[i], "");
                this.add((Component)this.tfCalVolt[i], "");
                this.add((Component)this.tfSetVolt[i], "");
                this.add((Component)MainFrame.createButton("<-", new CopyAction(this.tfADCVolt[i], this.tfSetVolt[i])), "wrap");
            }
            if (MainFrame.this.calibration) {
                this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0432\u0441\u0435", this.writeData), "span, al right");
            }
        }

        public void reset() {
            MainFrame.this.resetTF(this.tfSetVolt);
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 0; i < MainFrame.this.connection.actualAiCount; ++i) {
                    MainFrame.this.updateRegister(this.tfVoltage[i], MainFrame.this.connection.iregs[24 + i], 100, 2, false);
                    if (!MainFrame.this.calibration) continue;
                    MainFrame.this.updateRegister(this.tfADCVolt[i], MainFrame.this.connection.iregs[0 + i], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfCalVolt[i], MainFrame.this.connection.hregs[32 + i], 1, 0, false);
                }
            }
        }
    }

    class AInputsNTCPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JTextField[] tfTempNTC;
        JTextField[] tfADCNTC;
        JTextField[] tfR1NTC;
        JTextField[] tfR2NTC;
        JTextField[] tfSetR1NTC;
        JTextField[] tfSetR2NTC;

        public AInputsNTCPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < MainFrame.this.connection.actualAiCount; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[24 + i], AInputsNTCPanel.this.tfSetR1NTC[i], 1, 0, 65535, jTextField);
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[8 + i], AInputsNTCPanel.this.tfSetR2NTC[i], 1, 0, 65535, jTextField);
                            }
                            AInputsNTCPanel.this.updateData();
                        }
                    }
                }
            };
            this.tfTempNTC = MainFrame.createRegViews(8, MainFrame.this.calibration ? 4 : 8);
            this.tfADCNTC = MainFrame.createRegViews(8, 5);
            this.tfR1NTC = MainFrame.createRegViews(8, 10);
            this.tfR2NTC = MainFrame.createRegViews(8, 10);
            this.tfSetR1NTC = MainFrame.createRegEdits(8, 5, this.writeData);
            this.tfSetR2NTC = MainFrame.createRegEdits(8, 5, this.writeData);
            this.setBorder(BorderFactory.createTitledBorder("\u0410\u043d. \u0432\u0445\u043e\u0434\u044b NTC 10k"));
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("<html><b>R1 =  842,7 \u041e\u043c</b> (&gt;105 \u00b0C)</html>"), "skip 3, span 3, al center");
                this.add((Component)new JLabel("<html><b>R\u221e</b> (&lt;-40 \u00b0C)</html>"), "skip 1, span 3, al center, wrap");
            }
            this.add((Component)MainFrame.this.jumpersImage("ntc.png", "\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u0435\u043a \u0434\u043b\u044f \u0434\u0430\u0442\u0447\u0438\u043a\u0430 NTC"), "al left");
            this.add((Component)new JLabel("\u0422\u0435\u043c\u043f., \u00b0C"), MainFrame.this.calibration ? "al center" : "al center, wrap");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u0410\u0426\u041f"), "al center");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 R1"), "span 3, al right");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 R\u221e"), "span 4, al right, wrap");
            }
            for (int i = 0; i < 8; ++i) {
                this.add((Component)new JLabel("AI" + (i + 1) + ": "), "al right");
                this.add((Component)this.tfTempNTC[i], MainFrame.this.calibration ? "" : "wrap");
                if (!MainFrame.this.calibration) continue;
                this.add((Component)this.tfADCNTC[i], "");
                this.add((Component)this.tfR1NTC[i], "");
                this.add((Component)this.tfSetR1NTC[i], "");
                this.add((Component)MainFrame.createButton("<-", new CopyAction(this.tfADCNTC[i], this.tfSetR1NTC[i])), "");
                this.add((Component)this.tfR2NTC[i], "skip 1");
                this.add((Component)this.tfSetR2NTC[i], "");
                this.add((Component)MainFrame.createButton("<-", new CopyAction(this.tfADCNTC[i], this.tfSetR2NTC[i])), "wrap");
            }
            if (MainFrame.this.calibration) {
                this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0432\u0441\u0435", this.writeData), "span, al right");
            }
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 0; i < MainFrame.this.connection.actualAiCount; ++i) {
                    MainFrame.this.updateRegister(this.tfTempNTC[i], MainFrame.this.connection.iregs[16 + i], 10, 1, false);
                    if (!MainFrame.this.calibration) continue;
                    MainFrame.this.updateRegister(this.tfADCNTC[i], MainFrame.this.connection.iregs[0 + i], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfR1NTC[i], MainFrame.this.connection.hregs[24 + i], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfR2NTC[i], MainFrame.this.connection.hregs[8 + i], 1, 0, false);
                }
            }
        }
    }

    class AInputsPtPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        ActionListener writeData;
        JTextField[] tfTempPt;
        JTextField[] tfADCPt;
        JTextField[] tfR1Pt;
        JTextField[] tfR2Pt;
        JTextField[] tfSetR1Pt;
        JTextField[] tfSetR2Pt;

        public AInputsPtPanel() {
            super(new MigLayout("", "", ""));
            this.writeData = new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (MainFrame.this.connection != null) {
                        ConnectionThread connectionThread = MainFrame.this.connection;
                        synchronized (connectionThread) {
                            JTextField jTextField = actionEvent != null ? (actionEvent.getSource() instanceof JTextField ? (JTextField)actionEvent.getSource() : null) : null;
                            for (int i = 0; i < MainFrame.this.connection.actualAiCount; ++i) {
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[16 + i], AInputsPtPanel.this.tfSetR1Pt[i], 1, 0, 65535, jTextField);
                                MainFrame.this.writeRegFromTF(MainFrame.this.connection.hregs[0 + i], AInputsPtPanel.this.tfSetR2Pt[i], 1, 0, 65535, jTextField);
                            }
                            AInputsPtPanel.this.updateData();
                        }
                    }
                }
            };
            this.tfTempPt = MainFrame.createRegViews(8, MainFrame.this.calibration ? 4 : 8);
            this.tfADCPt = MainFrame.createRegViews(8, 5);
            this.tfR1Pt = MainFrame.createRegViews(8, 10);
            this.tfR2Pt = MainFrame.createRegViews(8, 10);
            this.tfSetR1Pt = MainFrame.createRegEdits(8, 5, this.writeData);
            this.tfSetR2Pt = MainFrame.createRegEdits(8, 5, this.writeData);
            this.setBorder(BorderFactory.createTitledBorder("\u0410\u043d. \u0432\u0445\u043e\u0434\u044b Pt1000"));
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("<html><b>R1 =  842,7 \u041e\u043c</b> (-40 \u00b0C)</html>"), "skip 3, span 3, al center");
                this.add((Component)new JLabel("<html><b>R2 = 1535,8 \u041e\u043c</b> (140 \u00b0C)</html>"), "skip 1, span 3, al center, wrap");
            }
            this.add((Component)MainFrame.this.jumpersImage("pt1000.png", "\u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u044b\u0447\u0435\u043a \u0434\u043b\u044f \u0434\u0430\u0442\u0447\u0438\u043a\u0430 Pt1000"), "al left");
            this.add((Component)new JLabel("\u0422\u0435\u043c\u043f., \u00b0C"), MainFrame.this.calibration ? "al center" : "al center, wrap");
            if (MainFrame.this.calibration) {
                this.add((Component)new JLabel("\u0410\u0426\u041f"), "al center");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 R1"), "span 3, al right");
                this.add((Component)new JLabel("\u041a\u0430\u043b\u0438\u0431\u0440\u043e\u0432\u043a\u0430 R2"), "span 4, al right, wrap");
            }
            for (int i = 0; i < 8; ++i) {
                this.add((Component)new JLabel("AI" + (i + 1) + ": "), "al right");
                this.add((Component)this.tfTempPt[i], MainFrame.this.calibration ? "" : "wrap");
                if (!MainFrame.this.calibration) continue;
                this.add((Component)this.tfADCPt[i], "");
                this.add((Component)this.tfR1Pt[i], "");
                this.add((Component)this.tfSetR1Pt[i], "");
                this.add((Component)MainFrame.createButton("<-", new CopyAction(this.tfADCPt[i], this.tfSetR1Pt[i])), "");
                this.add((Component)this.tfR2Pt[i], "skip 1");
                this.add((Component)this.tfSetR2Pt[i], "");
                this.add((Component)MainFrame.createButton("<-", new CopyAction(this.tfADCPt[i], this.tfSetR2Pt[i])), "wrap");
            }
            if (MainFrame.this.calibration) {
                this.add((Component)MainFrame.createButton("\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c \u0432\u0441\u0435", this.writeData), "span, al right");
            }
        }

        public void updateData() {
            if (this.isVisible()) {
                for (int i = 0; i < MainFrame.this.connection.actualAiCount; ++i) {
                    MainFrame.this.updateRegister(this.tfTempPt[i], MainFrame.this.connection.iregs[8 + i], 10, 1, false);
                    if (!MainFrame.this.calibration) continue;
                    MainFrame.this.updateRegister(this.tfADCPt[i], MainFrame.this.connection.iregs[0 + i], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfR1Pt[i], MainFrame.this.connection.hregs[16 + i], 1, 0, false);
                    MainFrame.this.updateRegister(this.tfR2Pt[i], MainFrame.this.connection.hregs[0 + i], 1, 0, false);
                }
            }
        }
    }

    class CopyAction
    implements ActionListener {
        final JTextField src;
        final JTextField tgt;

        CopyAction(JTextField jTextField, JTextField jTextField2) {
            this.src = jTextField;
            this.tgt = jTextField2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.tgt.setText(this.src.getText());
            this.tgt.requestFocusInWindow();
        }
    }
}

